/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.gui.util.treetable.AbstractTreeTableModel;
import com.bwanms.gui.util.treetable.TreeTableModel;
import com.bwanms.rb.gui.managers.GPSChainManagerConfig;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbGPSChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSManagerTreeModel
extends AbstractTreeTableModel {
    public GPSManagerTreeModel() {
        super((Object)new DefaultMutableTreeNode("root"));
    }

    public void setChainClusters(List<RbGPSChain> rbGPSChains) {
        ((DefaultMutableTreeNode)this.root).removeAllChildren();
        for (RbGPSChain cc : rbGPSChains) {
            DefaultMutableTreeNode chainClusterNode = new DefaultMutableTreeNode(cc);
            ArrayList<RbBaseStationEquipment> bsEquipmentList = new ArrayList<RbBaseStationEquipment>(cc.getEquipmentList());
            Collections.sort(bsEquipmentList, new Comparator<RbBaseStationEquipment>(){

                @Override
                public int compare(RbBaseStationEquipment o1, RbBaseStationEquipment o2) {
                    return o1.getGpsClockMode().compareTo(o2.getGpsClockMode());
                }
            });
            for (RbBaseStationEquipment bsEquipment : bsEquipmentList) {
                chainClusterNode.add(new DefaultMutableTreeNode((Object)bsEquipment));
            }
            ((DefaultMutableTreeNode)this.root).add(chainClusterNode);
        }
        this.fireTreeStructureChanged((Object)this, ((DefaultMutableTreeNode)this.root).getPath(), null, null);
    }

    public void addChainCluster(RbGPSChain newChainCluster) {
        ((DefaultMutableTreeNode)this.root).add(new DefaultMutableTreeNode(newChainCluster));
        this.fireTreeStructureChanged((Object)this, ((DefaultMutableTreeNode)this.root).getPath(), null, null);
    }

    public void removeChainCluster(RbGPSChain rbGPSChain) {
        Enumeration<TreeNode> childrenEnum = ((DefaultMutableTreeNode)this.root).children();
        while (childrenEnum.hasMoreElements()) {
            DefaultMutableTreeNode chainClusterNode = (DefaultMutableTreeNode)childrenEnum.nextElement();
            if (!chainClusterNode.getUserObject().equals(rbGPSChain)) continue;
            ((DefaultMutableTreeNode)this.root).remove(chainClusterNode);
            break;
        }
        this.fireTreeStructureChanged((Object)this, ((DefaultMutableTreeNode)this.root).getPath(), null, null);
    }

    public Object getRoot() {
        return this.root;
    }

    public TreeNode getChild(Object parent, int index) {
        if (parent instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)parent).getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)parent).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)node).isLeaf();
        }
        return true;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DefaultMutableTreeNode && child instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)parent).getIndex((DefaultMutableTreeNode)child);
        }
        return 0;
    }

    public int getColumnCount() {
        return GPSChainManagerConfig.columnNames.length;
    }

    public String getColumnName(int column) {
        return GPSChainManagerConfig.i18n.translateString(GPSChainManagerConfig.columnNames[column]);
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof RbGPSChain) {
                RbGPSChain rbGPSChain = (RbGPSChain)userObject;
                switch (column) {
                    case 0: {
                        return rbGPSChain.toString();
                    }
                    case 1: {
                        return GPSChainManagerConfig.i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(rbGPSChain.getStopTxAfterHoldOverTimeout()));
                    }
                    case 2: {
                        return rbGPSChain.getHoldOverPassedTimeout();
                    }
                    case 3: {
                        return GPSChainManagerConfig.i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(rbGPSChain.getGpsType()));
                    }
                    case 4: {
                        return rbGPSChain.getTimeZoneOffsetFromUTC();
                    }
                }
            } else if (userObject instanceof RbBaseStationEquipment) {
                RbBaseStationEquipment bsEquipment = (RbBaseStationEquipment)((Object)userObject);
                switch (column) {
                    case 0: {
                        return GPSChainManagerConfig.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentClockMode(bsEquipment.getGpsClockMode())) + " (" + bsEquipment.getName() + "/" + bsEquipment.getIPAddress() + ")";
                    }
                    case 5: {
                        return bsEquipment.getGpsLatitude();
                    }
                    case 6: {
                        return bsEquipment.getGpsLongitude();
                    }
                    case 7: {
                        return bsEquipment.getGpsAltitude();
                    }
                }
            }
        }
        return "";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return Object.class;
    }
}

