/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.util.treetable.TreeTableModelAdapter;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.Assembly;
import com.bwanms.rb.gui.gpschain.GPSChainEditorContainer;
import com.bwanms.rb.gui.managers.GPSManagerTreeTableResultsView;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbGPSChain;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSChainManagerConfig
extends EntityManagerConfig {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(GPSChainManagerConfig.class);
    private static final Logger logger = Logger.getLogger(GPSChainManagerConfig.class);
    private GPSManagerTreeTableResultsView gpsManagerResultsView;
    static String[] columnNames = new String[]{"gpsChainNumber", "stopTxAfterHoldOverTimeout", "holdOverPassedTimeout", "gpsType", "timeZoneOffsetFromUTC"};
    static String[] columnAttribNames = new String[]{"gpsChainNumber", "stopTxAfterHoldOverTimeout", "holdOverPassedTimeout", "gpsType", "timeZoneOffsetFromUTC"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public GPSChainManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(4)));
        this.entityRowProvider = new RbGPSChainManagerRowProvider(GPSChainManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("gpsChainNumber"), "gpsChainNumber", 1, 1, null, false));
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)2, i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(1))));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("stopTxAfterHoldOverTimeout"), "stopTxAfterHoldOverTimeout", 2, 3, items, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("holdOverPassedTimeout"), "holdOverPassedTimeout", 1, 1, null, false));
        items = new Vector();
        items.add(new ComboItem((Object)0, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(0))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(1))));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("gpsType"), "gpsType", 2, 3, items, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("timeZoneOffsetFromUTC"), "timeZoneOffsetFromUTC", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new GPSChainManagerAction("New", 1));
        this.defaultAction = new GPSChainManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new GPSChainManagerAction("Delete", 1));
    }

    protected String getBaseName() {
        return RbGPSChain.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public String getTitle() {
        return i18n.translateString("GPSChainManager");
    }

    public ManagerResultsView getResultsView() {
        this.gpsManagerResultsView = new GPSManagerTreeTableResultsView();
        return this.gpsManagerResultsView;
    }

    public String getHelpTopic() {
        return "rb_gps_chain_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbGPSChainManagerRowProvider
    extends DefaultRowCreator {
        public RbGPSChainManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        public String readEntityId(Serializable entity) {
            return String.valueOf(((RbGPSChain)entity).getId());
        }

        protected List<Serializable> readAttributeValues(Serializable entity) {
            Hibernate.initialize(((RbGPSChain)entity).getEquipmentList());
            return super.readAttributeValues(entity);
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List ret = super.getDisplayValues(entityRow);
            RbGPSChain gpsChain = (RbGPSChain)entityRow.getEntity();
            ret.set(1, i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(gpsChain.getStopTxAfterHoldOverTimeout())));
            ret.set(3, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(gpsChain.getGpsType())));
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GPSChainManagerAction
    extends ManagerAction {
        public GPSChainManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        public void performAction(final ManagerView manager) {
            List selection = manager.getSelection();
            if ("New".equals(this.name)) {
                try {
                    GPSChainEditorContainer gpsChainEditorContainer = new GPSChainEditorContainer(new RbGPSChain());
                    gpsChainEditorContainer.setCleanupCallback(new GPSChainEditorContainer.CleanupCallback(){

                        public void doAditionalCleanup() {
                            manager.performQuery();
                            ((TreeTableModelAdapter)GPSChainManagerConfig.this.gpsManagerResultsView.getUI().getLicenseTreeTable().getModel()).fireTableDataChanged();
                        }
                    });
                }
                catch (ServiceException e) {
                    MessageBox.Error.quickShow((Component)manager.getUI(), e.getMessage());
                }
            } else if ("Open".equals(this.name) && 1 == selection.size()) {
                if (selection.get(0) instanceof RbGPSChain) {
                    try {
                        GPSChainEditorContainer gpsChainEditorContainer = new GPSChainEditorContainer((RbGPSChain)selection.get(0));
                        gpsChainEditorContainer.setCleanupCallback(new GPSChainEditorContainer.CleanupCallback(){

                            public void doAditionalCleanup() {
                                manager.performQuery();
                                ((TreeTableModelAdapter)GPSChainManagerConfig.this.gpsManagerResultsView.getUI().getLicenseTreeTable().getModel()).fireTableDataChanged();
                            }
                        });
                    }
                    catch (ServiceException e) {
                        MessageBox.Error.quickShow((Component)manager.getUI(), e.getMessage());
                    }
                } else {
                    RbBaseStationEquipment bsEquipment = (RbBaseStationEquipment)((Object)selection.get(0));
                    ConfigApplicationView configAppView = new ConfigApplicationView((Equipment)bsEquipment, "Configuration");
                    if (null == configAppView.getConfiguration()) {
                        throw new RuntimeException("Configuration does not exist for equipment with euid = " + bsEquipment.getEUID());
                    }
                    configAppView.fireAction("bwanms://config/" + bsEquipment.getEUID() + "/GPS/");
                    IpAddress ip = new IpAddress(bsEquipment.getIpAddr().longValue());
                    JFrame frame = FrameUtil.createModalFrame(null, (boolean)true);
                    FrameUtil.runFrame((JFrame)frame, (String)AbstractEquipmentManagerConfig.i18n.translateString("ConfiguringEquipment", new Object[]{bsEquipment.getName(), ip.toString()}), (View)configAppView, (int)1024, (int)768, (boolean)true);
                }
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult((Component)manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                for (Serializable serializable : selection) {
                    if (!(serializable instanceof RbGPSChain)) continue;
                    RbGPSChain gpsChain = (RbGPSChain)serializable;
                    try {
                        Assembly gpsChainAssembly = ServiceRegistry.getEntityManagerService().get(RbGPSChain.class, gpsChain.getId(), "editor");
                        logger.debug((Object)"Delete Chain: assembly retrieved.");
                        if (!((RbGPSChain)gpsChainAssembly.getEntity()).getEquipmentList().isEmpty()) {
                            MessageBox.Error.quickShow((Component)manager.getUI(), i18n.translateString("GPSChainIsNotEmpty"));
                            return;
                        }
                        ServiceRegistry.getEntityManagerService().delete(gpsChainAssembly.getEntity());
                        logger.debug((Object)"Delete Chain: deleted.");
                        if (manager instanceof EntityChangeListener) {
                            ((EntityChangeListener)manager).entityRemoved(gpsChainAssembly.getEntity());
                            logger.debug((Object)"Delete Chain: entityRemoved.");
                        }
                        logger.debug((Object)"Delete Chain: Done.");
                    }
                    catch (Exception e) {
                        MessageBox.Error.quickShow((Component)manager.getUI(), e.getMessage());
                    }
                }
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("Open")) {
                    if (1 == selectionSize && selection.get(0) instanceof RbGPSChain && ((RbGPSChain)selection.get(0)).getGpsChainNumber() != 0L) {
                        return true;
                    }
                    if (1 == selectionSize && selection.get(0) instanceof RbBaseStationEquipment) {
                        RbBaseStationEquipment eq = (RbBaseStationEquipment)((Object)selection.get(0));
                        return eq != null && eq.getFirmwareVersion() != null && !"".equals(eq.getFirmwareVersion()) && eq.getState() == 0 && LicenseClient.getInstance().isLicensed((Object)eq);
                    }
                    return false;
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                        return false;
                    }
                    boolean oneGPSChain = false;
                    boolean oneGPSChainNotEmpty = false;
                    boolean oneEquipment = false;
                    for (Serializable entity : selection) {
                        if (entity instanceof RbGPSChain) {
                            oneGPSChain = true;
                            RbGPSChain rbGPSChain = (RbGPSChain)entity;
                            if (rbGPSChain.getEquipmentList() == null || rbGPSChain.getEquipmentList().size() <= 0) continue;
                            oneGPSChainNotEmpty = true;
                            continue;
                        }
                        oneEquipment = true;
                    }
                    return oneGPSChain && !oneGPSChainNotEmpty && !oneEquipment;
                }
            }
            return true;
        }
    }
}

