/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.rb.gui.inventory.chasis.BMAXChasis;
import com.bwanms.rb.gui.inventory.chasis.RCComponent;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class RadioClusters
extends JComponent
implements MouseListener,
ComponentListener {
    private static ImageIcon _picture = null;
    private List<RCComponent> _clusters = new ArrayList<RCComponent>();
    private int selectedRC = -1;
    private int maxClusters = 6;
    private static final int X_MARGIN = 1;
    private static final int Y_MARGIN = 1;
    private int X_GAP = 1;
    private int Y_GAP = 1;

    public RadioClusters() {
        if (_picture == null) {
            _picture = new ImageIcon(BMAXChasis.class.getResource("/com/bwanms/rb/gui/images/chasis/antenna.gif"));
        }
        this.setMaxClusters(this.maxClusters);
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public synchronized void addMouseListener(MouseListener l) {
        for (RCComponent rc : this._clusters) {
            rc.addMouseListener(l);
        }
        super.addMouseListener(l);
    }

    public RCComponent getRadioCluster(int index) {
        return this._clusters.get(index);
    }

    public RCComponent getSelectedRadioCluster() {
        if (this.selectedRC < 1 || this.selectedRC > this._clusters.size()) {
            return null;
        }
        return this._clusters.get(this.selectedRC - 1);
    }

    public void selectRadioCluster(int radioClusterID, boolean mutualExclusive) {
        if (mutualExclusive) {
            for (RCComponent rc : this._clusters) {
                rc.setSelected(false);
            }
        }
        if (radioClusterID < 1 || radioClusterID > this._clusters.size()) {
            this.selectedRC = -1;
            return;
        }
        this.selectedRC = radioClusterID;
        this._clusters.get(this.selectedRC - 1).setSelected(true);
    }

    public int getMaxClusters() {
        return this.maxClusters;
    }

    public void setMaxClusters(int maxClusters) {
        this.maxClusters = maxClusters;
        this.removeAll();
        if (this._clusters != null) {
            this._clusters.clear();
        }
        this._clusters = new ArrayList<RCComponent>(maxClusters);
        for (int i = 1; i <= maxClusters; ++i) {
            RCComponent rc = new RCComponent(i);
            this._clusters.add(rc);
            this.add(rc);
            for (MouseListener l : this.getMouseListeners()) {
                rc.addMouseListener(l);
            }
        }
        this.validate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        block3: {
            block2: {
                if (!(e.getSource() instanceof RCComponent)) break block2;
                this.selectedRC = ((RCComponent)e.getSource()).getRadioClusterID();
                for (RCComponent rc : this._clusters) {
                    if (rc.getRadioClusterID() == this.selectedRC) continue;
                    rc.setSelected(false);
                }
                break block3;
            }
            if (!(e.getSource() instanceof RadioClusters)) break block3;
            this.selectedRC = -1;
            for (RCComponent rc : this._clusters) {
                rc.setSelected(false);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.drawImage(_picture.getImage(), 0, 0, _picture.getIconWidth(), _picture.getIconHeight(), this);
    }

    protected void recalcLayout() {
        int W = this.getWidth();
        int H = this.getHeight();
        int w = this._clusters.get(0).getWidth();
        int h = this._clusters.get(0).getHeight();
        int x = 1 + _picture.getIconWidth() + this.X_GAP;
        int y = 1;
        for (RCComponent rc : this._clusters) {
            rc.setBounds(x, y, w, h);
            y += this.Y_GAP + h;
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.recalcLayout();
    }

    public void componentShown(ComponentEvent e) {
    }
}

