/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.BaseComponent;
import com.bwanms.util.PlatformConfiguration;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIUComponent
extends BaseComponent {
    private static Map<Severity, ImageIcon> _pictures = null;
    private static List<ImageIcon> picturesForCraft = null;
    private boolean highPower;
    private static ImageIcon masterLed = new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/master150.gif"));
    private boolean master;

    public PIUComponent() {
        this("PIU", false, false);
    }

    public PIUComponent(String name, boolean master, boolean highPower) {
        super(name, 0);
        this.master = master;
        this.highPower = highPower;
        if (picturesForCraft == null) {
            picturesForCraft = new ArrayList<ImageIcon>(4);
            picturesForCraft.add(0, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Grey.gif")));
            picturesForCraft.add(1, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Up.gif")));
            picturesForCraft.add(2, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Down.gif")));
            picturesForCraft.add(3, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Grey.gif")));
        }
        if (_pictures == null) {
            _pictures = new HashMap<Severity, ImageIcon>();
            _pictures.put(Severity.Critical, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Down.gif")));
            _pictures.put(Severity.Major, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Orange.gif")));
            _pictures.put(Severity.Minor, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Yellow.gif")));
            _pictures.put(Severity.Warning, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Blue.gif")));
            _pictures.put(Severity.Indeterminate, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Up.gif")));
            _pictures.put(Severity.Other, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Up.gif")));
            _pictures.put(Severity.Cleared, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Up.gif")));
            _pictures.put(Severity.unexpectedValue, new ImageIcon(PIUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/PIU_Up.gif")));
        }
        this.setSize(_pictures.get(Severity.Other).getIconWidth() - 1, _pictures.get(Severity.Other).getIconHeight() - 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        BMAXChasisMouseEvent evt = new BMAXChasisMouseEvent(e);
        evt.setCard(this.getName());
        evt.setBMAXComponent(this);
        for (BMAXChasisMouseListener lsnr : this._listeners) {
            lsnr.mouseClicked(evt);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.getStatus() == 3) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, this.isSelected() ? 0.7f : 1.0f));
        if (PlatformConfiguration.isLocalPlatform()) {
            g2d.drawImage(picturesForCraft.get(this.getStatus()).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else if (this.getStatus() == 2) {
            g2d.drawImage(_pictures.get(Severity.Critical).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g2d.drawImage(_pictures.get(this.alarmSeverityLevel).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        }
        if (this.master) {
            g2d.drawImage(masterLed.getImage(), 5, 30, this);
        }
        if (this.highPower) {
            String hpStr = "HP";
            Rectangle2D hpStrRectangle = g2d.getFontMetrics().getStringBounds(hpStr, g);
            g2d.drawString(hpStr, (int)((double)this.getWidth() - hpStrRectangle.getWidth()) / 2, 117);
        }
    }

    @Override
    public List<BMAXChannel> getChannels() {
        return new ArrayList<BMAXChannel>(0);
    }

    @Override
    public BMAXChannel getChannel(int index) {
        return null;
    }

    @Override
    public void addChannel(BMAXChannel ch) {
    }

    @Override
    public int channelCount() {
        return 0;
    }
}

