/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.rb.gui.inventory.chasis.ODUComponent;
import com.bwanms.rb.gui.inventory.chasis.ODUMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.ODUMouseListener;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutdoorUnits
extends JComponent
implements MouseListener,
ODUMouseListener,
ComponentListener {
    private List<ODUComponent> _units = new ArrayList<ODUComponent>();
    private List<ODUMouseListener> oduListener = new ArrayList<ODUMouseListener>();
    private int selectedODU = -1;
    private int maxUnits = 24;
    private int unitsPerRow = 6;
    private static final int X_MARGIN = 1;
    private static final int Y_MARGIN = 1;
    private int X_GAP = 1;
    private int Y_GAP = 1;
    private static Font _font = new Font("Tahoma", 0, 9);

    public OutdoorUnits() {
        this.setMaxUnits(this.maxUnits);
        this.setUnitsPerRow(this.unitsPerRow);
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public void addODUMouseListener(ODUMouseListener l) {
        this.oduListener.add(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        for (ODUComponent odu : this._units) {
            odu.addMouseListener(l);
        }
        super.addMouseListener(l);
    }

    public void addODU(int oduID) {
        this._units.add(new ODUComponent(oduID));
    }

    public ODUComponent getODU(int index) {
        return this._units.get(index);
    }

    public ODUComponent getSelectedODU() {
        if (this.selectedODU < 1 || this.selectedODU > this._units.size()) {
            return null;
        }
        return this._units.get(this.selectedODU - 1);
    }

    public void selectODU(int oduID, boolean mutualExclusive) {
        if (mutualExclusive) {
            for (ODUComponent odu : this._units) {
                odu.setSelected(false);
            }
        }
        if (oduID < 1 || oduID > this._units.size()) {
            this.selectedODU = -1;
            return;
        }
        this.selectedODU = oduID;
        this._units.get(this.selectedODU - 1).setSelected(true);
        this.repaint();
    }

    public int getMaxUnits() {
        return this.maxUnits;
    }

    public void setMaxUnits(int maxUnits) {
        this.maxUnits = maxUnits;
        this.removeAll();
        if (this._units != null) {
            this._units.clear();
        }
        this._units = new ArrayList<ODUComponent>(maxUnits);
        for (int i = 1; i <= maxUnits; ++i) {
            ODUComponent odu = new ODUComponent(i);
            this._units.add(odu);
            this.add(odu);
            for (MouseListener l : this.getMouseListeners()) {
                odu.addMouseListener(l);
            }
        }
        this.validate();
        this.repaint();
    }

    public int getUnitsPerRow() {
        return this.unitsPerRow;
    }

    public void setUnitsPerRow(int unitsPerRow) {
        this.unitsPerRow = unitsPerRow;
        this.recalcLayout();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof ODUComponent) {
            this.selectedODU = ((ODUComponent)e.getSource()).getOduID();
            for (ODUComponent odu : this._units) {
                if (odu.getOduID() == this.selectedODU) continue;
                odu.setSelected(false);
            }
        } else if (e.getSource() instanceof OutdoorUnits) {
            this.selectedODU = -1;
            for (ODUComponent odu : this._units) {
                odu.setSelected(false);
            }
        }
        ODUMouseEvent oduEvent = new ODUMouseEvent(e);
        oduEvent.set_selectedODU(this.selectedODU);
        for (ODUMouseListener lsnr : this.oduListener) {
            lsnr.mouseClicked(oduEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle r = new Rectangle();
        for (ODUComponent odu : this._units) {
            if (odu.getStatus() <= 0) continue;
            odu.getBounds(r);
            g.setFont(_font);
            g.drawString(odu.getFormattedTxPower(), r.x + 15, r.y + r.height + 10);
        }
    }

    protected void recalcLayout() {
        int W = this.getWidth();
        int H = this.getHeight();
        int w = this._units.get(0).getWidth();
        int h = this._units.get(0).getHeight();
        int cols = this.unitsPerRow;
        int rows = Math.round(this.maxUnits / this.unitsPerRow);
        this.X_GAP = (W - 2 - cols * w) / (cols - 1);
        if (rows > 1) {
            this.Y_GAP = (H - 2 - rows * h) / rows;
        }
        int cnt = 0;
        int x = 1;
        int y = 1;
        for (ODUComponent odu : this._units) {
            odu.setBounds(x, y, w, h);
            x += this.X_GAP + w;
            if (++cnt != this.unitsPerRow) continue;
            cnt = 0;
            x = 1;
            y += this.Y_GAP + h;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.recalcLayout();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(ODUMouseEvent e) {
        e.set_selectedODU(this.selectedODU);
    }

    public List<ODUMouseListener> getOduListener() {
        return this.oduListener;
    }

    public void setOduListener(List<ODUMouseListener> oduListener) {
        this.oduListener = oduListener;
    }
}

