/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ODUComponent
extends JComponent
implements MouseListener {
    private int oduID;
    private int radioClusterID = 0;
    private String txPower = null;
    private String channelTxFreq = null;
    private String oduNumber = null;
    private int status = 0;
    private boolean selected = false;
    private static List<ImageIcon> _pictures = null;
    private static List<ImageIcon> _pictures2 = null;
    private final int offset = 5;
    private final int biggerOffset = 15;

    public ODUComponent(int oduID) {
        this.oduID = oduID;
        if (_pictures == null) {
            _pictures = new ArrayList<ImageIcon>(8);
            _pictures.add(0, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_grey_t.gif")));
            _pictures.add(1, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down_t.gif")));
            _pictures.add(2, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down_t.gif")));
            _pictures.add(3, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down_t.gif")));
            _pictures.add(4, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down_t.gif")));
            _pictures.add(5, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_up_t.gif")));
            _pictures.add(6, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down_t.gif")));
            _pictures.add(7, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_up_t.gif")));
            _pictures.add(8, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down_t.gif")));
        }
        if (_pictures2 == null) {
            _pictures2 = new ArrayList<ImageIcon>(8);
            _pictures2.add(0, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_grey.gif")));
            _pictures2.add(1, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down.gif")));
            _pictures2.add(2, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down.gif")));
            _pictures2.add(3, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down.gif")));
            _pictures2.add(4, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down.gif")));
            _pictures2.add(5, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_up.gif")));
            _pictures2.add(6, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down.gif")));
            _pictures2.add(7, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_up.gif")));
            _pictures2.add(8, new ImageIcon(ODUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/ODU_down.gif")));
        }
        this.setSize(_pictures.get(0).getIconWidth() + 15, _pictures.get(0).getIconHeight() + 5);
        this.addMouseListener(this);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public int getOduID() {
        return this.oduID;
    }

    public int getRadioClusterID() {
        return this.radioClusterID;
    }

    public void setRadioClusterID(int radioClusterID) {
        this.radioClusterID = radioClusterID;
    }

    public String getFormattedTxPower() {
        return this.txPower + " dBm";
    }

    public String getTxPower() {
        return this.txPower;
    }

    public void setTxPower(String txPower) {
        this.txPower = txPower;
    }

    public String getFormattedChannelTxFreq() {
        return this.channelTxFreq + " MHz";
    }

    public String getChannelTxFreq() {
        return this.channelTxFreq;
    }

    public void setChannelTxFreq(String channelTxFreq) {
        this.channelTxFreq = channelTxFreq;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.selected) {
            g.setColor(BMAXChannel.selColor);
            g.fillRect(15, 5, this.getWidth() + 5, this.getHeight() - 5);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, this.selected ? 0.5f : 1.0f));
        g2d.drawImage(this.selected ? _pictures2.get(this.status).getImage() : _pictures.get(this.status).getImage(), 15, 5, this.getWidth() - 15, this.getHeight() - 5, this);
        if (this.selected) {
            g.setColor(BMAXChannel.selColor);
            g.drawRect(15, 5, this.getWidth() + 5, this.getHeight() - 5);
        }
        g.setFont(new Font("Arial", 1, 11));
        g.drawString(new Integer(this.getOduID()).toString(), 0, this.getHeight() - 5);
    }

    public void mouseClicked(MouseEvent e) {
        this.setSelected(true);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.status > 0) {
            this.setToolTipText(this.toString());
        }
    }

    public void mouseExited(MouseEvent e) {
        this.setToolTipText(null);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public String toString() {
        String str = "";
        if (this.txPower != null) {
            str = this.txPower + " dBm";
        }
        if (this.channelTxFreq != null) {
            str = str + " / " + this.channelTxFreq + " MHz";
        }
        return str;
    }

    public String getOduNumber() {
        return this.oduNumber;
    }

    public void setOduNumber(String oduNumber) {
        this.oduNumber = oduNumber;
    }
}

