/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.BaseChannel;
import com.bwanms.rb.gui.inventory.chasis.BaseComponent;
import com.bwanms.rb.gui.inventory.chasis.NPUChannel;
import com.bwanms.util.PlatformConfiguration;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class NPUComponent
extends BaseComponent {
    private int X = 16;
    private int Y = 77;
    private static ImageIcon masterLedGreen = new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/GPS_Status_Green.png"));
    private static ImageIcon masterLedGray = new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/GPS_Status_Gray.png"));
    public static final int NO_GPS_STATUS = -1;
    public static final int GPS_STATUS_ENABLED = 1;
    public static final int GPS_STATUS_DISABLED = 0;
    private int GPSStatus = -1;
    private static Map<Severity, ImageIcon> picturesBelow4_5 = null;
    private static Map<Severity, ImageIcon> picturesAbove4_5 = null;
    private static List<ImageIcon> picturesForCraftBelow4_5 = null;
    private static List<ImageIcon> picturesForCraftAbove4_5 = null;

    public NPUComponent() {
        this("NPU");
    }

    public NPUComponent(String name) {
        super(name, 2);
        this.addChannel(new NPUChannel());
        this.addChannel(new NPUChannel());
        if (picturesForCraftBelow4_5 == null) {
            picturesForCraftBelow4_5 = new ArrayList<ImageIcon>(6);
            picturesForCraftBelow4_5.add(0, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Gray.gif")));
            picturesForCraftBelow4_5.add(1, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Green.gif")));
            picturesForCraftBelow4_5.add(2, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Red.gif")));
            picturesForCraftBelow4_5.add(3, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Red.gif")));
            picturesForCraftBelow4_5.add(4, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Red.gif")));
            picturesForCraftBelow4_5.add(5, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Gray.gif")));
        }
        if (picturesForCraftAbove4_5 == null) {
            picturesForCraftAbove4_5 = new ArrayList<ImageIcon>(6);
            picturesForCraftAbove4_5.add(0, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Gray.png")));
            picturesForCraftAbove4_5.add(1, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Green.png")));
            picturesForCraftAbove4_5.add(2, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Red.png")));
            picturesForCraftAbove4_5.add(3, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Red.png")));
            picturesForCraftAbove4_5.add(4, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Red.png")));
            picturesForCraftAbove4_5.add(5, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Gray.png")));
        }
        if (picturesBelow4_5 == null) {
            picturesBelow4_5 = new HashMap<Severity, ImageIcon>();
            picturesBelow4_5.put(Severity.Critical, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Red.gif")));
            picturesBelow4_5.put(Severity.Major, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Orange.gif")));
            picturesBelow4_5.put(Severity.Minor, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Yellow.gif")));
            picturesBelow4_5.put(Severity.Warning, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Blue.gif")));
            picturesBelow4_5.put(Severity.Indeterminate, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Green.gif")));
            picturesBelow4_5.put(Severity.Cleared, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Green.gif")));
            picturesBelow4_5.put(Severity.Other, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Green.gif")));
            picturesBelow4_5.put(Severity.unexpectedValue, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_Green.gif")));
        }
        if (picturesAbove4_5 == null) {
            picturesAbove4_5 = new HashMap<Severity, ImageIcon>();
            picturesAbove4_5.put(Severity.Critical, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Red.png")));
            picturesAbove4_5.put(Severity.Major, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Orange.png")));
            picturesAbove4_5.put(Severity.Minor, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Yellow.png")));
            picturesAbove4_5.put(Severity.Warning, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Blue.png")));
            picturesAbove4_5.put(Severity.Indeterminate, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Green.png")));
            picturesAbove4_5.put(Severity.Cleared, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Green.png")));
            picturesAbove4_5.put(Severity.Other, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Green.png")));
            picturesAbove4_5.put(Severity.unexpectedValue, new ImageIcon(NPUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/NPU_TDD_Green.png")));
        }
        this.setSize(picturesAbove4_5.get(Severity.Other).getIconWidth(), picturesBelow4_5.get(Severity.Other).getIconHeight() + 1);
    }

    public void setGPSStatus(int GPSStatus) {
        this.GPSStatus = GPSStatus;
    }

    public void draw(Graphics g) {
        int dy = 0;
        boolean drawSelected = this._selectedChannel >= 0 ? false : this.isSelected();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, drawSelected ? 0.7f : 1.0f));
        if (PlatformConfiguration.isLocalPlatform()) {
            if (this.GPSStatus == -1) {
                g2d.drawImage(picturesForCraftBelow4_5.get(this.getStatus()).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            } else {
                g2d.drawImage(picturesForCraftAbove4_5.get(this.getStatus()).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            }
        } else if (this.GPSStatus == -1) {
            if (this.getStatus() == 5) {
                g2d.drawImage(picturesBelow4_5.get(Severity.Critical).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            } else {
                g2d.drawImage(picturesBelow4_5.get(this.alarmSeverityLevel).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            }
        } else if (this.getStatus() == 5) {
            g2d.drawImage(picturesAbove4_5.get(Severity.Critical).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g2d.drawImage(picturesAbove4_5.get(this.alarmSeverityLevel).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        }
        switch (this.GPSStatus) {
            case 0: {
                g2d.drawImage(masterLedGray.getImage(), this.X + 3, this.Y + 82, this);
                break;
            }
            case 1: {
                g2d.drawImage(masterLedGreen.getImage(), this.X + 3, this.Y + 82, this);
            }
        }
        int k = 0;
        for (BMAXChannel ch : this.getChannels()) {
            dy = this.Y + k * (((BaseChannel)ch).getHeight() + 16);
            ch.draw(g.create(this.X, dy, this.X + ((BaseChannel)ch).getWidth(), dy + ((BaseChannel)ch).getHeight()), this._selectedChannel == k);
            ++k;
        }
        g.drawString("" + this.getSlotNumber(), 20, 239);
    }

    public void mouseClicked(MouseEvent e) {
        int dy = 0;
        BMAXChasisMouseEvent evt = new BMAXChasisMouseEvent(e);
        evt.setCard(this.getName());
        evt.setSerialNo(this.getSerialNo());
        evt.setBMAXComponent(this);
        this.deselectChannel();
        int k = 0;
        for (BMAXChannel ch : this.getChannels()) {
            dy = this.Y + k * (((BaseChannel)ch).getHeight() + 11);
            if (e.getX() > this.X && e.getX() < this.X + ((BaseChannel)ch).getWidth() && e.getY() > dy && e.getY() < dy + ((BaseChannel)ch).getHeight()) {
                this.selectChannel(k);
                evt.setChannel(k);
                evt.setBMAXChannel(ch);
                ((BaseChannel)ch).dispatchEvent(e);
                break;
            }
            ++k;
        }
        for (BMAXChasisMouseListener lsnr : this._listeners) {
            lsnr.mouseClicked(evt);
        }
    }
}

