/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.MBSChannel;
import com.bwanms.rb.gui.inventory.chasis.MBSChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.MBSChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.MBSPort;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class MBSChasis
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static int MBS_DATA_PORT = 0;
    public static int MBS_MGMT_PORT = 1;
    public static int MBS_ODU1_CHANNEL = 2;
    public static int MBS_ODU2_CHANNEL = 3;
    public static int MBS_ODU3_CHANNEL = 4;
    public static int MBS_ODU4_CHANNEL = 5;
    private ImageIcon _picture;
    private int X_DATA = 44;
    private int Y_DATA = 30;
    private int X_MGMT = 72;
    private int Y_MGMT = 30;
    private int X_ODU1 = 272;
    private int Y_ODU1 = 29;
    private int X_ODU2 = 314;
    private int Y_ODU2 = 29;
    private int X_ODU3 = 356;
    private int Y_ODU3 = 29;
    private int X_ODU4 = 398;
    private int Y_ODU4 = 29;
    private int PORT_WIDTH = 22;
    private int PORT_HEIGHT = 14;
    private int CHANNEL_WIDTH = 19;
    private int CHANNEL_HEIGHT = 19;
    private int _selectedChannel = -1;
    private boolean isFourChannels;
    private List<MBSChasisMouseListener> _listeners = new ArrayList<MBSChasisMouseListener>();
    private List<BMAXChannel> _channels = new ArrayList<BMAXChannel>();

    public MBSChasis(boolean isFourChannels) {
        this.isFourChannels = isFourChannels;
        this._picture = isFourChannels ? new ImageIcon(MBSChasis.class.getResource("/com/bwanms/rb/gui/images/chasis/mbst_chassis_TDD.gif")) : new ImageIcon(MBSChasis.class.getResource("/com/bwanms/rb/gui/images/chasis/mbst_chassis.gif"));
        this.setSize(this._picture.getIconWidth(), this._picture.getIconHeight());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._channels.add(MBS_DATA_PORT, new MBSPort());
        this._channels.add(MBS_MGMT_PORT, new MBSPort());
        this._channels.add(MBS_ODU1_CHANNEL, new MBSChannel());
        this._channels.add(MBS_ODU2_CHANNEL, new MBSChannel());
        if (isFourChannels) {
            this._channels.add(MBS_ODU3_CHANNEL, new MBSChannel());
            this._channels.add(MBS_ODU4_CHANNEL, new MBSChannel());
        }
    }

    public void addChasisMouseListener(MBSChasisMouseListener listener) {
        this._listeners.add(listener);
    }

    public void removeChasisMouseListener(MBSChasisMouseListener listener) {
        this._listeners.remove(listener);
    }

    public BMAXChannel getChannel(int channel) {
        if (channel < 0 || channel > 5) {
            return null;
        }
        return this._channels.get(channel);
    }

    public BMAXChannel getSelectedChannel() {
        return this.getChannel(this._selectedChannel);
    }

    public void paintComponent(Graphics g) {
        Image i = this._picture.getImage();
        g.drawImage(i, 0, 0, this.getWidth(), this.getHeight(), this);
        this._channels.get(MBS_DATA_PORT).draw(g.create(this.X_DATA, this.Y_DATA, this.PORT_WIDTH, this.PORT_HEIGHT), this._selectedChannel == MBS_DATA_PORT);
        this._channels.get(MBS_MGMT_PORT).draw(g.create(this.X_MGMT, this.Y_MGMT, this.PORT_WIDTH, this.PORT_HEIGHT), this._selectedChannel == MBS_MGMT_PORT);
        this._channels.get(MBS_ODU1_CHANNEL).draw(g.create(this.X_ODU1, this.Y_ODU1, this.CHANNEL_WIDTH, this.CHANNEL_HEIGHT), this._selectedChannel == MBS_ODU1_CHANNEL);
        this._channels.get(MBS_ODU2_CHANNEL).draw(g.create(this.X_ODU2, this.Y_ODU2, this.CHANNEL_WIDTH, this.CHANNEL_HEIGHT), this._selectedChannel == MBS_ODU2_CHANNEL);
        if (this.isFourChannels) {
            this._channels.get(MBS_ODU3_CHANNEL).draw(g.create(this.X_ODU3, this.Y_ODU3, this.CHANNEL_WIDTH, this.CHANNEL_HEIGHT), this._selectedChannel == MBS_ODU3_CHANNEL);
            this._channels.get(MBS_ODU4_CHANNEL).draw(g.create(this.X_ODU4, this.Y_ODU4, this.CHANNEL_WIDTH, this.CHANNEL_HEIGHT), this._selectedChannel == MBS_ODU4_CHANNEL);
        }
    }

    public void mouseClicked(MouseEvent e) {
        block13: {
            MBSChasisMouseEvent evt;
            block14: {
                this.deselectChannel();
                if (e.getX() > this.X_DATA && e.getX() < this.X_DATA + this.PORT_WIDTH && e.getY() > this.Y_DATA && e.getY() < this.Y_DATA + this.PORT_WIDTH) {
                    this.selectChannel(MBS_DATA_PORT);
                    evt = new MBSChasisMouseEvent(e);
                    evt.setMBSChannel(this.getChannel(MBS_DATA_PORT));
                    evt.setChannel(MBS_DATA_PORT);
                    for (MBSChasisMouseListener listener : this._listeners) {
                        listener.mouseClicked(evt);
                    }
                } else if (e.getX() > this.X_MGMT && e.getX() < this.X_MGMT + this.PORT_WIDTH && e.getY() > this.Y_MGMT && e.getY() < this.Y_MGMT + this.PORT_WIDTH) {
                    this.selectChannel(MBS_MGMT_PORT);
                    evt = new MBSChasisMouseEvent(e);
                    evt.setMBSChannel(this.getChannel(MBS_MGMT_PORT));
                    evt.setChannel(MBS_MGMT_PORT);
                    for (MBSChasisMouseListener listener : this._listeners) {
                        listener.mouseClicked(evt);
                    }
                } else if (e.getX() > this.X_ODU1 && e.getX() < this.X_ODU1 + this.CHANNEL_WIDTH && e.getY() > this.Y_ODU1 && e.getY() < this.Y_ODU1 + this.CHANNEL_WIDTH) {
                    this.selectChannel(MBS_ODU1_CHANNEL);
                    evt = new MBSChasisMouseEvent(e);
                    evt.setMBSChannel(this.getChannel(MBS_ODU1_CHANNEL));
                    evt.setChannel(MBS_ODU1_CHANNEL);
                    for (MBSChasisMouseListener listener : this._listeners) {
                        listener.mouseClicked(evt);
                    }
                } else if (e.getX() > this.X_ODU2 && e.getX() < this.X_ODU2 + this.CHANNEL_WIDTH && e.getY() > this.Y_ODU2 && e.getY() < this.Y_ODU2 + this.CHANNEL_WIDTH) {
                    this.selectChannel(MBS_ODU2_CHANNEL);
                    evt = new MBSChasisMouseEvent(e);
                    evt.setMBSChannel(this.getChannel(MBS_ODU2_CHANNEL));
                    evt.setChannel(MBS_ODU2_CHANNEL);
                    for (MBSChasisMouseListener listener : this._listeners) {
                        listener.mouseClicked(evt);
                    }
                }
                if (!this.isFourChannels) break block13;
                if (e.getX() <= this.X_ODU3 || e.getX() >= this.X_ODU3 + this.CHANNEL_WIDTH || e.getY() <= this.Y_ODU3 || e.getY() >= this.Y_ODU3 + this.CHANNEL_WIDTH) break block14;
                this.selectChannel(MBS_ODU3_CHANNEL);
                evt = new MBSChasisMouseEvent(e);
                evt.setMBSChannel(this.getChannel(MBS_ODU3_CHANNEL));
                evt.setChannel(MBS_ODU3_CHANNEL);
                for (MBSChasisMouseListener listener : this._listeners) {
                    listener.mouseClicked(evt);
                }
                break block13;
            }
            if (e.getX() <= this.X_ODU4 || e.getX() >= this.X_ODU4 + this.CHANNEL_WIDTH || e.getY() <= this.Y_ODU4 || e.getY() >= this.Y_ODU4 + this.CHANNEL_WIDTH) break block13;
            this.selectChannel(MBS_ODU4_CHANNEL);
            evt = new MBSChasisMouseEvent(e);
            evt.setMBSChannel(this.getChannel(MBS_ODU4_CHANNEL));
            evt.setChannel(MBS_ODU4_CHANNEL);
            for (MBSChasisMouseListener listener : this._listeners) {
                listener.mouseClicked(evt);
            }
        }
    }

    public void selectChannel(int channel) {
        this._selectedChannel = channel;
        this.repaint();
    }

    public void deselectChannel() {
        this._selectedChannel = -1;
        this.repaint();
    }

    public int getWidth() {
        return this._picture.getIconWidth();
    }

    public int getHeight() {
        return this._picture.getIconHeight();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        MBSChannel channel = null;
        if (e.getX() > this.X_ODU1 && e.getX() < this.X_ODU1 + this.CHANNEL_WIDTH && e.getY() > this.Y_ODU1 && e.getY() < this.Y_ODU1 + this.CHANNEL_WIDTH) {
            channel = (MBSChannel)this._channels.get(MBS_ODU1_CHANNEL);
        } else if (e.getX() > this.X_ODU2 && e.getX() < this.X_ODU2 + this.CHANNEL_WIDTH && e.getY() > this.Y_ODU2 && e.getY() < this.Y_ODU2 + this.CHANNEL_WIDTH) {
            channel = (MBSChannel)this._channels.get(MBS_ODU2_CHANNEL);
        }
        if (this.isFourChannels) {
            if (e.getX() > this.X_ODU3 && e.getX() < this.X_ODU3 + this.CHANNEL_WIDTH && e.getY() > this.Y_ODU3 && e.getY() < this.Y_ODU3 + this.CHANNEL_WIDTH) {
                channel = (MBSChannel)this._channels.get(MBS_ODU3_CHANNEL);
            } else if (e.getX() > this.X_ODU4 && e.getX() < this.X_ODU4 + this.CHANNEL_WIDTH && e.getY() > this.Y_ODU4 && e.getY() < this.Y_ODU4 + this.CHANNEL_WIDTH) {
                channel = (MBSChannel)this._channels.get(MBS_ODU4_CHANNEL);
            }
        }
        if (channel != null) {
            this.setToolTipText(channel.toString());
        } else {
            this.setToolTipText(null);
        }
    }
}

