/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.BMAXComponent;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseComponent
extends JButton
implements BMAXComponent,
MouseListener,
MouseMotionListener {
    private int _faultStatus = 0;
    private String _name = null;
    private int slotNumber = 0;
    private String serialNo = null;
    private boolean selected = false;
    private List<BMAXChannel> _channels;
    protected int _selectedChannel = -1;
    protected List<BMAXChasisMouseListener> _listeners = new ArrayList<BMAXChasisMouseListener>();
    protected Severity alarmSeverityLevel = Severity.Other;

    public BaseComponent() {
        this("Default", 2);
    }

    public BaseComponent(String name, int ch_count) {
        this._name = name;
        this._channels = new ArrayList<BMAXChannel>(ch_count);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addChasisMouseListener(BMAXChasisMouseListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeChasisMouseListener(BMAXChasisMouseListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public void setAlarmSeverityLevel(Severity alarmSeverityLevel) {
        this.alarmSeverityLevel = alarmSeverityLevel;
    }

    public Severity getAlarmSeverityLevel() {
        return this.alarmSeverityLevel;
    }

    @Override
    public int getStatus() {
        return this._faultStatus;
    }

    @Override
    public void setStatus(int status) {
        this._faultStatus = status;
        this.repaint();
    }

    @Override
    public int getSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public List<BMAXChannel> getChannels() {
        return this._channels;
    }

    @Override
    public BMAXChannel getChannel(int index) {
        return this._channels.get(index);
    }

    @Override
    public BMAXChannel getSelectedChannel() {
        if (this._selectedChannel < 0 || this._selectedChannel >= this._channels.size()) {
            return null;
        }
        return this._channels.get(this._selectedChannel);
    }

    @Override
    public void addChannel(BMAXChannel ch) {
        this._channels.add(ch);
    }

    @Override
    public int channelCount() {
        return this._channels.size();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.selected) {
            g.setColor(BMAXChannel.selColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.draw(g);
        if (this.selected) {
            g.setColor(BMAXChannel.selColor);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void drawSelected(Graphics g) {
    }

    public void selectChannel(int channel) {
        this._selectedChannel = channel;
        this.getChannel(this._selectedChannel).setSelected(true);
        this.repaint();
    }

    public void deselectChannel() {
        if (this.getSelectedChannel() != null) {
            this.getSelectedChannel().setSelected(false);
        }
        this._selectedChannel = -1;
        this.repaint();
    }

    public void deselectAllChannels() {
        for (BMAXChannel ch : this._channels) {
            ch.setSelected(false);
        }
        this._selectedChannel = -1;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

