/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseChannel
extends JComponent
implements BMAXChannel {
    private static final Log logger = LogFactory.getLog(BaseChannel.class);
    private int _status = 3;
    protected ImageIcon _picture_up = null;
    protected ImageIcon _picture_down = null;
    protected ImageIcon _picture_disabled = null;
    private boolean selected = false;

    public BaseChannel() {
    }

    public BaseChannel(String name) {
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void draw(Graphics g) {
        Image i = null;
        if (this._status == 3 || this._status == 0) {
            i = this._picture_disabled.getImage();
        } else if (this._status == 2) {
            i = this._picture_down.getImage();
        } else if (this._status == 1) {
            i = this._picture_up.getImage();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.drawImage(i, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void drawSelected(Graphics g) {
        this.draw(g);
        g.setColor(Color.blue);
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void draw(Graphics g, boolean selected) {
        Image img;
        if (selected) {
            g.setColor(selColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if ((img = this.image()) != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setComposite(AlphaComposite.getInstance(3, selected ? 0.5f : 1.0f));
            g2d.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            logger.error((Object)("No image to display. Operational Status : " + this._status));
        }
        if (selected) {
            g.setColor(selColor);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected Image image() {
        Image img = null;
        switch (this._status) {
            case 0: {
                img = this._picture_disabled.getImage();
                break;
            }
            case 1: {
                img = this._picture_up.getImage();
                break;
            }
            case 2: {
                img = this._picture_down.getImage();
                break;
            }
            case 3: {
                img = this._picture_disabled.getImage();
            }
        }
        return img;
    }
}

