/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.rb.gui.inventory.chasis.ACUComponent;
import com.bwanms.rb.gui.inventory.chasis.AUComponent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.BMAXComponent;
import com.bwanms.rb.gui.inventory.chasis.BaseComponent;
import com.bwanms.rb.gui.inventory.chasis.NPUComponent;
import com.bwanms.rb.gui.inventory.chasis.PIUComponent;
import com.bwanms.rb.gui.inventory.chasis.PSUComponent;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class BMAXChasis
extends JComponent
implements MouseListener,
BMAXChasisMouseListener {
    public static final int AU_2CH = 2;
    public static final int AU_4CH = 4;
    private ImageIcon _picture = null;
    private static List<Rectangle> _bounds = new ArrayList<Rectangle>(16);
    private int _selectedSlot = -1;
    private List<BMAXChasisMouseListener> _listeners = new ArrayList<BMAXChasisMouseListener>();
    private Map<Integer, BMAXComponent> _components = new HashMap<Integer, BMAXComponent>();

    public BMAXChasis() {
        this._picture = new ImageIcon(BMAXChasis.class.getResource("/com/bwanms/rb/gui/images/chasis/chassis.gif"));
        this.setSize(this._picture.getIconWidth(), this._picture.getIconHeight());
        this.addMouseListener(this);
    }

    private void addComponent(int slot, BMAXComponent cmp) {
        this._components.put(slot, cmp);
        cmp.addChasisMouseListener(this);
        if (slot >= 1 && slot <= 25 && cmp instanceof BaseComponent) {
            this.add((Component)((Object)cmp));
            cmp.setSlotNumber(slot);
            ((BaseComponent)cmp).setBounds(_bounds.get(slot));
            for (MouseListener l : this.getMouseListeners()) {
                ((BaseComponent)cmp).addMouseListener(l);
            }
        }
    }

    public void addChasisMouseListener(BMAXChasisMouseListener listener) {
        this._listeners.add(listener);
    }

    public void removeChasisMouseListener(BMAXChasisMouseListener listener) {
        this._listeners.remove(listener);
    }

    public void addAU(int slot, String name, int type) {
        if (slot < 1 || slot > 9) {
            return;
        }
        if (type == 2) {
            this.addComponent(slot, new AUComponent(name, 2));
        } else if (type == 4) {
            this.addComponent(slot, new AUComponent(name, 4));
        }
    }

    public AUComponent getAU(int slot) {
        if (slot < 1 || slot > 9) {
            return null;
        }
        if (this._components.containsKey(slot)) {
            return this._components.get(slot) instanceof AUComponent ? (AUComponent)this._components.get(slot) : null;
        }
        return null;
    }

    public void addNPU(int slot, String name) {
        if (slot != 5 && slot != 6) {
            return;
        }
        this.addComponent(slot, new NPUComponent(name));
    }

    public NPUComponent getNPU(int slot) {
        if (slot != 5 && slot != 6) {
            return null;
        }
        if (this._components.containsKey(slot)) {
            return this._components.get(slot) instanceof NPUComponent ? (NPUComponent)this._components.get(slot) : null;
        }
        return null;
    }

    public void addPSU(int slot, String name) {
        if (slot < 10 || slot > 13) {
            return;
        }
        this.addComponent(slot, new PSUComponent(name));
    }

    public PSUComponent getPSU(int slot) {
        if (slot < 10 || slot > 13) {
            return null;
        }
        if (this._components.containsKey(slot)) {
            return (PSUComponent)this._components.get(slot);
        }
        return null;
    }

    public void addPIU(int slot, String name, boolean master, boolean highPower) {
        if (slot != 14 && slot != 15) {
            return;
        }
        this.addComponent(slot, new PIUComponent(name, master, highPower));
    }

    public void addACU(int slot, String name) {
        if (slot < 16 || slot > 25) {
            return;
        }
        this.addComponent(slot, new ACUComponent(name));
    }

    public ACUComponent getACU(int slot) {
        if (slot < 16 || slot > 25) {
            return null;
        }
        if (this._components.containsKey(slot)) {
            return (ACUComponent)this._components.get(slot);
        }
        return null;
    }

    public PIUComponent getPIU(int slot) {
        if (slot != 14 && slot != 15) {
            return null;
        }
        if (this._components.containsKey(slot)) {
            return (PIUComponent)this._components.get(slot);
        }
        return null;
    }

    public BMAXComponent getBMAXComponent(int slot) {
        if (this._components.containsKey(slot)) {
            return this._components.get(slot);
        }
        return null;
    }

    public BMAXComponent getSelectedComponent() {
        if (this._selectedSlot < 1) {
            return null;
        }
        return this.getBMAXComponent(this._selectedSlot);
    }

    public BMAXChannel getChannel(int slot, int channel) {
        if (this._components.containsKey(slot)) {
            BMAXComponent comp = this._components.get(slot);
            return comp.getChannel(channel);
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.drawImage(this._picture.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void mouseClicked(MouseEvent e) {
        this.refreshChassis(e);
    }

    public void refreshChassis(MouseEvent e) {
        if (e.getSource() instanceof BaseComponent) {
            int slot = ((BaseComponent)e.getSource()).getSlotNumber();
            if (slot != this._selectedSlot) {
                this.deselectSlot();
            }
            for (BMAXComponent comp : this._components.values()) {
                if (comp.getSlotNumber() == slot) continue;
                comp.setSelected(false);
                ((BaseComponent)comp).deselectAllChannels();
            }
            this.selectSlot(slot);
            if (this._components.containsKey(slot)) {
                Rectangle r = _bounds.get(slot);
                e.translatePoint(-r.x, -r.y);
            } else {
                BMAXChasisMouseEvent evt = new BMAXChasisMouseEvent(e);
                if (slot == 1 || slot == 2 || slot == 3 || slot == 4 || slot == 7 || slot == 8 || slot == 9) {
                    evt.setCard("AU" + slot);
                } else if (slot == 5 || slot == 6) {
                    evt.setCard("NPU" + slot);
                }
                evt.setSerialNo(((BaseComponent)e.getSource()).getSerialNo());
                evt.setSlot(slot);
                for (BMAXChasisMouseListener lsnr : this._listeners) {
                    lsnr.mouseClicked(evt);
                }
            }
        }
    }

    public int getWidth() {
        return this._picture.getIconWidth();
    }

    public int getHeight() {
        return this._picture.getIconHeight();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.refreshChassis(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void selectSlot(int slot) {
        BMAXComponent oldSlot = this._components.get(this._selectedSlot);
        if (oldSlot != null) {
            oldSlot.setSelected(false);
        }
        this._selectedSlot = slot;
        if (this._components.containsKey(this._selectedSlot)) {
            this._components.get(this._selectedSlot).setSelected(true);
        }
        this.repaint();
    }

    public void deselectSlot() {
        if (this._components.containsKey(this._selectedSlot)) {
            this._components.get(this._selectedSlot).setSelected(false);
            ((BaseComponent)this._components.get(this._selectedSlot)).deselectAllChannels();
        }
        this._selectedSlot = -1;
        this.repaint();
    }

    public void deselectAllSlots() {
        for (BMAXComponent comp : this._components.values()) {
            comp.setSelected(false);
            ((BaseComponent)comp).deselectAllChannels();
        }
        this._selectedSlot = -1;
        this.repaint();
    }

    public void mouseClicked(BMAXChasisMouseEvent e) {
        e.setSlot(this._selectedSlot);
        for (BMAXChasisMouseListener lsnr : this._listeners) {
            lsnr.mouseClicked(e);
        }
    }

    static {
        _bounds.add(0, new Rectangle(0, 0, 0, 0));
        _bounds.add(1, new Rectangle(113, 1, 46, 244));
        _bounds.add(2, new Rectangle(159, 1, 46, 244));
        _bounds.add(3, new Rectangle(205, 1, 46, 244));
        _bounds.add(4, new Rectangle(251, 1, 46, 244));
        _bounds.add(5, new Rectangle(297, 1, 46, 244));
        _bounds.add(6, new Rectangle(342, 1, 46, 244));
        _bounds.add(7, new Rectangle(388, 1, 46, 244));
        _bounds.add(8, new Rectangle(434, 1, 46, 244));
        _bounds.add(9, new Rectangle(480, 1, 46, 244));
        _bounds.add(10, new Rectangle(58, 1, 56, 122));
        _bounds.add(11, new Rectangle(58, 123, 56, 122));
        _bounds.add(12, new Rectangle(526, 1, 56, 122));
        _bounds.add(13, new Rectangle(526, 122, 56, 122));
        _bounds.add(14, new Rectangle(16, 1, 43, 122));
        _bounds.add(15, new Rectangle(16, 123, 43, 122));
        _bounds.add(16, new Rectangle(58, 251, 35, 35));
        for (int slot = 17; slot <= 25; ++slot) {
            Rectangle r = _bounds.get(slot - 1);
            _bounds.add(slot, new Rectangle(r.x + 50, r.y, r.width, r.height));
        }
    }
}

