/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.inventory.chasis;

import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.gui.inventory.chasis.AUChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.BaseChannel;
import com.bwanms.rb.gui.inventory.chasis.BaseComponent;
import com.bwanms.util.PlatformConfiguration;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class AUComponent
extends BaseComponent {
    private static final long serialVersionUID = 1L;
    public static final int AU_2CH = 2;
    public static final int AU_4CH = 4;
    private static Map<Integer, Map<Severity, ImageIcon>> _pictures = new HashMap<Integer, Map<Severity, ImageIcon>>();
    private static Map<Integer, List<ImageIcon>> picturesForCraft = new HashMap<Integer, List<ImageIcon>>();
    private int X = 14;
    private int Y = 77;
    private int channelsCount;

    public AUComponent() {
        this("AU", 2);
    }

    public AUComponent(String name, int ch_count) {
        super(name, ch_count);
        this.channelsCount = ch_count;
        for (int i = 0; i < ch_count; ++i) {
            this.addChannel(new AUChannel());
        }
        if (ch_count == 2 && picturesForCraft.get(2) == null) {
            ArrayList<ImageIcon> AU_2CH_pictures = new ArrayList<ImageIcon>(6);
            AU_2CH_pictures.add(0, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Gray.gif")));
            AU_2CH_pictures.add(1, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Green.gif")));
            AU_2CH_pictures.add(2, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Red.gif")));
            AU_2CH_pictures.add(3, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Red.gif")));
            AU_2CH_pictures.add(4, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Red.gif")));
            AU_2CH_pictures.add(5, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Gray.gif")));
            picturesForCraft.put(2, AU_2CH_pictures);
            this.setSize(((ImageIcon)AU_2CH_pictures.get(0)).getIconWidth(), ((ImageIcon)AU_2CH_pictures.get(0)).getIconHeight() + 1);
        } else if (ch_count == 4 && picturesForCraft.get(4) == null) {
            ArrayList<ImageIcon> AU_4CH_pictures = new ArrayList<ImageIcon>(6);
            AU_4CH_pictures.add(0, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Gray.gif")));
            AU_4CH_pictures.add(1, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Green.gif")));
            AU_4CH_pictures.add(2, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Red.gif")));
            AU_4CH_pictures.add(3, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Red.gif")));
            AU_4CH_pictures.add(4, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Red.gif")));
            AU_4CH_pictures.add(5, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Gray.gif")));
            picturesForCraft.put(4, AU_4CH_pictures);
            this.setSize(((ImageIcon)AU_4CH_pictures.get(0)).getIconWidth(), ((ImageIcon)AU_4CH_pictures.get(0)).getIconHeight() + 1);
        }
        if (ch_count == 2 && _pictures.get(2) == null) {
            HashMap<Severity, ImageIcon> AU_2CH_pictures = new HashMap<Severity, ImageIcon>();
            AU_2CH_pictures.put(Severity.Critical, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Red.gif")));
            AU_2CH_pictures.put(Severity.Major, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Orange.gif")));
            AU_2CH_pictures.put(Severity.Minor, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Yellow.gif")));
            AU_2CH_pictures.put(Severity.Warning, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Blue.gif")));
            AU_2CH_pictures.put(Severity.Indeterminate, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Green.gif")));
            AU_2CH_pictures.put(Severity.Cleared, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Green.gif")));
            AU_2CH_pictures.put(Severity.Other, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Green.gif")));
            AU_2CH_pictures.put(Severity.unexpectedValue, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_2CH_Green.gif")));
            _pictures.put(2, AU_2CH_pictures);
            this.setSize(((ImageIcon)AU_2CH_pictures.get(Severity.Other)).getIconWidth(), ((ImageIcon)AU_2CH_pictures.get(Severity.Other)).getIconHeight() + 1);
        } else if (ch_count == 4 && _pictures.get(4) == null) {
            HashMap<Severity, ImageIcon> AU_4CH_pictures = new HashMap<Severity, ImageIcon>();
            AU_4CH_pictures.put(Severity.Critical, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Red.gif")));
            AU_4CH_pictures.put(Severity.Major, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Orange.gif")));
            AU_4CH_pictures.put(Severity.Minor, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Yellow.gif")));
            AU_4CH_pictures.put(Severity.Warning, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Blue.gif")));
            AU_4CH_pictures.put(Severity.Indeterminate, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Green.gif")));
            AU_4CH_pictures.put(Severity.Cleared, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Green.gif")));
            AU_4CH_pictures.put(Severity.Other, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Green.gif")));
            AU_4CH_pictures.put(Severity.unexpectedValue, new ImageIcon(AUComponent.class.getResource("/com/bwanms/rb/gui/images/chasis/AU_4CH_Green.gif")));
            _pictures.put(4, AU_4CH_pictures);
            this.setSize(((ImageIcon)AU_4CH_pictures.get(Severity.Other)).getIconWidth(), ((ImageIcon)AU_4CH_pictures.get(Severity.Other)).getIconHeight() + 1);
        }
    }

    public void draw(Graphics g) {
        int dy = 0;
        boolean drawSelected = this.isSelected();
        if (this._selectedChannel >= 0) {
            drawSelected = false;
        } else {
            for (BMAXChannel ch : this.getChannels()) {
                if (!ch.isSelected()) continue;
                drawSelected = false;
                break;
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, drawSelected ? 0.7f : 1.0f));
        if (PlatformConfiguration.isLocalPlatform()) {
            g2d.drawImage(picturesForCraft.get(this.channelsCount).get(this.getStatus()).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else if (this.getStatus() == 5) {
            g2d.drawImage(_pictures.get(this.channelsCount).get(Severity.Critical).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g2d.drawImage(_pictures.get(this.channelsCount).get(this.alarmSeverityLevel).getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        }
        int k = 0;
        for (BMAXChannel ch : this.getChannels()) {
            dy = this.Y + k * (((BaseChannel)ch).getHeight() + 20);
            if (this._selectedChannel < 0) {
                ch.draw(g.create(this.X, dy, this.X + ((BaseChannel)ch).getWidth(), dy + ((BaseChannel)ch).getHeight()), ch.isSelected());
            } else {
                ch.draw(g.create(this.X, dy, this.X + ((BaseChannel)ch).getWidth(), dy + ((BaseChannel)ch).getHeight()), this._selectedChannel == k);
            }
            ++k;
        }
        g.drawString("" + this.getSlotNumber(), 20, 239);
    }

    public void mouseClicked(MouseEvent e) {
        int dy = 0;
        BMAXChasisMouseEvent evt = new BMAXChasisMouseEvent(e);
        evt.setCard(this.getName());
        evt.setSerialNo(this.getSerialNo());
        evt.setBMAXComponent(this);
        this.deselectAllChannels();
        int k = 0;
        for (BMAXChannel ch : this.getChannels()) {
            dy = this.Y + k * (((BaseChannel)ch).getHeight() + 20);
            if (e.getX() > this.X && e.getX() < this.X + ((BaseChannel)ch).getWidth() && e.getY() > dy && e.getY() < dy + ((BaseChannel)ch).getHeight()) {
                this.selectChannel(k);
                evt.setChannel(k);
                evt.setBMAXChannel(ch);
                ((BaseChannel)ch).dispatchEvent(e);
                break;
            }
            ++k;
        }
        for (BMAXChasisMouseListener lsnr : this._listeners) {
            lsnr.mouseClicked(evt);
        }
    }

    public void mouseMoved(MouseEvent e) {
        int dy = 0;
        int k = 0;
        Component channel = null;
        for (BMAXChannel ch : this.getChannels()) {
            dy = this.Y + k * (((BaseChannel)ch).getHeight() + 20);
            if (e.getX() > this.X && e.getX() < this.X + ((BaseChannel)ch).getWidth() && e.getY() > dy && e.getY() < dy + ((BaseChannel)ch).getHeight()) {
                channel = (BaseChannel)ch;
                break;
            }
            ++k;
        }
        if (channel != null) {
            this.setToolTipText(channel.toString());
        } else {
            this.setToolTipText(null);
        }
    }
}

