/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.icons;

import com.bwanms.rb.gui.icons.RbServiceUIIconFactory;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class RbServiceEntryUIIconFactory {
    private static ImageIcon image = new ImageIcon(RbServiceUIIconFactory.class.getResource("test.gif"));

    public static Icon getIconImpl(RbServiceConfigEntry serviceEntry) {
        return new RbServiceEntryIcon(image, serviceEntry);
    }

    private static class RbServiceEntryIcon
    implements Icon {
        private ImageIcon delegate;
        private RbServiceConfigEntry serviceEntry;

        public RbServiceEntryIcon(ImageIcon delegate, RbServiceConfigEntry serviceEntry) {
            this.delegate = delegate;
            this.serviceEntry = serviceEntry;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean grayed = false;
            int opStatus = null != this.serviceEntry.getRbServiceOperStatus() ? this.serviceEntry.getRbServiceOperStatus() : 3;
            switch (opStatus) {
                case 1: {
                    g.setColor(Color.GREEN);
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                    break;
                }
                case 2: {
                    g.setColor(Color.RED);
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                    break;
                }
                default: {
                    grayed = true;
                }
            }
            if (grayed) {
                Graphics2D g2d = (Graphics2D)g;
                Composite originalComposite = g2d.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alpha);
                g2d.drawImage(this.delegate.getImage(), x, y, c);
                g2d.setComposite(originalComposite);
            } else {
                g.drawImage(this.delegate.getImage(), x, y, c);
            }
        }

        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }
    }
}

