/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.icons;

import com.bwanms.gui.UIIconFactory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.model.RbGPSChain;
import com.bwanms.util.fault.EventUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class RbGPSChainUIIconFactory
extends UIIconFactory {
    private ImageIcon gpsChainIcon = new ImageIcon(RbGPSChainUIIconFactory.class.getResource("test.gif"));

    public Icon getIconForClassImpl(Class target) {
        return null;
    }

    public final Icon getIconImpl(Object target, int flags) {
        RbGPSChain gpsChain = (RbGPSChain)target;
        return new GPSChainIcon(this.getPlainIcon(gpsChain), gpsChain, flags);
    }

    public ImageIcon getPlainIcon(RbGPSChain gpsChain) {
        return this.gpsChainIcon;
    }

    class GPSChainIcon
    implements Icon {
        private ImageIcon delegate;
        private int flags;
        private RbGPSChain gpsChain;

        public GPSChainIcon(ImageIcon delegate, RbGPSChain gpsChain, int flags) {
            this.delegate = delegate;
            this.gpsChain = gpsChain;
            this.flags = flags;
        }

        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }

        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean grayed = false;
            if ((this.flags & 2) != 0) {
                int alarmState = this.gpsChain.getAlarmState();
                if (alarmState != Severity.Other.value()) {
                    g.setColor(EventUtil.getSeverityColor((Severity)Severity.fromValue((int)alarmState)));
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                } else {
                    grayed = true;
                }
            }
            if (grayed |= (this.flags & 1) != 0) {
                Graphics2D g2d = (Graphics2D)g;
                Composite originalComposite = g2d.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alpha);
                g2d.drawImage(this.delegate.getImage(), x, y, c);
                g2d.setComposite(originalComposite);
            } else {
                g.drawImage(this.delegate.getImage(), x, y, c);
            }
        }
    }
}

