/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.gpschain;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.rb.ddi.RbGPSChainSynchronizationHelper;
import com.bwanms.rb.gui.gpschain.GPSChainEditorPanel;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbGPSChain;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSChainEditorView
extends AbstractBindedEditorView<RbGPSChain> {
    private static Logger log = Logger.getLogger(GPSChainEditorView.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(GPSChainEditorView.class);
    private static final String TIME_ZONE_OFFSET_FROM_UTC_PATTERN = "-((0?\\d?|1?[01]?):[03]0|12:00)|\\+((0?\\d?|1?[0-2]?):[03]0|13:00)";
    private static final String DAYLIGHT_SAVING_ADV_FACTIOR_PATTERN = "\\+?0[0-4]:(00|15|30|45)";
    private GPSChainEditorPanel panel = new GPSChainEditorPanel();
    private Binder gpsChainBinder;
    private boolean canClose = false;
    private Integer originalGpsProtocol;

    public GPSChainEditorView() {
        this.panel.getTblEquipments().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GPSChainEditorView.this.controlTableButtons();
                super.mouseClicked(e);
            }
        });
        this.panel.getTblEquipments().getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                GPSChainEditorView.this.controlTableButtons();
            }
        });
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        this.gpsChainBinder = new DefaultBinder((Object)this.panel, (Object)this.entity).add((Binding)new JTextFieldBinding("txtTimeZoneOffsetFromUTC", "timeZoneOffsetFromUTC")).add((Binding)new JTextFieldBinding("txtDaylightSavingDateStart", "daylightSavingDateStart")).add((Binding)new JTextFieldBinding("txtDaylightSavingDateStop", "daylightSavingDateStop")).add((Binding)new JTextFieldBinding("txtDaylightSavingAdvFactor", "daylightSavingAdvFactor")).add((Binding)new JComboBoxBinding("cmbCfgType", "gpsType")).add((Binding)new JComboBoxBinding("cmbDaylightSavingStatus", "daylightSavingStatus")).add((Binding)new JComboBoxBinding("cmbStopTxAfterHoldOverTimeout", "stopTxAfterHoldOverTimeout")).add((Binding)new JSpinnerBinding("spnCfgChainNumber", "gpsChainNumber")).add((Binding)new JSpinnerBinding("spnHoldOverPassedTimeout", "holdOverPassedTimeout"));
        binders.add(this.gpsChainBinder);
        return binders;
    }

    public void fillUI(RbGPSChain entity) {
        this.panel.getSpnCfgChainNumber().setEnabled(null == entity.getGpsChainNumber() || 0L == entity.getGpsChainNumber());
        this.originalGpsProtocol = entity.getGpsType();
        this.refreshBSList();
    }

    public List<InvalidValue> configureEntity(RbGPSChain entity) {
        Long rbHoldOverPassedTimeout;
        String rbTimeZoneOffsetFromUTC;
        List invalidValues = super.configureEntity((Serializable)entity);
        if (this.panel.getSpnCfgChainNumber().isEnabled()) {
            Long rbChainNumber = (Long)this.panel.getSpnCfgChainNumber().getValue();
            if (rbChainNumber < 1L || rbChainNumber > 1500L) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidChainNumber"), JSpinner.class, i18n.translateString("ChainNumber"), (Object)rbChainNumber, (Object)this.panel.getSpnCfgChainNumber()));
            }
            if (!this.checkChainNumber(rbChainNumber)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ChainNumberNotUnique"), JSpinner.class, i18n.translateString("ChainNumber"), (Object)rbChainNumber, (Object)this.panel.getSpnCfgChainNumber()));
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        sdf.setLenient(false);
        if (this.panel.getTxtDaylightSavingDateStart().isEnabled()) {
            String rbDaylightSavingDateStart = this.panel.getTxtDaylightSavingDateStart().getText().trim();
            if (rbDaylightSavingDateStart.matches("\\d{2}\\p{Punct}\\d{2}")) {
                try {
                    sdf.parse(rbDaylightSavingDateStart + ".2000");
                }
                catch (ParseException ex) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidDaylightSavingDateStart"), JTextField.class, i18n.translateString("DaylightSavingStartDate"), (Object)rbDaylightSavingDateStart, (Object)this.panel.getTxtDaylightSavingDateStart()));
                }
            } else {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidDaylightSavingDateStart"), JTextField.class, i18n.translateString("DaylightSavingStartDate"), (Object)rbDaylightSavingDateStart, (Object)this.panel.getTxtDaylightSavingDateStart()));
            }
            String rbDaylightSavingDateStop = this.panel.getTxtDaylightSavingDateStop().getText().trim();
            if (rbDaylightSavingDateStop.matches("\\d{2}\\p{Punct}\\d{2}")) {
                try {
                    sdf.parse(rbDaylightSavingDateStop + ".2000");
                }
                catch (ParseException ex) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidDaylightSavingDateStop"), JTextField.class, i18n.translateString("DaylightSavingStopDate"), (Object)rbDaylightSavingDateStop, (Object)this.panel.getTxtDaylightSavingDateStop()));
                }
            } else {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidDaylightSavingDateStop"), JTextField.class, i18n.translateString("DaylightSavingStopDate"), (Object)rbDaylightSavingDateStop, (Object)this.panel.getTxtDaylightSavingDateStop()));
            }
            String rbDaylightSavingAdvFactor = this.panel.getTxtDaylightSavingAdvFactor().getText().trim();
            if (!rbDaylightSavingAdvFactor.matches(DAYLIGHT_SAVING_ADV_FACTIOR_PATTERN)) {
                invalidValues.add(new InvalidValue(i18n.translateString("WrongDaylightAdvFactor"), JTextField.class, i18n.translateString("DaylightSavingAdvanceFactor"), (Object)rbDaylightSavingAdvFactor, (Object)this.panel.getTxtDaylightSavingAdvFactor()));
            }
        }
        if (!(rbTimeZoneOffsetFromUTC = this.panel.getTxtTimeZoneOffsetFromUTC().getText().trim()).matches(TIME_ZONE_OFFSET_FROM_UTC_PATTERN)) {
            invalidValues.add(new InvalidValue(i18n.translateString("WrongUTCOffset"), JTextField.class, i18n.translateString("TimeZoneOffsetFromUTC"), (Object)rbTimeZoneOffsetFromUTC, (Object)this.panel.getTxtTimeZoneOffsetFromUTC()));
        }
        if ((rbHoldOverPassedTimeout = (Long)this.panel.getSpnHoldOverPassedTimeout().getValue()) < 0L || rbHoldOverPassedTimeout > 2880L) {
            invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetween", new Object[]{0, 2880}), JSpinner.class, i18n.translateString("HoldOverPassedTimeout"), (Object)rbHoldOverPassedTimeout, (Object)this.panel.getSpnHoldOverPassedTimeout()));
        }
        return invalidValues;
    }

    public JComponent getUI() {
        this.panel.getBtnRefresh().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPSChainEditorView.this.refreshBSList();
            }
        });
        this.panel.getBtnApply().setVisible(false);
        this.panel.getBtnAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, null);
                SelectorUtil.displayModalSelector((JComponent)GPSChainEditorView.this.panel, (SelectorView)selectorView);
                List selection = selectorView.getSelection();
                if (!selection.isEmpty()) {
                    boolean addedAll = true;
                    for (RbBaseStationEquipment bs : selection) {
                        addedAll &= this.addBSToModel(bs);
                    }
                    if (!addedAll) {
                        MessageBox.Info.quickShow((Component)GPSChainEditorView.this.panel, i18n.translateString("ExixtingEquipmentAndNonChainEquipmentWareSkipped"));
                    }
                }
            }

            private boolean addBSToModel(RbBaseStationEquipment bs) {
                EntityManagerTableModel<Object[]> model = GPSChainEditorView.this.panel.getTableModel();
                boolean found = false;
                for (Object[] rowData : model.getEntities()) {
                    if (bs.getId() != ((RbBaseStationEquipment)((Object)rowData[0])).getId()) continue;
                    found = true;
                    break;
                }
                if (!found && RbGPSChainSynchronizationHelper.isGPSChainApplicable(bs)) {
                    model.addRow((Object)new Object[]{bs}, String.valueOf(bs.getId()));
                    model.setRowState(model.getRowCount() - 1, 2);
                    return true;
                }
                return false;
            }
        });
        this.panel.getBtnRevert().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormUtil.cancelTableEditing((JTable)GPSChainEditorView.this.panel.getTblEquipments());
                int[] selectedRows = GPSChainEditorView.this.panel.getTblEquipments().getSelectedRows();
                Arrays.sort(selectedRows);
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    GPSChainEditorView.this.panel.getTableModel().revertRow(selectedRows[i]);
                }
                GPSChainEditorView.this.controlTableButtons();
            }
        });
        return this.panel;
    }

    public String getTitle() {
        return i18n.translateString("GPSChain");
    }

    public void processExternalInvalidValues(List<InvalidValue> invalidValues) {
        ArrayList UIinvalidValues = new ArrayList();
        this.gpsChainBinder.toUIInvalidValues(UIinvalidValues, invalidValues);
        invalidValues.clear();
        invalidValues.addAll(UIinvalidValues);
    }

    public String getApplicationPermission() {
        return "Av:ConfigureEquipment";
    }

    public String getHelpTopic() {
        return "adding_editing_gpschain";
    }

    public RbGPSChain save() {
        RbGPSChain gpsChain = (RbGPSChain)this.getEditorViewContext().save();
        return gpsChain;
    }

    public void refreshBSList() {
        if (0L == ((RbGPSChain)this.entity).getId()) {
            return;
        }
        EntityManagerTableModel<Object[]> model = this.panel.getTableModel();
        model.clearTable();
        ArrayList<RbBaseStationEquipment> bsEquipmentList = null;
        try {
            Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbGPSChain.class, ((RbGPSChain)this.entity).getId(), "editor");
            bsEquipmentList = new ArrayList<RbBaseStationEquipment>(((RbGPSChain)assembly.getEntity()).getEquipmentList());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        Collections.sort(bsEquipmentList, new Comparator<RbBaseStationEquipment>(){

            @Override
            public int compare(RbBaseStationEquipment o1, RbBaseStationEquipment o2) {
                return o1.getGpsClockMode().compareTo(o2.getGpsClockMode());
            }
        });
        for (RbBaseStationEquipment bs : bsEquipmentList) {
            model.addRow((Object)new Object[]{bs}, String.valueOf(bs.getId()));
        }
        model.setColumnReadonly(0, true);
        model.setColumnReadonly(1, true);
        model.setColumnReadonly(2, true);
    }

    boolean doSave() {
        boolean gpsProtocolChanged;
        this.canClose = true;
        final EntityManagerTableModel<Object[]> model = this.panel.getTableModel();
        if (0 == model.getRowCount()) {
            return null != this.getEditorViewContext().save();
        }
        boolean needsResetConfirmation = gpsProtocolChanged = this.isGpsProtocolChanged((Integer)((ComboItem)this.panel.getCmbCfgType().getSelectedItem()).getValue());
        ArrayList<Integer> clockModes = new ArrayList<Integer>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            Integer clockMode = (Integer)model.getValueAt(row, 3);
            clockModes.add(clockMode);
            if (needsResetConfirmation || model.getRowState(row) != 3 && model.getRowState(row) != 2) continue;
            Object[] values = (Object[])model.getEntity(row);
            RbBaseStationEquipment bs = (RbBaseStationEquipment)((Object)values[0]);
            needsResetConfirmation = !clockMode.equals(bs.getGpsClockMode());
        }
        String errMsg = this.checkClockModes(clockModes);
        if (null != errMsg) {
            MessageBox.Error.showResult((Component)this.panel, i18n.translateString(errMsg), i18n.translateString("InvalidClockModeConfiguration"));
            return false;
        }
        boolean resetConfirmed = false;
        if (needsResetConfirmation) {
            int resetEquipmentResult = MessageBox.ConfirmWithCancel.showOption((Component)this.panel, i18n.translateString("ResetEquipmentAfterApplyConfirmation"), i18n.translateString("PleaseConfirm"));
            boolean bl = resetConfirmed = resetEquipmentResult == 0;
            if (resetEquipmentResult != 0 && resetEquipmentResult != 1) {
                return false;
            }
        }
        if (null == this.getEditorViewContext().save()) {
            return false;
        }
        final boolean fResetConfirmed = resetConfirmed;
        AbstractLongOperation updateOperation = new AbstractLongOperation(){

            public String getTitle() {
                return i18n.translateString("UpdateDevicesLongOpTitle");
            }

            public boolean isCancelable() {
                return true;
            }

            public long getMaxProgress() {
                return model.getRowCount();
            }

            public void run() {
                long progress = 0L;
                for (int row = 0; row < model.getRowCount(); ++row) {
                    if (this.shouldCancel) {
                        this.monitor.logMessage(i18n.translateString("Canceled"));
                        GPSChainEditorView.this.canClose = false;
                        break;
                    }
                    Object[] values = (Object[])model.getEntity(row);
                    RbBaseStationEquipment bs = (RbBaseStationEquipment)((Object)values[0]);
                    ArrayList<Class> moClass = new ArrayList<Class>();
                    moClass.add(RbBSClockConfigParameters.class);
                    moClass.add(RbChainConfig.class);
                    this.monitor.updateProgress(progress, i18n.translateString("UpdatingEquipment", new Object[]{bs.getName(), bs.getIPAddress()}));
                    boolean doReset = fResetConfirmed && gpsProtocolChanged;
                    try {
                        boolean mosChanged;
                        List mos = ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(bs.getId(), "BS", moClass, false);
                        RbChainConfig chainConfig = (RbChainConfig)((Object)mos.get(1));
                        chainConfig.getChangeStrategy().acknowledge();
                        chainConfig.setRbConfiguredChainNumber(((RbGPSChain)GPSChainEditorView.this.entity).getGpsChainNumber());
                        chainConfig.setRbGPSConfiguredType(((RbGPSChain)GPSChainEditorView.this.entity).getGpsType());
                        chainConfig.setRbStopTxAfterHoldOverTimeout(((RbGPSChain)GPSChainEditorView.this.entity).getStopTxAfterHoldOverTimeout());
                        chainConfig.setRbHoldOverPassedTimeout(((RbGPSChain)GPSChainEditorView.this.entity).getHoldOverPassedTimeout());
                        chainConfig.setRbTimeZoneOffsetFromUTC(((RbGPSChain)GPSChainEditorView.this.entity).getTimeZoneOffsetFromUTC());
                        chainConfig.setRbDaylightSavingStatus(((RbGPSChain)GPSChainEditorView.this.entity).getDaylightSavingStatus());
                        if (Integer.valueOf(1).equals(((RbGPSChain)GPSChainEditorView.this.entity).getDaylightSavingStatus())) {
                            chainConfig.setRbDaylightSavingDateStart(((RbGPSChain)GPSChainEditorView.this.entity).getDaylightSavingDateStart());
                            chainConfig.setRbDaylightSavingDateStop(((RbGPSChain)GPSChainEditorView.this.entity).getDaylightSavingDateStop());
                            chainConfig.setRbDaylightSavingAdvFactor(((RbGPSChain)GPSChainEditorView.this.entity).getDaylightSavingAdvFactor());
                        }
                        RbBSClockConfigParameters bsClockParam = (RbBSClockConfigParameters)((Object)mos.get(0));
                        bsClockParam.getChangeStrategy().acknowledge();
                        if (model.getRowState(row) == 3 || model.getRowState(row) == 2) {
                            Integer clockMode = (Integer)model.getValueAt(row, 3);
                            if (fResetConfirmed) {
                                doReset |= !clockMode.equals(bs.getGpsClockMode());
                            }
                            bsClockParam.setRbBSConfiguredClockMode(clockMode);
                        }
                        boolean bl = mosChanged = chainConfig.getChangeStrategy().isChanged() || bsClockParam.getChangeStrategy().isChanged();
                        if (mosChanged) {
                            ServiceRegistry.getConfigurationService().updateCurrentConfiguration(bs.getId(), mos);
                            if (doReset) {
                                ArrayList<Object> commands = new ArrayList<Object>(1);
                                if (bs instanceof RbMBS) {
                                    commands.add(((RbMBS)bs).createResetCommand());
                                } else {
                                    commands.add(((RbBS)bs).getRunningNPU().createResetCommand());
                                }
                                ServiceRegistry.getConfigurationService().sendData(bs.getId(), commands);
                            }
                            this.monitor.logMessage(i18n.translateString("SuccesfullyUpdated", new Object[]{bs.getName(), bs.getEUID()}));
                        } else {
                            this.monitor.logMessage(i18n.translateString("NoUpdateNeeded", new Object[]{bs.getName(), bs.getEUID()}));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        this.monitor.logMessage(i18n.translateString("ErrorUpdating", new Object[]{bs.getName(), bs.getEUID(), e.getMessage()}));
                        if (++progress == this.getMaxProgress()) {
                            this.monitor.updateProgress(progress, i18n.translateString("UpdatingEquipment", new Object[]{bs.getName(), bs.getEUID()}));
                        }
                        GPSChainEditorView.this.canClose = false;
                        continue;
                    }
                    this.monitor.updateProgress(++progress, i18n.translateString("UpdatingEquipment", new Object[]{bs.getName(), bs.getEUID()}));
                }
                this.monitor.operationCompleted(false);
            }
        };
        LongOperationUtil.startDetailLongOperationDialog((JComponent)this.panel, (LongOperation)updateOperation);
        if (this.canClose) {
            return true;
        }
        this.refreshBSList();
        return false;
    }

    private boolean isGpsProtocolChanged(Integer gpsProtocol) {
        return !gpsProtocol.equals(this.originalGpsProtocol);
    }

    private static boolean isChainNumberChanged(RbGPSChain rbGPSChain, RbChainConfig rbChainConfig) {
        if (rbGPSChain == null || rbChainConfig == null) {
            return false;
        }
        if (rbGPSChain.getGpsChainNumber() == null) {
            return rbChainConfig.getRbConfiguredChainNumber() != null;
        }
        return !rbGPSChain.getGpsChainNumber().equals(rbChainConfig.getRbConfiguredChainNumber());
    }

    private static boolean isClockModeChanged(RbBSClockConfigParameters rbBSClockConfigParameters, Integer newClockMode) {
        if (rbBSClockConfigParameters == null) {
            return false;
        }
        if (rbBSClockConfigParameters.getRbBSConfiguredClockMode() == null) {
            return newClockMode != null;
        }
        return !rbBSClockConfigParameters.getRbBSConfiguredClockMode().equals(newClockMode);
    }

    private boolean checkChainNumber(Long chainNo) {
        try {
            LightQuery query = new LightQuery(RbGPSChain.class);
            query.addParameter("id", (Object)chainNo.intValue());
            List chains = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (null != chains && !chains.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    private String checkClockModes(List<Integer> clockModes) {
        Collections.sort(clockModes);
        if (clockModes.size() > 0) {
            int clockMode = clockModes.get(0);
            if (clockMode != 1) {
                return "MasterIsMissing";
            }
            if (clockModes.size() > 1) {
                clockMode = clockModes.get(1);
                if (clockMode == 1) {
                    return "DuplicateMasterInChain";
                }
                if (clockMode > 3) {
                    return "Slave1Missing";
                }
                int lastClockMode = clockMode;
                for (int i = 2; i < clockModes.size(); ++i) {
                    clockMode = clockModes.get(i);
                    if (clockMode == lastClockMode) {
                        return "Slave" + (clockMode - 1) + "Duplicated";
                    }
                    if (clockMode > lastClockMode + 1) {
                        return "Slave" + clockMode + "Missing";
                    }
                    lastClockMode = clockMode;
                }
            }
        }
        return null;
    }

    public void controlTableButtons() {
        int row = this.panel.getTblEquipments().getSelectedRow();
        if (row < 0 || row >= this.panel.getTableModel().getRowCount()) {
            this.panel.getBtnRevert().setEnabled(false);
            return;
        }
        if (this.panel.getTableModel().getRowState(row) == 0) {
            this.panel.getBtnRevert().setEnabled(false);
        } else if (this.panel.getTableModel().getRowState(row) == 1 || this.panel.getTableModel().getRowState(row) == 3) {
            this.panel.getBtnRevert().setEnabled(true);
        } else if (this.panel.getTableModel().getRowState(row) == 5 || this.panel.getTableModel().getRowState(row) == 2) {
            this.panel.getBtnRevert().setEnabled(true);
        } else {
            this.panel.getBtnRevert().setEnabled(false);
        }
    }
}

