/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.gpschain;

import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.GPSConfigForm42;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.IpAddress;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSChainEditorPanel
extends JPanel {
    private Internationalizer ddi18n = Internationalizer.getInternationalizer((String)"com.bwanms.ddi");
    private Internationalizer i18n = Internationalizer.getInternationalizer(GPSChainEditorPanel.class);
    private Internationalizer cfgI18n = Internationalizer.getInternationalizer(GPSConfigForm42.class);
    private EntityManagerTableModel<Object[]> tableModel;
    private JComponent tspChainConfiguration;
    private JLabel lblCfgChainNumber;
    private JSpinner spnCfgChainNumber;
    private JLabel lblCfgType;
    private JComboBox cmbCfgType;
    private JComponent separator1;
    private JLabel lblStopTxAfterHoldOverTimeout;
    private JComboBox cmbStopTxAfterHoldOverTimeout;
    private JLabel lblDaylightSavingStatus;
    private JComboBox cmbDaylightSavingStatus;
    private JLabel lblHoldOverPassedTimeout;
    private JSpinner spnHoldOverPassedTimeout;
    private JLabel lblDaylightSavingDateStart;
    private JTextField txtDaylightSavingDateStart;
    private JLabel lblTimeZoneOffsetFromUTC;
    private JTextField txtTimeZoneOffsetFromUTC;
    private JLabel lblDaylightSavingDateStop;
    private JTextField txtDaylightSavingDateStop;
    private JLabel lblDaylightSavingAdvFactor;
    private JTextField txtDaylightSavingAdvFactor;
    private JComponent separator2;
    private JPanel panel1;
    private JButton btnRevert;
    private JButton btnAdd;
    private JScrollPane scrollPane1;
    private JTable tblEquipments;
    private JPanel panel2;
    private JButton btnRefresh;
    private JButton btnApply;
    private JLabel lblRequires;

    public GPSChainEditorPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.cmbCfgType.addItem(new ComboItem((Object)0, this.cfgI18n.translateString(RbChainConfig.toStringRbGPSConfiguredType(0))));
        this.cmbCfgType.addItem(new ComboItem((Object)2, this.cfgI18n.translateString(RbChainConfig.toStringRbGPSConfiguredType(2))));
        this.cmbCfgType.addItem(new ComboItem((Object)1, this.cfgI18n.translateString(RbChainConfig.toStringRbGPSConfiguredType(1))));
        this.cmbDaylightSavingStatus.addItem(new ComboItem((Object)1, this.cfgI18n.translateString(RbChainConfig.toStringRbDaylightSavingStatus(1))));
        this.cmbDaylightSavingStatus.addItem(new ComboItem((Object)2, this.cfgI18n.translateString(RbChainConfig.toStringRbDaylightSavingStatus(2))));
        this.cmbStopTxAfterHoldOverTimeout.addItem(new ComboItem((Object)1, this.cfgI18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(1))));
        this.cmbStopTxAfterHoldOverTimeout.addItem(new ComboItem((Object)2, this.cfgI18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(2))));
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem((Object)1, this.cfgI18n.translateString(RbBSClockConfigParameters.toStringRbBSConfiguredClockMode(1))));
        items.add(new ComboItem((Object)3, this.cfgI18n.translateString(RbBSClockConfigParameters.toStringRbBSConfiguredClockMode(3))));
        items.add(new ComboItem((Object)4, this.cfgI18n.translateString(RbBSClockConfigParameters.toStringRbBSConfiguredClockMode(4))));
        items.add(new ComboItem((Object)5, this.cfgI18n.translateString(RbBSClockConfigParameters.toStringRbBSConfiguredClockMode(5))));
        items.add(new ComboItem((Object)6, this.cfgI18n.translateString(RbBSClockConfigParameters.toStringRbBSConfiguredClockMode(6))));
        this.tableModel = new EntityManagerTableModel<Object[]>(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(this.i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(this.i18n.translateString("Type"), String.class), new SimpleRowTableModel.ColumnDefinition(this.i18n.translateString("IpAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(this.i18n.translateString("ClockMode*"), Integer.class, items)}){

            public void setRowValues(int row, Object[] entity) {
                int col = 0;
                RbBaseStationEquipment equipment = (RbBaseStationEquipment)((Object)entity[0]);
                this.setInitialValueAt(equipment.getName(), row, col++);
                this.setInitialValueAt(GPSChainEditorPanel.this.ddi18n.translateString(((Object)((Object)equipment)).getClass().getName()), row, col++);
                this.setInitialValueAt(new IpAddress(equipment.getIpAddr().longValue()).toString(), row, col++);
                this.setInitialValueAt(equipment.getGpsClockMode(), row, col++);
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 3;
            }
        };
        SimpleRowTable srTable = new SimpleRowTable(this.tblEquipments, this.tableModel);
        srTable.setComboCellEditor(3);
        this.tblEquipments.setSelectionMode(0);
        this.i18n.getSwingInternationalizer().translateComponent((Component)this);
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.tspChainConfiguration = compFactory.createSeparator("ChainConfiguration");
        this.lblCfgChainNumber = new JLabel();
        this.spnCfgChainNumber = new JSpinner();
        this.lblCfgType = new JLabel();
        this.cmbCfgType = new JComboBox();
        this.separator1 = compFactory.createSeparator("");
        this.lblStopTxAfterHoldOverTimeout = new JLabel();
        this.cmbStopTxAfterHoldOverTimeout = new JComboBox();
        this.lblDaylightSavingStatus = new JLabel();
        this.cmbDaylightSavingStatus = new JComboBox();
        this.lblHoldOverPassedTimeout = new JLabel();
        this.spnHoldOverPassedTimeout = new JSpinner();
        this.lblDaylightSavingDateStart = new JLabel();
        this.txtDaylightSavingDateStart = new JTextField();
        this.lblTimeZoneOffsetFromUTC = new JLabel();
        this.txtTimeZoneOffsetFromUTC = new JTextField();
        this.lblDaylightSavingDateStop = new JLabel();
        this.txtDaylightSavingDateStop = new JTextField();
        this.lblDaylightSavingAdvFactor = new JLabel();
        this.txtDaylightSavingAdvFactor = new JTextField();
        this.separator2 = compFactory.createSeparator("Equipment");
        this.panel1 = new JPanel();
        this.btnRevert = new JButton();
        this.btnAdd = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.tblEquipments = new JTable();
        this.panel2 = new JPanel();
        this.btnRefresh = new JButton();
        this.btnApply = new JButton();
        this.lblRequires = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(800, 400));
        this.setMinimumSize(new Dimension(640, 400));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)110), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)70)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)110), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)70)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.add((Component)this.tspChainConfiguration, cc.xywh(1, 1, 11, 1));
        this.lblCfgChainNumber.setText("ChainNumber*");
        this.add((Component)this.lblCfgChainNumber, cc.xy(3, 3));
        this.spnCfgChainNumber.setModel(new SpinnerNumberModel(new Long(0L), null, null, new Long(1L)));
        this.add((Component)this.spnCfgChainNumber, cc.xywh(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.lblCfgType.setText("GPSType*");
        this.add((Component)this.lblCfgType, cc.xy(7, 3));
        this.add((Component)this.cmbCfgType, cc.xy(9, 3));
        this.add((Component)this.separator1, cc.xywh(1, 5, 11, 1));
        this.lblStopTxAfterHoldOverTimeout.setText("StopTxAfterHoldOverTimeout");
        this.add((Component)this.lblStopTxAfterHoldOverTimeout, cc.xywh(3, 7, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.add((Component)this.cmbStopTxAfterHoldOverTimeout, cc.xywh(5, 7, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.lblDaylightSavingStatus.setText("DaylightSavingStatus");
        this.add((Component)this.lblDaylightSavingStatus, cc.xywh(7, 7, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.cmbDaylightSavingStatus.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GPSChainEditorPanel.this.cmbDaylightSavingStatusItemStateChanged(e);
            }
        });
        this.add((Component)this.cmbDaylightSavingStatus, cc.xywh(9, 7, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.lblHoldOverPassedTimeout.setText("HoldOverPassedTimeout");
        this.add((Component)this.lblHoldOverPassedTimeout, cc.xywh(3, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.spnHoldOverPassedTimeout.setModel(new SpinnerNumberModel(new Long(0L), null, null, new Long(1L)));
        this.add((Component)this.spnHoldOverPassedTimeout, cc.xywh(5, 9, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.lblDaylightSavingDateStart.setText("DaylightSavingStartDate");
        this.add((Component)this.lblDaylightSavingDateStart, cc.xywh(7, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.txtDaylightSavingDateStart.setHorizontalAlignment(4);
        this.add((Component)this.txtDaylightSavingDateStart, cc.xywh(9, 9, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.lblTimeZoneOffsetFromUTC.setText("TimeZoneOffsetFromUTC");
        this.add((Component)this.lblTimeZoneOffsetFromUTC, cc.xywh(3, 11, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.txtTimeZoneOffsetFromUTC.setHorizontalAlignment(4);
        this.add((Component)this.txtTimeZoneOffsetFromUTC, cc.xywh(5, 11, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.lblDaylightSavingDateStop.setText("DaylightSavingStopDate");
        this.add((Component)this.lblDaylightSavingDateStop, cc.xywh(7, 11, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.txtDaylightSavingDateStop.setHorizontalAlignment(4);
        this.add((Component)this.txtDaylightSavingDateStop, cc.xywh(9, 11, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.lblDaylightSavingAdvFactor.setText("DaylightSavingAdvanceFactor");
        this.add((Component)this.lblDaylightSavingAdvFactor, cc.xywh(7, 13, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.txtDaylightSavingAdvFactor.setHorizontalAlignment(4);
        this.add((Component)this.txtDaylightSavingAdvFactor, cc.xywh(9, 13, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.add((Component)this.separator2, cc.xywh(1, 15, 11, 1));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.btnRevert.setText("Revert");
        this.btnRevert.setEnabled(false);
        this.panel1.add((Component)this.btnRevert, cc.xy(1, 1));
        this.btnAdd.setText("Add");
        this.panel1.add((Component)this.btnAdd, cc.xy(3, 1));
        this.add((Component)this.panel1, cc.xywh(1, 17, 11, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.scrollPane1.setViewportView(this.tblEquipments);
        this.add((Component)this.scrollPane1, cc.xywh(1, 19, 11, 1));
        this.panel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.dluX((int)50)), FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.btnRefresh.setText("Refresh");
        this.panel2.add((Component)this.btnRefresh, cc.xy(3, 1));
        this.btnApply.setText("Apply");
        this.panel2.add((Component)this.btnApply, cc.xy(1, 1));
        this.add((Component)this.panel2, cc.xywh(1, 21, 11, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.lblRequires.setText("*RequiresRebootToTakeEffect");
        this.add((Component)this.lblRequires, cc.xywh(1, 23, 11, 1));
    }

    private void cmbDaylightSavingStatusItemStateChanged(ItemEvent e) {
        boolean enableDaylightSaving = (Integer)((ComboItem)e.getItem()).getValue() == 1;
        this.txtDaylightSavingDateStart.setEnabled(enableDaylightSaving);
        this.txtDaylightSavingDateStop.setEnabled(enableDaylightSaving);
        this.txtDaylightSavingAdvFactor.setEnabled(enableDaylightSaving);
    }

    public JSpinner getSpnCfgChainNumber() {
        return this.spnCfgChainNumber;
    }

    public JComboBox getCmbCfgType() {
        return this.cmbCfgType;
    }

    public JComboBox getCmbStopTxAfterHoldOverTimeout() {
        return this.cmbStopTxAfterHoldOverTimeout;
    }

    public JComboBox getCmbDaylightSavingStatus() {
        return this.cmbDaylightSavingStatus;
    }

    public JSpinner getSpnHoldOverPassedTimeout() {
        return this.spnHoldOverPassedTimeout;
    }

    public JTextField getTxtDaylightSavingDateStart() {
        return this.txtDaylightSavingDateStart;
    }

    public JTextField getTxtTimeZoneOffsetFromUTC() {
        return this.txtTimeZoneOffsetFromUTC;
    }

    public JTextField getTxtDaylightSavingDateStop() {
        return this.txtDaylightSavingDateStop;
    }

    public JTextField getTxtDaylightSavingAdvFactor() {
        return this.txtDaylightSavingAdvFactor;
    }

    public JButton getBtnAdd() {
        return this.btnAdd;
    }

    public JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    public JButton getBtnApply() {
        return this.btnApply;
    }

    public EntityManagerTableModel<Object[]> getTableModel() {
        return this.tableModel;
    }

    public JButton getBtnRevert() {
        return this.btnRevert;
    }

    public JTable getTblEquipments() {
        return this.tblEquipments;
    }
}

