/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services.preview;

import com.bwanms.gui.Preview;
import com.bwanms.gui.editor.PreviewContainer;
import com.bwanms.rb.gui.configuration.services.preview.ServiceProfilePreview;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProfilePreviewContainer
extends PreviewContainer<RbServiceTemplateConfigEntry> {
    private ServiceProfilePreview serviceProfilePreview;

    public ServiceProfilePreviewContainer(RbServiceTemplateConfigEntry entity, RbBaseStationEquipment equipment, Object ... data) {
        super((Object)entity, data);
        this.postInitPrewiew(entity, equipment);
    }

    public Preview<RbServiceTemplateConfigEntry> initPreview(RbServiceTemplateConfigEntry entity, Object ... data) {
        this.serviceProfilePreview = new ServiceProfilePreview();
        this.serviceProfilePreview.setForwardingRuleConfigEntry(this.getSelectedForwardingRule(entity, (Collection)data[0]));
        this.serviceProfilePreview.setPolicyRuleConfigEntry(this.getSelectedPolicyRule(entity, (Collection)data[1]));
        this.serviceProfilePreview.setQoSProfiles((Collection)data[2]);
        if (data.length > 3) {
            this.serviceProfilePreview.setVplDomainsEntry(this.getSelectedVPLDomain(entity, (Collection)data[3]));
        }
        if (data.length > 4) {
            this.serviceProfilePreview.setServiceGroupEntry(this.getSelectedServiceGroup(entity, (Collection)data[4]));
        }
        return this.serviceProfilePreview;
    }

    private void postInitPrewiew(RbServiceTemplateConfigEntry entity, RbBaseStationEquipment equipment) {
        Integer serviceTemplateType = entity.getRbServiceTemplateType();
        if (equipment != null && equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
            this.serviceProfilePreview.getUI().getTabbedPane1().remove(this.serviceProfilePreview.getUI().getForwardingRulePreviewPanel1());
        }
        if (equipment != null && equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS && serviceTemplateType != 7) {
            this.serviceProfilePreview.getUI().getTabbedPane1().remove(this.serviceProfilePreview.getUI().getPnlGeneral());
        }
        if (serviceTemplateType == null || serviceTemplateType != 6 && serviceTemplateType != 7) {
            this.serviceProfilePreview.getUI().getTabbedPane1().remove(this.serviceProfilePreview.getUI().getVoiceDomainPreviewPanel());
        }
    }

    public String getTitle() {
        return "Preview";
    }

    private RbForwardingRuleConfigEntry getSelectedForwardingRule(RbServiceTemplateConfigEntry selectedEntity, Collection<RbForwardingRuleConfigEntry> table) {
        for (RbForwardingRuleConfigEntry entry : table) {
            if (!entry.getRbForwardingRuleIdx().equals(selectedEntity.getRbServiceTemplateForwardingRuleIdx())) continue;
            return entry;
        }
        return null;
    }

    private RbPolicyRuleConfigEntry getSelectedPolicyRule(RbServiceTemplateConfigEntry selectedEntity, Collection<RbPolicyRuleConfigEntry> table) {
        for (RbPolicyRuleConfigEntry entry : table) {
            if (!entry.getRbPolicyRuleIdx().equals(selectedEntity.getRbServiceTemplatePolicyRuleIdx())) continue;
            return entry;
        }
        return null;
    }

    private RbVoiceDomainsEntry getSelectedVPLDomain(RbServiceTemplateConfigEntry selectedEntity, Collection<RbVoiceDomainsEntry> table) {
        if (selectedEntity != null && table != null) {
            for (RbVoiceDomainsEntry entry : table) {
                if (!entry.getRbVoiceDomainIdx().equals(selectedEntity.getRbServiceTemplateVoiceDomainIdx())) continue;
                return entry;
            }
        }
        return null;
    }

    private RbServiceGroupEntry getSelectedServiceGroup(RbServiceTemplateConfigEntry selectedEntity, Collection<RbServiceGroupEntry> table) {
        if (selectedEntity != null && table != null) {
            for (RbServiceGroupEntry entry : table) {
                if (!entry.getRbServiceGroupName().equals(selectedEntity.getRbServiceTemplateGroupName())) continue;
                return entry;
            }
        }
        return null;
    }
}

