/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services.preview;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Preview;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorView;
import com.bwanms.rb.gui.configuration.services.preview.ForwardingRulePreview;
import com.bwanms.rb.gui.configuration.services.preview.PolicyRulePreview;
import com.bwanms.rb.gui.configuration.services.preview.ServiceGroupPreview;
import com.bwanms.rb.gui.configuration.services.preview.ServiceProfilePreviewTabbedPanel;
import com.bwanms.rb.gui.configuration.services.preview.VoiceDomainPreviewPanel;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProfilePreview
implements Preview<RbServiceTemplateConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorView.class);
    private ServiceProfilePreviewTabbedPanel panel;
    private ForwardingRulePreview frPreview;
    private PolicyRulePreview prPreview;
    private RbForwardingRuleConfigEntry forwardingRuleConfigEntry;
    private RbPolicyRuleConfigEntry policyRuleConfigEntry;
    private RbVoiceDomainsEntry vplDomainsEntry;
    private RbServiceGroupEntry serviceGroupEntry;

    public ServiceProfilePreview() {
        this(new ServiceProfilePreviewTabbedPanel());
    }

    public ServiceProfilePreview(ServiceProfilePreviewTabbedPanel panel) {
        this.panel = panel;
        this.initFRPreview();
        this.initPRPreview();
    }

    private void initPRPreview() {
        this.prPreview = new PolicyRulePreview(this.panel.getPolicyRulePreviewPanel1());
    }

    private void initFRPreview() {
        this.frPreview = new ForwardingRulePreview(this.panel.getForwardingRulePreviewPanel1());
    }

    public void setEntity(RbServiceTemplateConfigEntry entity) {
        this.panel.getTxtServiceProfileName().setText(entity.getRbServiceTemplateName());
        this.panel.getTxtServiceProfileType().setText(i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(entity.getRbServiceTemplateType())));
        this.panel.getTxtVLANTransparencyMode().setText(i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateVLANTransparencyMode(entity.getRbServiceTemplateVLANTransparencyMode())));
        this.panel.getTxtPriorityMarkingMode().setText(i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateQoSMarkingMode(entity.getRbServiceTemplateQoSMarkingMode())));
        if (entity.getRbServiceTemplateBaseVLAN() != null) {
            this.panel.getTxtVPLId().setText(entity.getRbServiceTemplateBaseVLAN() >= 4095 && entity.getRbServiceTemplateBaseVLAN() != 4096 ? i18n.translateString("None") : entity.getRbServiceTemplateBaseVLAN().toString());
        }
        if (entity.getRbServiceTemplateQoSMarkingValue() != null) {
            this.panel.getTxtPriorityMarkingValue().setText(entity.getRbServiceTemplateQoSMarkingValue().toString());
        }
        if (!Integer.valueOf(2).equals(entity.getRbServiceTemplateType()) && entity.getRbServiceTemplateNumberOfSimultaneousCalls() != null) {
            this.panel.getTxtMaxNumberOfVoiceCalls().setText(entity.getRbServiceTemplateNumberOfSimultaneousCalls().toString());
        }
        this.frPreview.setEntity(this.forwardingRuleConfigEntry);
        if (entity.getRbServiceTemplateType() != 3) {
            this.prPreview.setEntity(this.policyRuleConfigEntry);
        } else {
            this.panel.getTabbedPane1().remove(this.panel.getPolicyRulePreviewPanel1());
        }
        if (Integer.valueOf(1).equals(entity.getRbServiceTemplateVLANTransparencyMode())) {
            this.panel.getTabbedPane1().remove(this.panel.getForwardingRulePreviewPanel1());
        }
        if (entity.getRbServiceTemplateType() == 7 || entity.getRbServiceTemplateType() == 6) {
            this.fillVPLDomainTabb();
        } else {
            this.panel.getTabbedPane1().remove(this.panel.getVoiceDomainPreviewPanel());
        }
        if (entity.getRbServiceTemplateType() == 4 && null != entity.getRbServiceTemplateGroupName()) {
            this.fillServiceGroupTabb();
        }
        if (entity.getRbServiceTemplateType() == 7) {
            this.panel.getTxtVLANTransparencyMode().setVisible(false);
            this.panel.getTxtPriorityMarkingMode().setVisible(false);
            this.panel.getTxtPriorityMarkingValue().setVisible(false);
            this.panel.getTxtVPLId().setVisible(false);
            this.panel.getLblVLANTransparencyMode().setVisible(false);
            this.panel.getLblPriorityMarkingMode().setVisible(false);
            this.panel.getLblPriorityMarkingValue().setVisible(false);
            this.panel.getLblVPLID().setVisible(false);
        }
        if (entity.getRbServiceTemplateType() != 4 || null == entity.getRbServiceTemplateGroupName()) {
            this.panel.getTabbedPane1().remove(this.panel.getServiceGroupPreview());
        }
    }

    public ServiceProfilePreviewTabbedPanel getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return i18n.translateString("ServiceProfilePreview");
    }

    public ForwardingRulePreview getFrPreview() {
        return this.frPreview;
    }

    public PolicyRulePreview getPrPreview() {
        return this.prPreview;
    }

    public RbForwardingRuleConfigEntry getForwardingRuleConfigEntry() {
        return this.forwardingRuleConfigEntry;
    }

    public void setForwardingRuleConfigEntry(RbForwardingRuleConfigEntry forwardingRuleConfigEntry) {
        this.forwardingRuleConfigEntry = forwardingRuleConfigEntry;
    }

    public RbPolicyRuleConfigEntry getPolicyRuleConfigEntry() {
        return this.policyRuleConfigEntry;
    }

    public void setPolicyRuleConfigEntry(RbPolicyRuleConfigEntry policyRuleConfigEntry) {
        this.policyRuleConfigEntry = policyRuleConfigEntry;
    }

    public void setQoSProfiles(Collection<RbQoSProfileConfigEntry> table) {
        this.prPreview.setQoSProfiles(table);
        this.frPreview.setQoSProfiles(table);
    }

    public void setVplDomainsEntry(RbVoiceDomainsEntry vplDomainsEntry) {
        this.vplDomainsEntry = vplDomainsEntry;
    }

    public void setServiceGroupEntry(RbServiceGroupEntry serviceGroupEntry) {
        this.serviceGroupEntry = serviceGroupEntry;
    }

    private void fillVPLDomainTabb() {
        if (this.vplDomainsEntry != null) {
            VoiceDomainPreviewPanel voiceDomainPreviewPanel = this.panel.getVoiceDomainPreviewPanel();
            voiceDomainPreviewPanel.getTxtName().setText(this.vplDomainsEntry.getRbVoiceDomainName());
            voiceDomainPreviewPanel.getTxtPrimaryPFIpAddress().setText(this.vplDomainsEntry.getRbVoiceDomainPrimaryPFIpAddress());
        }
    }

    private void fillServiceGroupTabb() {
        if (this.serviceGroupEntry != null) {
            ServiceGroupPreview serviceGroupPreview = this.panel.getServiceGroupPreview();
            serviceGroupPreview.getGrupNametxt().setText(this.serviceGroupEntry.getRbServiceGroupName());
            serviceGroupPreview.getIspDomainNametxt().setText(this.serviceGroupEntry.getRbServiceGroupIspDomainName());
            serviceGroupPreview.getNomadicitytxt().setText(i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupNomadicity(this.serviceGroupEntry.getRbServiceGroupNomadicity())));
            serviceGroupPreview.getTypetxt().setText(i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupType(this.serviceGroupEntry.getRbServiceGroupType())));
            if (this.serviceGroupEntry.getRbServiceGroupType() != 2) {
                serviceGroupPreview.getRelayModetxt().setVisible(false);
                serviceGroupPreview.getGiIPtxt().setVisible(false);
                serviceGroupPreview.getGiSubnettxt().setVisible(false);
                serviceGroupPreview.getDhcpServerIPtxt().setVisible(false);
                serviceGroupPreview.getVLANIDtxt().setVisible(false);
                serviceGroupPreview.getGatewaytxt().setVisible(false);
                serviceGroupPreview.getLblrelayMode().setVisible(false);
                serviceGroupPreview.getLblgiIP().setVisible(false);
                serviceGroupPreview.getLblgiSubnet().setVisible(false);
                serviceGroupPreview.getLbldhcpServerSubnet().setVisible(false);
                serviceGroupPreview.getLblVLANID().setVisible(false);
                serviceGroupPreview.getLblgateway().setVisible(false);
            } else {
                serviceGroupPreview.getRelayModetxt().setText(i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupRelayMode(this.serviceGroupEntry.getRbServiceGroupRelayMode())));
                if (this.serviceGroupEntry.getRbServiceGroupRelayMode() == 1) {
                    serviceGroupPreview.getGiIPtxt().setText(this.serviceGroupEntry.getRbServiceGroupGiIpAddress());
                    serviceGroupPreview.getGiSubnettxt().setText(this.serviceGroupEntry.getRbServiceGroupGiSubnetMask());
                    serviceGroupPreview.getDhcpServerIPtxt().setText(this.serviceGroupEntry.getRbServiceGroupDhcpServerIp());
                    serviceGroupPreview.getVLANIDtxt().setText(this.serviceGroupEntry.getRbServiceGroupVlanId().toString());
                    serviceGroupPreview.getGatewaytxt().setText(this.serviceGroupEntry.getRbServiceGroupGateway());
                } else {
                    serviceGroupPreview.getRelayModetxt().setText(i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupRelayMode(this.serviceGroupEntry.getRbServiceGroupRelayMode())));
                    serviceGroupPreview.getGiIPtxt().setVisible(false);
                    serviceGroupPreview.getGiSubnettxt().setVisible(false);
                    serviceGroupPreview.getDhcpServerIPtxt().setVisible(false);
                    serviceGroupPreview.getVLANIDtxt().setVisible(false);
                    serviceGroupPreview.getGatewaytxt().setVisible(false);
                    serviceGroupPreview.getLblgiIP().setVisible(false);
                    serviceGroupPreview.getLblgiSubnet().setVisible(false);
                    serviceGroupPreview.getLbldhcpServerSubnet().setVisible(false);
                    serviceGroupPreview.getLblVLANID().setVisible(false);
                    serviceGroupPreview.getLblgateway().setVisible(false);
                }
            }
        }
    }
}

