/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services.preview;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Preview;
import com.bwanms.rb.gui.configuration.services.RbPriorityClassifierEditorView;
import com.bwanms.rb.gui.configuration.services.preview.PolicyRulePreviewPanel;
import com.bwanms.rb.gui.configuration.services.preview.PolicyRulePreviewPart;
import com.bwanms.rb.gui.configuration.services.preview.QoSPreview;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import java.util.Collection;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyRulePreview
implements Preview<RbPolicyRuleConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbPriorityClassifierEditorView.class);
    private PolicyRulePreviewPanel panel;
    private QoSPreview upQoSPreview1;
    private QoSPreview upQoSPreview2;
    private QoSPreview upQoSPreview3;
    private QoSPreview upQoSPreview4;
    private QoSPreview downQoSPreview1;
    private QoSPreview downQoSPreview2;
    private QoSPreview downQoSPreview3;
    private QoSPreview downQoSPreview4;
    private Collection<RbQoSProfileConfigEntry> qosTable;

    public PolicyRulePreview() {
        this(new PolicyRulePreviewPanel());
    }

    public PolicyRulePreview(PolicyRulePreviewPanel panel) {
        this.panel = panel;
        this.initQoS();
    }

    private void initQoS() {
        PolicyRulePreviewPart part1 = this.panel.getPolicyRulePreviewPart1();
        this.upQoSPreview1 = new QoSPreview(part1.getQoSPreviewPanel1());
        this.upQoSPreview2 = new QoSPreview(part1.getQoSPreviewPanel2());
        this.upQoSPreview3 = new QoSPreview(part1.getQoSPreviewPanel3());
        this.upQoSPreview4 = new QoSPreview(part1.getQoSPreviewPanel4());
        PolicyRulePreviewPart part2 = this.panel.getPolicyRulePreviewPart2();
        this.downQoSPreview1 = new QoSPreview(part2.getQoSPreviewPanel1());
        this.downQoSPreview2 = new QoSPreview(part2.getQoSPreviewPanel2());
        this.downQoSPreview3 = new QoSPreview(part2.getQoSPreviewPanel3());
        this.downQoSPreview4 = new QoSPreview(part2.getQoSPreviewPanel4());
    }

    public void setEntity(RbPolicyRuleConfigEntry entity) {
        if (entity != null) {
            this.panel.getTxtName().setText(entity.getRbPolicyRuleName());
            this.panel.getTxtPriorityType().setText(i18n.translateString(RbPolicyRuleConfigEntry.toStringRbPolicyRulePriorityType(entity.getRbPolicyRulePriorityType())));
            PolicyRulePreviewPart part1 = this.panel.getPolicyRulePreviewPart1();
            part1.getTxtUpperLimit1().setText(entity.getRbPolicyRuleUpQoSUpperLimit1().toString());
            part1.getTxtUpperLimit2().setText(entity.getRbPolicyRuleUpQoSUpperLimit2().toString());
            part1.getTxtUpperLimit3().setText(entity.getRbPolicyRuleUpQoSUpperLimit3().toString());
            part1.getTxtUpperLimit4().setText(entity.getRbPolicyRuleUpQoSUpperLimit4().toString());
            PolicyRulePreviewPart part2 = this.panel.getPolicyRulePreviewPart2();
            part2.getTxtUpperLimit1().setText(entity.getRbPolicyRuleDownQoSUpperLimit1().toString());
            part2.getTxtUpperLimit2().setText(entity.getRbPolicyRuleDownQoSUpperLimit2().toString());
            part2.getTxtUpperLimit3().setText(entity.getRbPolicyRuleDownQoSUpperLimit3().toString());
            part2.getTxtUpperLimit4().setText(entity.getRbPolicyRuleDownQoSUpperLimit4().toString());
            this.setQoSValues(entity);
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return i18n.translateString("PriorityClassifierPreview");
    }

    public void setQoSProfiles(Collection<RbQoSProfileConfigEntry> table) {
        this.qosTable = table;
    }

    private void setQoSValues(RbPolicyRuleConfigEntry entity) {
        this.upQoSPreview1.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleUpQoSProfileIdx1(), this.qosTable));
        this.upQoSPreview2.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleUpQoSProfileIdx2(), this.qosTable));
        this.upQoSPreview3.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleUpQoSProfileIdx3(), this.qosTable));
        this.upQoSPreview4.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleUpQoSProfileIdx4(), this.qosTable));
        this.downQoSPreview1.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleDownQoSProfileIdx1(), this.qosTable));
        this.downQoSPreview2.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleDownQoSProfileIdx2(), this.qosTable));
        this.downQoSPreview3.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleDownQoSProfileIdx3(), this.qosTable));
        this.downQoSPreview4.setEntity(this.findQoSProfileConfigEntry(entity.getRbPolicyRuleDownQoSProfileIdx4(), this.qosTable));
    }

    private RbQoSProfileConfigEntry findQoSProfileConfigEntry(Long idx, Collection<RbQoSProfileConfigEntry> table) {
        if (idx != null) {
            for (RbQoSProfileConfigEntry entry : table) {
                if (!entry.getRbQoSProfileIdx().equals(idx)) continue;
                return entry;
            }
        }
        return null;
    }
}

