/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services.preview;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Preview;
import com.bwanms.rb.gui.configuration.services.RbForwardingRuleConfigEntryEditorView;
import com.bwanms.rb.gui.configuration.services.preview.ForwardingRulePreviewPanel;
import com.bwanms.rb.gui.configuration.services.preview.QoSPreview;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import java.util.Collection;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingRulePreview
implements Preview<RbForwardingRuleConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRuleConfigEntryEditorView.class);
    private ForwardingRulePreviewPanel panel;
    private QoSPreview qoSPreview;
    private Collection<RbQoSProfileConfigEntry> qosTable;

    public ForwardingRulePreview() {
        this(new ForwardingRulePreviewPanel());
    }

    public ForwardingRulePreview(ForwardingRulePreviewPanel panel) {
        this.panel = panel;
        this.initQoSPreview();
    }

    private void initQoSPreview() {
        this.qoSPreview = new QoSPreview(this.panel.getQoSPreviewPanel1());
    }

    public void setEntity(RbForwardingRuleConfigEntry entity) {
        if (entity != null) {
            this.panel.getTxtName().setText(entity.getRbForwardingRuleName());
            this.panel.getTxtType().setText(i18n.translateString(RbForwardingRuleConfigEntry.toStringRbForwardingRuleType(entity.getRbForwardingRuleType())));
            if (entity.getRbForwardingRuleType() != 2 && entity.getRbForwardingRuleType() != 3) {
                this.panel.getTxtUnicastRelaying().setText(i18n.translateString(RbForwardingRuleConfigEntry.toStringRbForwardingRuleUnicastRelaying(entity.getRbForwardingRuleUnicastRelaying())));
                this.panel.getTxtMulticastRelaying().setText(i18n.translateString(RbForwardingRuleConfigEntry.toStringRbForwardingRuleMulticastRelaying(entity.getRbForwardingRuleMulticastRelaying())));
                this.panel.getTxtUnknownAddressForwardingPolicy().setText(i18n.translateString(RbForwardingRuleConfigEntry.toStringRbForwardingUnknownAddrPolicy(entity.getRbForwardingUnknownAddrPolicy())));
            }
            if (entity.getRbForwardingRuleType() != 5) {
                this.panel.getMulticastVLANLbl().setVisible(true);
                this.panel.getTxtMulticastVLAN().setVisible(true);
                if (entity.getRbForwardingRuleMulticastVLAN() != null) {
                    this.panel.getTxtMulticastVLAN().setText(new Integer(4095).equals(entity.getRbForwardingRuleMulticastVLAN()) ? i18n.translateString("None") : entity.getRbForwardingRuleMulticastVLAN().toString());
                }
            } else {
                this.panel.getMulticastVLANLbl().setVisible(false);
                this.panel.getTxtMulticastVLAN().setVisible(false);
            }
            this.qoSPreview.setEntity(this.findQoSEntry(entity.getRbForwardingRuleMulticastQoSIdx(), this.qosTable));
        }
    }

    private RbQoSProfileConfigEntry findQoSEntry(Long idx, Collection<RbQoSProfileConfigEntry> table) {
        if (idx != null) {
            for (RbQoSProfileConfigEntry entry : table) {
                if (!entry.getRbQoSProfileIdx().equals(idx)) continue;
                return entry;
            }
        }
        return null;
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return false;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return i18n.translateString("ForwardingRulePreview");
    }

    public void setQoSProfiles(Collection<RbQoSProfileConfigEntry> table) {
        this.qosTable = table;
    }
}

