/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbVoiceDomainConfigEntryEditorView;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FireActionLabelMouseListener;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbVoiceDomainsConfigForm
extends RbComplexObjectTableConfigForm<RbVoiceDomainsEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbVoiceDomainsConfigForm.class);
    private UnifiedMOSupport<RbVoiceDomainsEntry> table;
    private List<Object> mos;
    private RbVoiceDomainConfigEntryEditorView view;
    private SimpleRowTable simpleRowTable;
    private int vdLimit;
    private boolean valid;

    @Override
    protected EditorView<RbVoiceDomainsEntry> getEditorView() {
        String runningSoftwareVersion = this.ctx.getEquipment().getRunningSoftwareVersion();
        Version running = VersionFactory.getInstance().createVersion(runningSoftwareVersion);
        Version createVersion = VersionFactory.getInstance().createVersion("4.5");
        this.valid = running.isNewerOrEqualWith(createVersion);
        this.vdLimit = RbFeatures.isNewLimitInVD((RbBaseStationEquipment)this.ctx.getEquipment()) ? 5 : 10;
        this.view = new RbVoiceDomainConfigEntryEditorView(this.valid);
        this.view.getUI().getLblPFIpAddressPrimary().addMouseListener((MouseListener)new FireActionLabelMouseListener(this.view.getUI().getLblPFIpAddressPrimary(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbVoiceDomainsConfigForm.this.ctx.getEquipment().getEUID() + "/PFParameters?serverIP=" + FormUtil.getSelectedValue((JComboBox)RbVoiceDomainsConfigForm.this.view.getUI().getCmbPrimaryPFIpAddress());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbVoiceDomainsConfigForm.this;
            }
        }));
        return this.view;
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Id"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    }

    protected void fillUI(List<Object> managedObjects) {
        String rowKey;
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(0);
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        ArrayList<RbVoiceDomainsEntry> entries = new ArrayList<RbVoiceDomainsEntry>();
        for (RbVoiceDomainsEntry voiceEntry : this.table.getInstances()) {
            entries.add(voiceEntry);
        }
        Collections.sort(entries, new Comparator<RbVoiceDomainsEntry>(){

            @Override
            public int compare(RbVoiceDomainsEntry o1, RbVoiceDomainsEntry o2) {
                return o1.getRbVoiceDomainIdx().compareTo(o2.getRbVoiceDomainIdx());
            }
        });
        for (RbVoiceDomainsEntry entry : entries) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbVoiceDomainIdx(), row, 0);
            this.tableModel.setInitialValueAt((Object)entry.getRbVoiceDomainName(), row, 1);
            ++row;
        }
        this.simpleRowTable.setBackgroundCallback(new SimpleRowTable.RowBackgroundCallback());
        ((RbVoiceDomainConfigEntryEditorView)this.editorView).setRBPFServers(((UnifiedMOSupport)managedObjects.get(1)).getInstances());
        this.tableModel.sort();
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbVoiceDomainsEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("voiceDomainId"));
        }
        if (rowKey != null) {
            int i;
            for (i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                break;
            }
            if (i == row) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected RbVoiceDomainsEntry getEntityForRow(int row) {
        return (RbVoiceDomainsEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbVoiceDomainsEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbBSPFServersEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceTemplateConfigEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbVoiceDomainsEntry getNewEntity() {
        RbVoiceDomainsEntry newEntry = new RbVoiceDomainsEntry();
        newEntry.setRbVoiceDomainIdx(10L);
        if (this.table == null) {
            return newEntry;
        }
        for (long i = 1L; i < 11L; ++i) {
            if (this.table.findInstance(String.valueOf(i)) != null) continue;
            newEntry.setRbVoiceDomainIdx(i);
            return newEntry;
        }
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbVoiceDomainsEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canAdd() {
        return this.tableModel.getRowCount() < this.vdLimit;
    }

    protected void configureMOs(Map<Class<?>, Object> moMap, List<InvalidValue> invalidValues) {
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbVoiceDomainsEntry e) {
        if (e.getRbVoiceDomainName() == null) {
            return true;
        }
        if (e.getRbVoiceDomainPrimaryPFIpAddress() == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("PrimaryPFIpAddressCantBeNull"), JComboBox.class, "PrimaryPFIpAddress", (Object)e.getRbVoiceDomainPrimaryPFIpAddress(), (Object)this.view.getUI().getCmbPrimaryPFIpAddress()));
            return false;
        }
        if (this.table != null) {
            for (RbVoiceDomainsEntry entry : this.table.getInstances()) {
                if (e == entry) continue;
                if (e.getRbVoiceDomainName().equals(entry.getRbVoiceDomainName()) && e.getId() != entry.getId()) {
                    invalidValues.add(new InvalidValue(i18n.translateString("nameUnique", new Object[]{entry.getRbVoiceDomainName()}), JTextField.class, "Name", (Object)e.getRbVoiceDomainName(), (Object)this.view.getUI().getTxtName()));
                    return false;
                }
                if (!this.valid) continue;
                String rbVoiceDomainPrimaryPFIpAddress2 = e.getRbVoiceDomainPrimaryPFIpAddress();
            }
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbVoiceDomainsEntry entry) {
        return this.checkServiceTemplate(invalidValues, entry);
    }

    private boolean checkServiceTemplate(List<InvalidValue> invalidValues, RbVoiceDomainsEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(2);
        for (RbServiceTemplateConfigEntry entry : table.getInstances()) {
            if (!e.getRbVoiceDomainIdx().equals(entry.getRbServiceTemplateVoiceDomainIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("VDusedSP", new Object[]{e.getRbVoiceDomainName(), entry.getRbServiceTemplateName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_voice_domain";
    }

    public boolean isValid() {
        return this.valid;
    }
}

