/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbSubscriberEntryEditorView;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSubscribersConfigForm
extends RbComplexObjectTableConfigForm<RbSubscriberEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbSubscribersConfigForm.class);
    private UnifiedMOSupport<RbSubscriberEntry> table;
    private List<Object> mos;

    @Override
    protected EditorView<RbSubscriberEntry> getEditorView() {
        return new RbSubscriberEntryEditorView();
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("SubscriberId"), Long.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("AdminStatus"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        new SimpleRowTable(jTable, this.tableModel);
    }

    protected void fillUI(List<Object> managedObjects) {
        String rowKey;
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(0);
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        ArrayList<RbSubscriberEntry> entries = new ArrayList<RbSubscriberEntry>();
        for (RbSubscriberEntry rbSubscriberEntry : this.table.getInstances()) {
            entries.add(rbSubscriberEntry);
        }
        Collections.sort(entries, new Comparator<RbSubscriberEntry>(){

            @Override
            public int compare(RbSubscriberEntry o1, RbSubscriberEntry o2) {
                return o1.getRbSubscriberIdx().compareTo(o2.getRbSubscriberIdx());
            }
        });
        for (RbSubscriberEntry entry : entries) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbSubscriberID(), row, 0);
            this.tableModel.setInitialValueAt((Object)i18n.translateString(RbSubscriberEntry.toStringRbSubscriberAdminStatus(entry.getRbSubscriberAdminStatus())), row, 1);
            ++row;
        }
        this.tableModel.sort();
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbSubscriberEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("subscriberId"));
        }
        if (rowKey != null) {
            int i;
            for (i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                break;
            }
            if (i == row) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected RbSubscriberEntry getEntityForRow(int row) {
        return (RbSubscriberEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbSubscriberEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceConfigEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbSubscriberEntry getNewEntity() {
        RbSubscriberEntry newEntry = new RbSubscriberEntry();
        newEntry.setRbSubscriberIdx(-1L);
        newEntry.setRbSubscriberAdminStatus(1);
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbSubscriberEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbSubscriberEntry e) {
        for (RbSubscriberEntry entry : this.table.getInstances()) {
            if (!e.getRbSubscriberID().equals(entry.getRbSubscriberID()) || e.getId() == entry.getId()) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("subscriberIDUnique", new Object[]{e.getRbSubscriberID()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbSubscriberEntry entry) {
        return this.checkService(invalidValues, entry);
    }

    private boolean checkService(List<InvalidValue> invalidValues, RbSubscriberEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(1);
        for (RbServiceConfigEntry entry : table.getInstances()) {
            if (!e.getRbSubscriberIdx().equals(entry.getRbSubscriberIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("SUusedSV", new Object[]{e.getRbSubscriberID(), entry.getRbServiceName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_subscribers";
        }
        return "ngnms.rb.help.bs_tdd_subscribers";
    }
}

