/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Identifiable;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorView;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FireActionLabelMouseListener;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServicesConfigForm
extends RbComplexObjectTableConfigForm<RbServiceConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServicesConfigForm.class);
    private static final Logger log = Logger.getLogger(RbServicesConfigForm.class);
    private UnifiedMOSupport<RbServiceConfigEntry> table;
    private List<Object> mos;
    private SimpleRowTable simpleRowTable;

    @Override
    protected EditorView<RbServiceConfigEntry> getEditorView() {
        final RbServiceConfigEntryEditorView view = new RbServiceConfigEntryEditorView((RbBaseStationEquipment)this.ctx.getEquipment());
        view.getUI().getLblServiceProfile().setCursor(Cursor.getPredefinedCursor(12));
        view.getUI().getLblSuMACAddress().setCursor(Cursor.getPredefinedCursor(12));
        view.getUI().getLblSubscriber().setCursor(Cursor.getPredefinedCursor(12));
        view.getUI().getLblServiceProfile().addMouseListener((MouseListener)new FireActionLabelMouseListener(view.getUI().getLblServiceProfile(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServicesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/ServiceProfiles?serviceProfileId=" + FormUtil.getSelectedValue((JComboBox)view.getUI().getComboServiceProfile());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServicesConfigForm.this;
            }
        }));
        view.getUI().getLblSuMACAddress().addMouseListener((MouseListener)new FireActionLabelMouseListener(view.getUI().getLblSuMACAddress(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServicesConfigForm.this.ctx.getEquipment().getEUID() + "/SubscriberUnits?subscriberUnitId=" + FormUtil.getSelectedValue((JComboBox)view.getUI().getComboSuMACAddress());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServicesConfigForm.this;
            }
        }));
        view.getUI().getLblSubscriber().addMouseListener((MouseListener)new FireActionLabelMouseListener(view.getUI().getLblSubscriber(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServicesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/Subscribers?subscriberId=" + FormUtil.getSelectedValue((JComboBox)view.getUI().getComboSubscriber());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServicesConfigForm.this;
            }
        }));
        return view;
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Type"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
            this.panel.getBtnAdd().setVisible(false);
            this.panel.getBtnDelete().setVisible(false);
            this.panel.getBtnRevert().setVisible(false);
        }
    }

    protected void fillUI(List<Object> managedObjects) {
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(1);
        ((RbServiceConfigEntryEditorView)this.editorView).setSubscribers(((UnifiedMOSupport)managedObjects.get(2)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setServices(this.table);
        ((RbServiceConfigEntryEditorView)this.editorView).setServiceProfiles(((UnifiedMOSupport)managedObjects.get(3)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setForwardingRules(((UnifiedMOSupport)managedObjects.get(4)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setPolicyRules(((UnifiedMOSupport)managedObjects.get(5)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setQoSProfiles(((UnifiedMOSupport)managedObjects.get(6)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setSubscriberUnits(((UnifiedMOSupport)managedObjects.get(0)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setVPLDomains(((UnifiedMOSupport)managedObjects.get(7)).getInstances());
        ((RbServiceConfigEntryEditorView)this.editorView).setServiceGroup(((UnifiedMOSupport)managedObjects.get(8)).getInstances());
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        for (RbServiceConfigEntry entry : this.table.getInstances()) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbServiceName(), row, 0);
            this.tableModel.setInitialValueAt((Object)i18n.translateString(RbServiceConfigEntry.toStringRbServiceType(entry.getRbServiceType())), row, 1);
            if (entry.isTemporary()) {
                this.tableModel.setRowState(row, -1);
            }
            ++row;
        }
        this.simpleRowTable.setBackgroundCallback(new SimpleRowTable.RowBackgroundCallback(){

            public Color getUnselectedRowBackgroundColor(int rowIndex) {
                RbServiceConfigEntry entity = (RbServiceConfigEntry)RbServicesConfigForm.this.table.findInstance(RbServicesConfigForm.this.tableModel.getRowKey(rowIndex));
                if (entity != null && entity.isTemporary()) {
                    return new Color(255, 200, 200);
                }
                return null;
            }
        });
        this.tableModel.sort();
        if (this.getCurrentEntity() != null && ((RbServiceConfigEntry)((Object)this.getCurrentEntity())).getRbServiceIdx() != -1L) {
            String rowKey = ((RbServiceConfigEntry)((Object)this.getCurrentEntity())).getRowKey();
            for (int i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                return;
            }
            this.setSelectedRow(-1);
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        int row;
        if (this.getCurrentEntity() != null && (this.getSelectedRow() == -2 || this.getSelectedRow() >= 0 && this.tableModel.getRowState(this.getSelectedRow()) != 1)) {
            List<InvalidValue> validation = this.configureCurrentEntity();
            if (validation.isEmpty()) {
                UnifiedMOSupport table = (UnifiedMOSupport)managedObjects.get(1);
                Object entry = (Identifiable)this.getCurrentEntity();
                if (entry.getId() == 0L && table.findInstance(((RbServiceConfigEntry)((Object)this.getCurrentEntity())).getRowKey()) == null) {
                    if (this.canAddEntry(invalidValues, (RbServiceConfigEntry)((Object)this.getCurrentEntity()))) {
                        table.addInstance(this.getCurrentEntity());
                    }
                } else {
                    this.canAddEntry(invalidValues, (RbServiceConfigEntry)((Object)this.getCurrentEntity()));
                }
            } else {
                invalidValues.addAll(validation);
                return;
            }
        }
        for (row = 0; row < this.tableModel.getRowCount(); ++row) {
            if (this.tableModel.getRowState(row) != 1) continue;
            RbServiceConfigEntry e = (RbServiceConfigEntry)this.getTable().findInstance(this.tableModel.getRowKey(row));
            if (e != null) {
                this.canDeleteEntry(invalidValues, e);
                continue;
            }
            log.info((Object)String.format("Row %d with key %s was not found in the table", row, this.tableModel.getRowKey(row)));
        }
        if (invalidValues.isEmpty()) {
            for (row = 0; row < this.tableModel.getRowCount(); ++row) {
                if (this.tableModel.getRowState(row) != 1) continue;
                this.getTable().removeInstance(this.tableModel.getRowKey(row));
            }
        }
        if (this.getCurrentEntity() != null && !((RbServiceConfigEntry)((Object)this.getCurrentEntity())).isTemporary()) {
            UnifiedMOSupport registeredSUs = (UnifiedMOSupport)managedObjects.get(0);
            for (Object entry : registeredSUs.getInstances()) {
                if (!entry.getRbSuMacAddr().toLowerCase().equals(((RbServiceConfigEntry)((Object)this.getCurrentEntity())).getRbServiceSuMacAddress().toLowerCase()) || entry.getRbSuPersistence() != 1) continue;
                if (FrameUtil.showConfirmation((Component)this.getUI(), (String)i18n.translateString("ChangeSuPersistenceToPermanent"))) {
                    RbRegisteredSuEntry changeableEntry = (RbRegisteredSuEntry)registeredSUs.findInstance(entry.getRowKey());
                    changeableEntry.setRbSuPersistence(2);
                    ((UnifiedMOSupport)managedObjects.get(0)).updateInstance((ManagedObject)changeableEntry);
                    break;
                }
                invalidValues.add(new InvalidValue(i18n.translateString("SuMustBePermanent"), null, "rbSuMacAddr", (Object)"", null));
                break;
            }
        }
        if (invalidValues.isEmpty()) {
            this.panel.getBtnDelete().setEnabled(false);
            this.panel.getBtnRevert().setEnabled(false);
        }
    }

    @Override
    protected RbServiceConfigEntry getEntityForRow(int row) {
        return (RbServiceConfigEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbRegisteredSuEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbSubscriberEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceTemplateConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbForwardingRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbPolicyRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbQoSProfileConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbVoiceDomainsEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceGroupEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbServiceConfigEntry getNewEntity() {
        RbServiceConfigEntry newEntry = new RbServiceConfigEntry(((RbBaseStationEquipment)this.ctx.getEquipment()).isTDDDuplexMode());
        newEntry.setRbServiceIdx(-1L);
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbServiceConfigEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbServiceConfigEntry e) {
        for (RbServiceConfigEntry entry : this.table.getInstances()) {
            if (!e.getRbServiceName().equals(entry.getRbServiceName()) || e.getId() == entry.getId()) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("nameUnique", new Object[]{e.getRbServiceName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbServiceConfigEntry service) {
        Collection registeredSUs = ((UnifiedMOSupport)this.mos.get(0)).getInstances();
        for (RbRegisteredSuEntry entry : registeredSUs) {
            if (!entry.getRbSuMacAddr().toLowerCase().equals(service.getRbServiceSuMacAddress().toLowerCase()) || entry.getRbSuPersistence() != 1) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("CannotDeleteSuTemporary", new Object[]{service.getRbServiceName()}), null, "rbSuMacAddr", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_services";
        }
        return "ngnms.rb.help.bs_tdd_services";
    }
}

