/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorView;
import com.bwanms.rb.gui.configuration.services.preview.ServiceProfilePreviewContainer;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FireActionLabelMouseListener;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfilesConfigForm
extends RbComplexObjectTableConfigForm<RbServiceTemplateConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfilesConfigForm.class);
    private UnifiedMOSupport<RbServiceTemplateConfigEntry> table;
    private List<Object> mos;
    private SimpleRowTable simpleRowTable;
    private RbServiceProfileEditorView rbServiceProfileEditorView;

    @Override
    protected EditorView<RbServiceTemplateConfigEntry> getEditorView() {
        this.rbServiceProfileEditorView = new RbServiceProfileEditorView((RbBaseStationEquipment)this.ctx.getEquipment());
        this.rbServiceProfileEditorView.getUI().getLblForwardingRule().addMouseListener((MouseListener)new FireActionLabelMouseListener(this.rbServiceProfileEditorView.getUI().getLblForwardingRule(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServiceProfilesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/ForwardingRules?forwardinRuleId=" + FormUtil.getSelectedValue((JComboBox)RbServiceProfilesConfigForm.this.rbServiceProfileEditorView.getUI().getComboForwardingRule());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServiceProfilesConfigForm.this;
            }
        }));
        this.rbServiceProfileEditorView.getUI().getLblPriorityClassifier().addMouseListener((MouseListener)new FireActionLabelMouseListener(this.rbServiceProfileEditorView.getUI().getLblPriorityClassifier(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServiceProfilesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/PolicyRules?policyRuleId=" + FormUtil.getSelectedValue((JComboBox)RbServiceProfilesConfigForm.this.rbServiceProfileEditorView.getUI().getComboPriorityClassifier());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServiceProfilesConfigForm.this;
            }
        }));
        this.rbServiceProfileEditorView.getUI().getLblVoiceDomain().addMouseListener((MouseListener)new FireActionLabelMouseListener(this.rbServiceProfileEditorView.getUI().getLblVoiceDomain(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServiceProfilesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/VoiceDomain?voiceDomainId=" + FormUtil.getSelectedValue((JComboBox)RbServiceProfilesConfigForm.this.rbServiceProfileEditorView.getUI().getComboVoiceDomainName());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServiceProfilesConfigForm.this;
            }
        }));
        this.rbServiceProfileEditorView.getUI().getLblServiceGroup().addMouseListener((MouseListener)new FireActionLabelMouseListener(this.rbServiceProfileEditorView.getUI().getLblServiceGroup(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbServiceProfilesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/ServiceGroup?serviceGroupId=" + FormUtil.getSelectedValue((JComboBox)RbServiceProfilesConfigForm.this.rbServiceProfileEditorView.getUI().getComboServiceGroup());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbServiceProfilesConfigForm.this;
            }
        }));
        return this.rbServiceProfileEditorView;
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Type"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
    }

    protected void fillUI(List<Object> managedObjects) {
        String rowKey;
        this.rbServiceProfileEditorView.setIsTddEquipment(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) >= 0);
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(0);
        ArrayList<RbServiceTemplateConfigEntry> serviceTemplates = new ArrayList<RbServiceTemplateConfigEntry>();
        for (RbServiceTemplateConfigEntry rbServiceTemplateConfigEntry : this.table.getInstances()) {
            serviceTemplates.add(rbServiceTemplateConfigEntry);
        }
        ((RbServiceProfileEditorView)this.editorView).setServicesTemplates(new RbServiceTemplateConfigTable(serviceTemplates));
        ArrayList<RbServiceConfigEntry> services = new ArrayList<RbServiceConfigEntry>();
        for (RbServiceConfigEntry rbServiceConfigEntry : ((UnifiedMOSupport)managedObjects.get(3)).getInstances()) {
            services.add(rbServiceConfigEntry);
        }
        ((RbServiceProfileEditorView)this.editorView).setServices(new RbServiceConfigTable(services));
        this.simpleRowTable.setBackgroundCallback(new SimpleRowTable.RowBackgroundCallback(){

            public Color getUnselectedRowBackgroundColor(int rowIndex) {
                RbServiceTemplateConfigEntry entity = RbServiceProfilesConfigForm.this.getEntityForRow(rowIndex);
                if (entity != null && Integer.valueOf(2).equals(entity.getRbServiceTemplateClass())) {
                    return new Color(255, 200, 200);
                }
                return null;
            }
        });
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        for (RbServiceTemplateConfigEntry entry : this.table.getInstances()) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbServiceTemplateName(), row, 0);
            this.tableModel.setInitialValueAt((Object)i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(entry.getRbServiceTemplateType())), row, 1);
            if (Integer.valueOf(2).equals(entry.getRbServiceTemplateClass())) {
                this.tableModel.setRowState(row, -1);
            }
            ++row;
        }
        this.tableModel.sort();
        ArrayList<RbForwardingRuleConfigEntry> fwRules = new ArrayList<RbForwardingRuleConfigEntry>();
        for (RbForwardingRuleConfigEntry fwEntry : ((UnifiedMOSupport)managedObjects.get(1)).getInstances()) {
            fwRules.add(fwEntry);
        }
        ((RbServiceProfileEditorView)this.editorView).setForwardingRules(fwRules);
        ArrayList<RbPolicyRuleConfigEntry> pRules = new ArrayList<RbPolicyRuleConfigEntry>();
        for (RbPolicyRuleConfigEntry prEntry : ((UnifiedMOSupport)managedObjects.get(2)).getInstances()) {
            pRules.add(prEntry);
        }
        ((RbServiceProfileEditorView)this.editorView).setPolicyRules(pRules);
        ArrayList<RbVoiceDomainsEntry> voiceDomains = new ArrayList<RbVoiceDomainsEntry>();
        for (RbVoiceDomainsEntry voiceEntry : ((UnifiedMOSupport)managedObjects.get(6)).getInstances()) {
            voiceDomains.add(voiceEntry);
        }
        ((RbServiceProfileEditorView)this.editorView).setVPLDomains(voiceDomains);
        ArrayList<RbServiceGroupEntry> serviceGroup = new ArrayList<RbServiceGroupEntry>();
        for (RbServiceGroupEntry sgEntry : ((UnifiedMOSupport)managedObjects.get(7)).getInstances()) {
            serviceGroup.add(sgEntry);
        }
        ((RbServiceProfileEditorView)this.editorView).setServiceGroup(serviceGroup);
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbServiceTemplateConfigEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("serviceProfileId"));
        }
        if (rowKey != null) {
            boolean found = false;
            for (int i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                found = true;
                break;
            }
            if (!found) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected RbServiceTemplateConfigEntry getEntityForRow(int row) {
        return (RbServiceTemplateConfigEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbServiceTemplateConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbForwardingRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbPolicyRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbDfltServiceTemplateEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbQoSProfileConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbVoiceDomainsEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceGroupEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbServiceTemplateConfigEntry getNewEntity() {
        RbServiceTemplateConfigEntry newEntry = new RbServiceTemplateConfigEntry();
        newEntry.setRbServiceTemplateIdx(-1L);
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            newEntry.setRbServiceTemplateBaseVLAN(4095);
        }
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbServiceTemplateConfigEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbServiceTemplateConfigEntry e) {
        for (RbServiceTemplateConfigEntry entry : this.table.getInstances()) {
            if (!e.getRbServiceTemplateName().equals(entry.getRbServiceTemplateName()) || e.getId() == entry.getId()) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("nameUnique", new Object[]{e.getRbServiceTemplateName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbServiceTemplateConfigEntry entry) {
        boolean result1 = this.checkService(invalidValues, entry);
        boolean result2 = this.checkDefaultTemplates(invalidValues, entry);
        return result1 && result2;
    }

    private boolean checkService(List<InvalidValue> invalidValues, RbServiceTemplateConfigEntry e) {
        for (RbServiceConfigEntry entry : ((UnifiedMOSupport)this.managedObjects.get(3)).getInstances()) {
            if (!e.getRbServiceTemplateIdx().equals(entry.getRbServiceServiceTemplateIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("SPusedSV", new Object[]{e.getRbServiceTemplateName(), entry.getRbServiceName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    private boolean checkDefaultTemplates(List<InvalidValue> invalidValues, RbServiceTemplateConfigEntry e) {
        for (RbDfltServiceTemplateEntry entry : ((UnifiedMOSupport)this.managedObjects.get(4)).getInstances()) {
            if (!e.getRbServiceTemplateIdx().equals(entry.getRbDfltServiceTemplateIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("SPdefault", new Object[]{e.getRbServiceTemplateName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canPreview() {
        return true;
    }

    @Override
    protected void showPreview(RbServiceTemplateConfigEntry currentEntity2) {
        new ServiceProfilePreviewContainer(currentEntity2, (RbBaseStationEquipment)this.ctx.getEquipment(), ((UnifiedMOSupport)this.mos.get(1)).getInstances(), ((UnifiedMOSupport)this.mos.get(2)).getInstances(), ((UnifiedMOSupport)this.mos.get(5)).getInstances(), ((UnifiedMOSupport)this.mos.get(6)).getInstances(), ((UnifiedMOSupport)this.mos.get(7)).getInstances());
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_service_profiles";
        }
        return "ngnms.rb.help.bs_tdd_service_profiles";
    }
}

