/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.mo.snmp.DynamicTableMO;
import com.bwanms.rb.ddi.RbServiceDeploymentHelper;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorPanel;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.ComboItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfileEditorView
extends AbstractBindedEditorView<RbServiceTemplateConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorView.class);
    private RbServiceProfileEditorPanel panel = new RbServiceProfileEditorPanel();
    private RbServiceTemplateConfigTable templateConfigTable;
    private DynamicTableMO serviceConfigTable;
    private boolean isTddEquipment = false;
    private RbBaseStationEquipment equipment;

    public RbServiceProfileEditorView(RbBaseStationEquipment equipment) {
        this.equipment = equipment;
        if (equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
            this.panel.getPnlFixedNomadicParameters().setVisible(false);
            this.panel.getPnlForwardingRule().setVisible(false);
            this.panel.getComboType().addItem(new ComboItem((Object)4, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(4)));
            this.panel.getComboType().addItem(new ComboItem((Object)5, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(5)));
            if (RbFeatures.isSipAwareAvailable(equipment)) {
                this.panel.getComboType().addItem(new ComboItem((Object)7, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(7)));
            }
        } else {
            this.panel.getComboType().addItem(new ComboItem((Object)1, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(1)));
            this.panel.getComboType().addItem(new ComboItem((Object)2, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(2)));
            this.panel.getComboType().addItem(new ComboItem((Object)3, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(3)));
            if (RbFeatures.isSipAwareAvailable(equipment)) {
                this.panel.getComboType().addItem(new ComboItem((Object)6, RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(6)));
            }
        }
        if (!RbFeatures.isSipAwareAvailable(equipment)) {
            this.panel.getPnlVoiceDomainName().setVisible(false);
        }
        if (!RbFeatures.isServiceGroupAvailable(equipment)) {
            this.panel.getPnlServiceGroup().setVisible(false);
        }
        i18n.translateCombo(this.panel.getComboType());
    }

    public List<Binder> getBinders() {
        JComboBoxBinding typeBinding = new JComboBoxBinding(i18n, "comboType", "rbServiceTemplateType", i18n.translateString("ServiceProfileType"));
        typeBinding.setIgnoreDisabled(true);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        JComboBoxBinding prRuleBinding = new JComboBoxBinding("comboPriorityClassifier", "rbServiceTemplatePolicyRuleIdx", (Object)0L, i18n.translateString("PriorityClassifier"));
        prRuleBinding.setIgnoreDisabled(true);
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "rbServiceTemplateName", i18n.translateString("ServiceProfileName"))).add((Binding)typeBinding).add((Binding)prRuleBinding));
        if (this.equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            JComboBoxBinding fwRuleBinding = new JComboBoxBinding("comboForwardingRule", "rbServiceTemplateForwardingRuleIdx", (Object)0L, i18n.translateString("ForwardingRule"));
            fwRuleBinding.setIgnoreDisabled(true);
            JComboBoxBinding templateQoSMarkingModeBinding = new JComboBoxBinding(i18n, "comboPriorityMarkingMode", "rbServiceTemplateQoSMarkingMode", i18n.translateString("PriorityMarkingMode"));
            templateQoSMarkingModeBinding.setIgnoreDisabled(true);
            JComboBoxBinding templateVLANTransparencyModeBinding = new JComboBoxBinding(i18n, "comboVLANTransparencyMode", "rbServiceTemplateVLANTransparencyMode", i18n.translateString("VLANTransparencyMode"));
            templateVLANTransparencyModeBinding.setIgnoreDisabled(true);
            binders.get(0).add((Binding)templateVLANTransparencyModeBinding).add((Binding)new JSpinnerBinding("spnrVPLId", "rbServiceTemplateBaseVLAN", i18n.translateString("VPLId"))).add((Binding)fwRuleBinding).add((Binding)templateQoSMarkingModeBinding).add((Binding)new JSpinnerBinding("spnrPriorityMarkingValue", "rbServiceTemplateQoSMarkingValue", i18n.translateString("PriorityMarkingValue"))).add((Binding)new JSpinnerBinding("spnrNoOfSimultaneousCalls", "rbServiceTemplateNumberOfSimultaneousCalls", i18n.translateString("MaxNumberOfVoiceCalls"))).add((Binding)new JComboBoxBinding("comboVoiceDomainName", "rbServiceTemplateVoiceDomainIdx", i18n.translateString("VPLDomain")));
        } else {
            ((Binder)binders.get(0)).add((Binding)new JComboBoxBinding("comboVoiceDomainName", "rbServiceTemplateVoiceDomainIdx", i18n.translateString("VPLDomain"))).add((Binding)new JSpinnerBinding("spnrNoOfSimultaneousCalls", "rbServiceTemplateNumberOfSimultaneousCalls", i18n.translateString("MaxNumberOfVoiceCalls")));
        }
        return binders;
    }

    public void fillUI(RbServiceTemplateConfigEntry entity) {
        boolean isTemplateClassGlobal = false;
        if (this.isTddEquipment) {
            isTemplateClassGlobal = entity != null && entity.getRbServiceTemplateClass() != null && entity.getRbServiceTemplateClass() == 2;
            this.setControlsEditable(!isTemplateClassGlobal);
        }
        this.panel.getLblGlobalParameter().setVisible(isTemplateClassGlobal);
        if (!isTemplateClassGlobal) {
            this.panel.getController().setTypeEnabled(entity.getId() == 0L);
            this.panel.getController().controlPriorityMarkingMode();
            this.panel.getController().controlVLANTransparencyMode();
            if (Integer.valueOf(3).equals(entity.getRbServiceTemplateType())) {
                this.panel.getComboPriorityClassifier().setEnabled(false);
                this.panel.getComboPriorityClassifier().setSelectedIndex(-1);
            }
            if (Integer.valueOf(2).equals(entity.getRbServiceTemplateType())) {
                this.panel.getSpnrNoOfSimultaneousCalls().setValue(0);
                this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(false);
            }
            if (!Integer.valueOf(6).equals(entity.getRbServiceTemplateType()) && !Integer.valueOf(7).equals(entity.getRbServiceTemplateType())) {
                this.panel.getComboVoiceDomainName().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setEnabled(false);
            }
            if (Integer.valueOf(7).equals(entity.getRbServiceTemplateType()) || Integer.valueOf(5).equals(entity.getRbServiceTemplateType())) {
                this.setForwardingVisibility(true);
            }
            if (Integer.valueOf(4).equals(entity.getRbServiceTemplateType()) || Integer.valueOf(5).equals(entity.getRbServiceTemplateType())) {
                this.panel.getPnlNoVoiceCalls().setVisible(false);
            }
            if (Integer.valueOf(7).equals(entity.getRbServiceTemplateType()) && this.equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                this.panel.getPnlNoVoiceCalls().setVisible(true);
            }
            JComboBox comboSG = this.panel.getComboServiceGroup();
            if (entity.getRbServiceTemplateType() != null) {
                if (!Integer.valueOf(4).equals(entity.getRbServiceTemplateType())) {
                    comboSG.setSelectedIndex(-1);
                    comboSG.setEnabled(false);
                } else {
                    this.setForwardingVisibility(false);
                    comboSG.setEnabled(true);
                    ComboBoxModel model = comboSG.getModel();
                    boolean found = false;
                    String templateGroupName = entity.getRbServiceTemplateGroupName();
                    for (int i = 0; i < model.getSize() && !found; ++i) {
                        ComboItem item = (ComboItem)model.getElementAt(i);
                        if (!item.getText().equals(templateGroupName)) continue;
                        found = true;
                        comboSG.setSelectedIndex(i);
                    }
                }
            }
        }
    }

    private void setForwardingVisibility(boolean aFlag) {
        this.panel.getComboForwardingRule().setEnabled(false);
        this.panel.getPnlForwardingRule().setVisible(aFlag);
    }

    public List<InvalidValue> configureEntity(RbServiceTemplateConfigEntry entity) {
        List<Object> values = new ArrayList<InvalidValue>();
        if (Integer.valueOf(2).equals(entity.getRbServiceTemplateClass())) {
            return values;
        }
        values = super.configureEntity((Serializable)((Object)entity));
        if (this.equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            if (Integer.valueOf(3).equals(entity.getRbServiceTemplateType())) {
                entity.setRbServiceTemplatePolicyRuleIdx(0L);
            }
            if (values.isEmpty()) {
                try {
                    RbServiceDeploymentHelper.checkServiceTemplateDeployment(entity, this.templateConfigTable, this.serviceConfigTable, this.equipment);
                }
                catch (ServiceManagementException e) {
                    values.add(new InvalidValue(RbServiceDeploymentHelper.getServiceDeploymentI18n().translateString(e.getMessage()), RbServiceConfigEntry.class, "", (Object)"", (Object)entity));
                }
            }
        } else {
            String name;
            values.clear();
            if (entity.getRbServiceTemplatePolicyRuleIdx() == null || entity.getRbServiceTemplatePolicyRuleIdx() == 0L) {
                values.add(new InvalidValue(i18n.translateString("policyRuleNotNull"), JComboBox.class, "PriorityClassifier", (Object)"", (Object)this.panel.getComboPriorityClassifier()));
            }
            if ((name = entity.getRbServiceTemplateName()) == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
                values.add(new InvalidValue(i18n.translateString("InvalidName"), JTextField.class, i18n.translateString("ServiceProfileName"), (Object)name, (Object)this.panel.getTxtServiceProfileName()));
            }
            if (!Integer.valueOf(7).equals(entity.getRbServiceTemplateType())) {
                entity.setRbServiceTemplateNumberOfSimultaneousCalls(null);
            } else {
                Integer value = entity.getRbServiceTemplateNumberOfSimultaneousCalls();
                if (value > 50 || value < 0) {
                    values.add(new InvalidValue(i18n.translateString("invalidMaxNoOfVoiceCall"), JSpinner.class, i18n.translateString("MaxNumberOfVoiceCalls"), (Object)value, (Object)this.panel.getSpnrNoOfSimultaneousCalls()));
                }
                if (entity.getRbServiceTemplateVoiceDomainIdx() == null) {
                    values.add(new InvalidValue(i18n.translateString("invalidVoiceDomain"), JComboBox.class, i18n.translateString("VoiceDomain"), (Object)"", (Object)this.panel.getComboVoiceDomainName()));
                }
            }
        }
        if (RbVersions.V_4_5.isOlderOrEqualWith(this.equipment.getSoftwareVersion()) && Integer.valueOf(4).equals(entity.getRbServiceTemplateType())) {
            ComboItem selectedItem = (ComboItem)this.panel.getComboServiceGroup().getSelectedItem();
            entity.setRbServiceTemplateGroupName(selectedItem.getText());
        } else {
            entity.setRbServiceTemplateGroupName(null);
        }
        if (Integer.valueOf(2).equals(entity.getRbServiceTemplateType())) {
            entity.setRbServiceTemplateNumberOfSimultaneousCalls(null);
        }
        return values;
    }

    public RbServiceProfileEditorPanel getUI() {
        return this.panel;
    }

    public String getTitle() {
        return "ServiceProfile";
    }

    private void setControlsEditable(boolean b) {
        this.panel.getTxtServiceProfileName().setEditable(b);
        this.panel.getComboForwardingRule().setEnabled(b);
        this.panel.getComboPriorityClassifier().setEnabled(b);
        this.panel.getComboPriorityMarkingMode().setEnabled(b);
        this.panel.getComboType().setEnabled(b);
        this.panel.getComboVLANTransparencyMode().setEnabled(b);
        this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(b);
        this.panel.getSpnrPriorityMarkingValue().setEnabled(b);
        this.panel.getSpnrVPLId().setEnabled(b);
        this.panel.getCkbxNoneVPLId().setEnabled(b);
    }

    public void setForwardingRules(List<RbForwardingRuleConfigEntry> entries) {
        this.panel.getController().setForwardingRules(entries);
    }

    public void setPolicyRules(List<RbPolicyRuleConfigEntry> entries) {
        this.panel.getController().setPolicyRules(entries);
    }

    public void setVPLDomains(List<RbVoiceDomainsEntry> entries) {
        this.panel.getController().setVPLDomains(entries);
    }

    public void setServiceGroup(List<RbServiceGroupEntry> entries) {
        this.panel.getController().setServiceGroup(entries);
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public void setServicesTemplates(RbServiceTemplateConfigTable templateConfigTable) {
        this.templateConfigTable = templateConfigTable;
    }

    public void setServices(DynamicTableMO serviceConfigTable) {
        this.serviceConfigTable = serviceConfigTable;
    }

    public void setIsTddEquipment(boolean isTdd) {
        this.isTddEquipment = isTdd;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.service_profile";
    }
}

