/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.BsDefaultsConfigForm;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorPanel;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JSpinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfileEditorPanelController {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorPanel.class);
    private static final Internationalizer i18n2 = Internationalizer.getInternationalizer(BsDefaultsConfigForm.class);
    private RbServiceProfileEditorPanel panel;
    private ArrayList<RbForwardingRuleConfigEntry> frEntries = new ArrayList();
    private ArrayList<RbVoiceDomainsEntry> vplDomainEntries = new ArrayList();
    private ArrayList<RbServiceGroupEntry> serviceGroupEntries = new ArrayList();
    private boolean initCompleted = false;

    public RbServiceProfileEditorPanelController(RbServiceProfileEditorPanel panel) {
        this.panel = panel;
    }

    public void controlPriorityMarkingMode() {
        this.controlPriorityMarkingMode((Integer)this.panel.getSpnrPriorityMarkingValue().getValue());
    }

    public boolean transparentModeSelected() {
        Integer selectedMode = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getComboVLANTransparencyMode());
        return selectedMode != null && selectedMode == 1;
    }

    public void controlPriorityMarkingMode(Integer value) {
        Integer selectedMode;
        if (value == null) {
            value = 0;
        }
        if ((selectedMode = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getComboPriorityMarkingMode())) != null) {
            JSpinner spinner = this.panel.getSpnrPriorityMarkingValue();
            switch (selectedMode) {
                case 1: {
                    spinner.setValue(0);
                    spinner.setEnabled(false);
                    break;
                }
                case 2: {
                    spinner.setEnabled(true);
                    spinner.setValue(value > 7 ? 7 : value);
                    break;
                }
                case 3: {
                    spinner.setEnabled(true);
                    spinner.setValue(value > 63 ? 63 : value);
                }
            }
        }
    }

    public void controlVLANTransparencyMode() {
        if (Integer.valueOf(1).equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboVLANTransparencyMode()))) {
            this.panel.getSpnrVPLId().setValue(4096);
            this.panel.getSpnrVPLId().setEnabled(false);
            FormUtil.setSelectedValue((JComboBox)this.panel.getComboVLANTransparencyMode(), (Object)1);
            ComboItem transparentFR = ComboItem.findItemByText((JComboBox)this.panel.getComboForwardingRule(), (String)"@@Transparent@@");
            if (transparentFR == null) {
                for (RbForwardingRuleConfigEntry entry : this.frEntries) {
                    if (!"@@Transparent@@".equals(entry.getRbForwardingRuleName())) continue;
                    transparentFR = new ComboItem((Object)entry.getRbForwardingRuleIdx(), entry.getRbForwardingRuleName());
                    this.panel.getComboForwardingRule().addItem(transparentFR);
                }
            }
            this.panel.getComboForwardingRule().setSelectedItem(transparentFR);
            this.panel.getComboForwardingRule().setEnabled(false);
        } else {
            ComboItem transparentFR = ComboItem.findItemByText((JComboBox)this.panel.getComboForwardingRule(), (String)"@@Transparent@@");
            if (transparentFR != null) {
                this.panel.getComboForwardingRule().removeItem(transparentFR);
            }
            this.panel.getSpnrVPLId().setEnabled(true);
            FormUtil.setSelectedValue((JComboBox)this.panel.getComboVLANTransparencyMode(), (Object)2);
            this.panel.getComboForwardingRule().setEnabled(true);
        }
        this.controlVPLIdSpnr();
    }

    public void controlVLANTransparencyModeCombo() {
        if (Integer.valueOf(1).equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboVLANTransparencyMode()))) {
            this.panel.getSpnrVPLId().setValue(4096);
            this.panel.getSpnrVPLId().setEnabled(false);
            this.panel.getCkbxNoneVPLId().setEnabled(false);
            ComboItem transparentFR = ComboItem.findItemByText((JComboBox)this.panel.getComboForwardingRule(), (String)"@@Transparent@@");
            if (transparentFR == null) {
                for (RbForwardingRuleConfigEntry entry : this.frEntries) {
                    if (!"@@Transparent@@".equals(entry.getRbForwardingRuleName())) continue;
                    transparentFR = new ComboItem((Object)entry.getRbForwardingRuleIdx(), entry.getRbForwardingRuleName());
                    this.panel.getComboForwardingRule().addItem(transparentFR);
                }
            }
            this.panel.getComboForwardingRule().setSelectedItem(transparentFR);
            this.panel.getComboForwardingRule().setEnabled(false);
        } else {
            this.panel.getComboForwardingRule().setEnabled(true);
            ComboItem transparentFR = ComboItem.findItemByText((JComboBox)this.panel.getComboForwardingRule(), (String)"@@Transparent@@");
            if (transparentFR != null) {
                this.panel.getComboForwardingRule().removeItem(transparentFR);
            }
            if (!this.panel.getCkbxNoneVPLId().isEnabled()) {
                this.panel.getCkbxNoneVPLId().setEnabled(true);
                this.panel.getCkbxNoneVPLId().setSelected(true);
                this.controlVPLIdCkbx();
            }
        }
    }

    public void controlVPLIdSpnr() {
        if ((Integer)this.panel.getSpnrVPLId().getValue() == 4095) {
            this.panel.getSpnrVPLId().setEnabled(false);
            this.panel.getCkbxNoneVPLId().setSelected(true);
        } else if ((Integer)this.panel.getSpnrVPLId().getValue() == 4096) {
            this.panel.getSpnrVPLId().setEnabled(false);
            this.panel.getCkbxNoneVPLId().setSelected(false);
            FormUtil.setSelectedValue((JComboBox)this.panel.getComboVLANTransparencyMode(), (Object)1);
            this.controlVLANTransparencyModeCombo();
        } else {
            this.panel.getSpnrVPLId().setEnabled(true);
            this.panel.getCkbxNoneVPLId().setEnabled(true);
            this.panel.getCkbxNoneVPLId().setSelected(false);
        }
    }

    public void controlVPLIdCkbx() {
        if (this.panel.getCkbxNoneVPLId().isSelected()) {
            this.panel.getSpnrVPLId().setValue(4095);
            this.panel.getSpnrVPLId().setEnabled(false);
        } else {
            if ((Integer)this.panel.getSpnrVPLId().getValue() > 4094) {
                this.panel.getSpnrVPLId().setValue(0);
            }
            this.panel.getSpnrVPLId().setEnabled(true);
        }
    }

    public void controlType() {
        Integer comboTypeValue;
        if (this.frEntries != null) {
            this.setForwardingRules();
        }
        if ((comboTypeValue = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getComboType())) == null) {
            return;
        }
        switch (comboTypeValue) {
            case 1: {
                this.panel.getComboVoiceDomainName().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setEnabled(false);
                this.panel.getComboServiceGroup().setSelectedIndex(-1);
                this.panel.getComboServiceGroup().setEnabled(false);
                this.panel.getComboPriorityClassifier().setSelectedIndex(this.panel.getComboPriorityClassifier().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboPriorityClassifier().setEnabled(true);
                this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(true);
                this.addDSCP();
                break;
            }
            case 2: {
                this.panel.getComboVoiceDomainName().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setEnabled(false);
                this.panel.getComboServiceGroup().setSelectedIndex(-1);
                this.panel.getComboServiceGroup().setEnabled(false);
                this.panel.getComboPriorityClassifier().setSelectedIndex(this.panel.getComboPriorityClassifier().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboPriorityClassifier().setEnabled(true);
                this.panel.getSpnrNoOfSimultaneousCalls().setValue(0);
                this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(false);
                this.removeDSCP();
                break;
            }
            case 3: {
                this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(true);
                this.panel.getComboPriorityClassifier().setEnabled(false);
                this.panel.getComboPriorityClassifier().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setEnabled(false);
                this.addDSCP();
                break;
            }
            case 4: {
                this.panel.getComboPriorityClassifier().setSelectedIndex(this.panel.getComboPriorityClassifier().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboPriorityClassifier().setEnabled(true);
                this.panel.getComboVoiceDomainName().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setEnabled(false);
                this.panel.getComboServiceGroup().setSelectedIndex(this.panel.getComboServiceGroup().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboServiceGroup().setEnabled(true);
                this.panel.getPnlForwardingRule().setVisible(false);
                this.panel.getPnlNoVoiceCalls().setVisible(false);
                break;
            }
            case 5: {
                this.panel.getComboPriorityClassifier().setSelectedIndex(this.panel.getComboPriorityClassifier().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboPriorityClassifier().setEnabled(true);
                this.panel.getComboServiceGroup().setSelectedIndex(-1);
                this.panel.getComboServiceGroup().setEnabled(false);
                this.panel.getComboVoiceDomainName().setSelectedIndex(-1);
                this.panel.getComboVoiceDomainName().setEnabled(false);
                this.panel.getPnlForwardingRule().setVisible(false);
                this.panel.getPnlNoVoiceCalls().setVisible(false);
                break;
            }
            case 6: {
                this.panel.getComboVoiceDomainName().setEnabled(true);
                this.panel.getComboVoiceDomainName().setSelectedIndex(this.panel.getComboVoiceDomainName().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboServiceGroup().setSelectedIndex(-1);
                this.panel.getComboServiceGroup().setEnabled(false);
                this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(true);
                this.panel.getComboPriorityClassifier().setSelectedIndex(this.panel.getComboPriorityClassifier().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboPriorityClassifier().setEnabled(true);
                this.addDSCP();
                break;
            }
            case 7: {
                this.panel.getComboVoiceDomainName().setEnabled(true);
                this.panel.getComboVoiceDomainName().setSelectedIndex(this.panel.getComboVoiceDomainName().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboServiceGroup().setSelectedIndex(-1);
                this.panel.getComboServiceGroup().setEnabled(false);
                this.panel.getPnlForwardingRule().setVisible(false);
                this.panel.getPnlNoVoiceCalls().setVisible(true);
                this.panel.getComboPriorityClassifier().setSelectedIndex(this.panel.getComboPriorityClassifier().getItemCount() == 0 ? -1 : 0);
                this.panel.getComboPriorityClassifier().setEnabled(true);
                this.addDSCP();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type for RbServiceTemplateConfigEntry");
            }
        }
        this.controlVLANTransparencyModeCombo();
        this.panel.getSpnrNoOfSimultaneousCalls().setValue(0);
    }

    private void addDSCP() {
        ComboItem transparentFR;
        if (this.initCompleted && (transparentFR = ComboItem.findItemByValue((JComboBox)this.panel.getComboPriorityMarkingMode(), (Object)3)) == null) {
            this.panel.getComboPriorityMarkingMode().addItem(new ComboItem((Object)3, i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateQoSMarkingMode(3))));
        }
    }

    private void removeDSCP() {
        ComboItem transparentFR = ComboItem.findItemByValue((JComboBox)this.panel.getComboPriorityMarkingMode(), (Object)3);
        if (transparentFR != null) {
            this.panel.getComboPriorityMarkingMode().removeItem(transparentFR);
        }
    }

    public void setTypeEnabled(boolean typeEnabled) {
        this.panel.getComboType().setEnabled(typeEnabled);
    }

    public void setPolicyRules(List<RbPolicyRuleConfigEntry> entries) {
        this.panel.getComboPriorityClassifier().removeAllItems();
        for (RbPolicyRuleConfigEntry entry : entries) {
            this.panel.getComboPriorityClassifier().addItem(new ComboItem((Object)entry.getRbPolicyRuleIdx(), entry.getRbPolicyRuleName()));
        }
    }

    public void setForwardingRules(List<RbForwardingRuleConfigEntry> entries) {
        this.frEntries.clear();
        if (entries != null) {
            this.frEntries.addAll(entries);
        }
        this.setForwardingRules();
    }

    private void setForwardingRules() {
        this.panel.getComboForwardingRule().removeAllItems();
        Integer comboType = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getComboType());
        if (this.frEntries != null && comboType != null) {
            int type = comboType;
            if (type == 1) {
                type = 3;
            }
            if (type == 7) {
                type = 5;
            }
            for (RbForwardingRuleConfigEntry entry : this.frEntries) {
                int frType = entry.getRbForwardingRuleType();
                if (frType == 1) {
                    frType = 3;
                }
                if (frType != type || entry.getRbForwardingRuleName().equals("@@Transparent@@")) continue;
                this.panel.getComboForwardingRule().addItem(new ComboItem((Object)entry.getRbForwardingRuleIdx(), String.format("%s (%s)", entry.getRbForwardingRuleName(), i18n2.translateString(RbForwardingRuleConfigEntry.toStringRbForwardingRuleType(entry.getRbForwardingRuleType())))));
            }
        }
    }

    public void setVPLDomains(List<RbVoiceDomainsEntry> entries) {
        this.vplDomainEntries.clear();
        if (entries != null) {
            this.vplDomainEntries.addAll(entries);
        }
        this.panel.getComboVoiceDomainName().removeAllItems();
        for (RbVoiceDomainsEntry entry : this.vplDomainEntries) {
            this.panel.getComboVoiceDomainName().addItem(new ComboItem((Object)entry.getRbVoiceDomainIdx(), entry.getRbVoiceDomainName()));
        }
    }

    public void setServiceGroup(List<RbServiceGroupEntry> entries) {
        this.serviceGroupEntries.clear();
        if (entries != null) {
            this.serviceGroupEntries.addAll(entries);
        }
        this.panel.getComboServiceGroup().removeAllItems();
        for (RbServiceGroupEntry entry : this.serviceGroupEntries) {
            this.panel.getComboServiceGroup().addItem(new ComboItem((Object)entry.getRbServiceGroupIndex(), entry.getRbServiceGroupName()));
        }
    }

    public boolean isInitCompleted() {
        return this.initCompleted;
    }

    public void setInitCompleted(boolean initCompleted) {
        this.initCompleted = initCompleted;
    }
}

