/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbServiceGroupConfigEntryEditorView;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.PlatformConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceGroupConfigForm
extends RbComplexObjectTableConfigForm<RbServiceGroupEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceGroupConfigForm.class);
    private UnifiedMOSupport<RbServiceGroupEntry> table;
    private List<Object> mos;
    private RbServiceGroupConfigEntryEditorView view;
    private SimpleRowTable simpleRowTable;

    @Override
    protected EditorView<RbServiceGroupEntry> getEditorView() {
        this.view = new RbServiceGroupConfigEntryEditorView();
        return this.view;
    }

    protected void fillUI(List<Object> managedObjects) {
        String rowKey;
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(0);
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        ArrayList<RbServiceGroupEntry> entries = new ArrayList<RbServiceGroupEntry>();
        for (RbServiceGroupEntry sgEntry : this.table.getInstances()) {
            entries.add(sgEntry);
        }
        Collections.sort(entries, new Comparator<RbServiceGroupEntry>(){

            @Override
            public int compare(RbServiceGroupEntry o1, RbServiceGroupEntry o2) {
                return o1.getRbServiceGroupIndex().compareTo(o2.getRbServiceGroupIndex());
            }
        });
        for (RbServiceGroupEntry entry : entries) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbServiceGroupIndex(), row, 0);
            this.tableModel.setInitialValueAt((Object)entry.getRbServiceGroupName(), row, 1);
            ++row;
        }
        this.tableModel.sort();
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbServiceGroupEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("serviceGroupId"));
        }
        if (rowKey != null) {
            int i;
            for (i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                break;
            }
            if (i == row) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Id"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    }

    @Override
    protected RbServiceGroupEntry getEntityForRow(int row) {
        return (RbServiceGroupEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbServiceGroupEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceTemplateConfigEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbServiceGroupEntry getNewEntity() {
        RbServiceGroupEntry newEntry = new RbServiceGroupEntry();
        newEntry.setRbServiceGroupIndex(10L);
        if (this.table == null) {
            return newEntry;
        }
        for (long i = 1L; i < 11L; ++i) {
            if (this.table.findInstance(String.valueOf(i)) != null) continue;
            newEntry.setRbServiceGroupIndex(i);
            return newEntry;
        }
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbServiceGroupEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canAdd() {
        return this.tableModel.getRowCount() < 10;
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbServiceGroupEntry e) {
        if (e.getRbServiceGroupName() == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("ServiceNameNotNull"), JComboBox.class, "ServiceGroupName", (Object)e.getRbServiceGroupName(), (Object)this.view.getUI().getServiceGroupNameTxt()));
            return false;
        }
        if (this.table != null) {
            for (RbServiceGroupEntry entry : this.table.getInstances()) {
                if (e == entry) continue;
                if (e.getRbServiceGroupName().equals(entry.getRbServiceGroupName()) && e.getId() != entry.getId()) {
                    invalidValues.add(new InvalidValue(i18n.translateString("serviceGroupNotUnique", new Object[]{entry.getRbServiceGroupName()}), JTextField.class, i18n.translateString("ServiceGroup"), (Object)e.getRbServiceGroupName(), (Object)this.view.getUI().getServiceGroupNameTxt()));
                    return false;
                }
                if (!e.getRbServiceGroupIspDomainName().equals(entry.getRbServiceGroupIspDomainName()) || e.getId() == entry.getId()) continue;
                invalidValues.add(new InvalidValue(i18n.translateString("ispDomainNameNotUnique", new Object[]{entry.getRbServiceGroupIspDomainName()}), JTextField.class, i18n.translateString("ispDomainName"), (Object)e.getRbServiceGroupIspDomainName(), (Object)this.view.getUI().getIspDomainNameTxt()));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbServiceGroupEntry entry) {
        return this.checkServiceTemplate(invalidValues, entry);
    }

    private boolean checkServiceTemplate(List<InvalidValue> invalidValues, RbServiceGroupEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(1);
        for (RbServiceTemplateConfigEntry entry : table.getInstances()) {
            if (!e.getRbServiceGroupName().equals(entry.getRbServiceTemplateGroupName())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("SGusedSP", new Object[]{e.getRbServiceGroupName(), entry.getRbServiceTemplateName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.craft_bs_tdd_service_group";
        }
        return "ngnms.rb.help.bs_tdd_service_group";
    }
}

