/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.services.RbServiceGroupConfigEntryPanel;
import com.bwanms.rb.gui.configuration.services.RbServiceGroupConfigEntryPanelController;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.validation.IPv4Validator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceGroupConfigEntryEditorView
extends AbstractBindedEditorView<RbServiceGroupEntry> {
    private static final int MAX_STRING_LENGTH = 32;
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceGroupConfigEntryEditorView.class);
    private RbServiceGroupConfigEntryPanel panel = new RbServiceGroupConfigEntryPanel();
    private final int comboAdaptor = 1;
    private RbServiceGroupConfigEntryPanelController controller = new RbServiceGroupConfigEntryPanelController(this.panel);

    public RbServiceGroupConfigEntryEditorView() {
        JComboBox typeCmb = this.panel.getTypeCmb();
        typeCmb.addItem(new ComboItem((Object)0, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupType(1))));
        typeCmb.addItem(new ComboItem((Object)1, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupType(2))));
        typeCmb.addItem(new ComboItem((Object)2, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupType(3))));
        JComboBox nomadicityCmb = this.panel.getNomadicityCmb();
        nomadicityCmb.addItem(new ComboItem((Object)0, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupNomadicity(1))));
        nomadicityCmb.addItem(new ComboItem((Object)1, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupNomadicity(2))));
        JComboBox relayCmb = this.panel.getRelayCmb();
        relayCmb.addItem(new ComboItem((Object)0, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupRelayMode(1))));
        relayCmb.addItem(new ComboItem((Object)2, i18n.translateString(RbServiceGroupEntry.toStringRbServiceGroupRelayMode(2))));
        this.panel.getTypeCmb().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbServiceGroupConfigEntryEditorView.this.controller.manageType();
            }
        });
        this.panel.getRelayCmb().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbServiceGroupConfigEntryEditorView.this.controller.manageRelayMode();
            }
        });
    }

    public List<InvalidValue> configureEntity(RbServiceGroupEntry entity) {
        ArrayList<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
        if (this.panel.getServiceGroupNameTxt().getText().trim().equals("") || this.panel.getServiceGroupNameTxt().getText().length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("servicegroupNameMandatory"), JTextField.class, i18n.translateString("groupName"), (Object)this.panel.getServiceGroupNameTxt().getText(), (Object)this.panel.getServiceGroupNameTxt()));
        } else {
            entity.setRbServiceGroupName(this.panel.getServiceGroupNameTxt().getText().trim());
        }
        if (this.panel.getIspDomainNameTxt().getText().length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("ispDomainNameMandatory"), JTextField.class, i18n.translateString("ispDomainName"), (Object)this.panel.getIspDomainNameTxt().getText(), (Object)this.panel.getIspDomainNameTxt()));
        } else {
            entity.setRbServiceGroupIspDomainName(this.panel.getIspDomainNameTxt().getText().trim());
        }
        entity.setRbServiceGroupIspDomainName(this.panel.getIspDomainNameTxt().getText().trim());
        entity.setRbServiceGroupNomadicity(this.panel.getNomadicityCmb().getSelectedIndex() + 1);
        entity.setRbServiceGroupType(this.panel.getTypeCmb().getSelectedIndex() + 1);
        entity.setRbServiceGroupRelayMode(this.panel.getRelayCmb().getSelectedIndex() + 1);
        if (this.panel.getTypeCmb().getSelectedIndex() == 1 && this.panel.getRelayCmb().getSelectedIndex() == 0) {
            Integer ispVLANId;
            if (this.panel.getGiIPTxt().getText().trim().equals("")) {
                invalidValues.add(new InvalidValue(i18n.translateString("giIPMandatory"), JTextField.class, i18n.translateString("giIP"), (Object)this.panel.getGiIPTxt().getText(), (Object)this.panel.getGiIPTxt()));
            } else if (!IPv4Validator.isValidIp((String)this.panel.getGiIPTxt().getText().trim())) {
                invalidValues.add(new InvalidValue(i18n.translateString("giIPNotValid"), JTextField.class, i18n.translateString("giIP"), (Object)this.panel.getGiIPTxt().getText(), (Object)this.panel.getGiIPTxt()));
            } else {
                entity.setRbServiceGroupGiIpAddress(this.panel.getGiIPTxt().getText().trim());
            }
            if (this.panel.getGiSubnetTxt().getText().trim().equals("")) {
                invalidValues.add(new InvalidValue(i18n.translateString("giSubnetMandatory"), JTextField.class, i18n.translateString("giSubnet"), (Object)this.panel.getGiSubnetTxt().getText(), (Object)this.panel.getGiSubnetTxt()));
            } else if (!IPv4Validator.isValidHostMask((String)this.panel.getGiSubnetTxt().getText().trim())) {
                invalidValues.add(new InvalidValue(i18n.translateString("giSubnetNotValid"), JTextField.class, i18n.translateString("giSubnet"), (Object)this.panel.getGiSubnetTxt().getText(), (Object)this.panel.getGiSubnetTxt()));
            } else {
                entity.setRbServiceGroupGiSubnetMask(this.panel.getGiSubnetTxt().getText());
            }
            if (this.panel.getDhcpServerIpTxt().getText().trim().equals("")) {
                invalidValues.add(new InvalidValue(i18n.translateString("dhcpServerIpMandatory"), JTextField.class, i18n.translateString("dhcpServerIp"), (Object)this.panel.getDhcpServerIpTxt().getText(), (Object)this.panel.getDhcpServerIpTxt()));
            } else if (!IPv4Validator.isValidIp((String)this.panel.getDhcpServerIpTxt().getText().trim())) {
                invalidValues.add(new InvalidValue(i18n.translateString("dhcpServerIpNotValid"), JTextField.class, i18n.translateString("dhcpServerIp"), (Object)this.panel.getDhcpServerIpTxt().getText(), (Object)this.panel.getDhcpServerIpTxt()));
            } else {
                entity.setRbServiceGroupDhcpServerIp(this.panel.getDhcpServerIpTxt().getText().trim());
            }
            if (this.panel.getGiIPTxt().getText().trim().equals(this.panel.getDhcpServerIpTxt().getText().trim())) {
                invalidValues.add(new InvalidValue(i18n.translateString("shouldNotBeTheSame"), JTextField.class, i18n.translateString("dhcpServerIp"), (Object)this.panel.getDhcpServerIpTxt().getText(), (Object)this.panel.getDhcpServerIpTxt()));
            }
            if ((ispVLANId = (Integer)this.panel.getVlanIDSpn().getValue()) < 0 || ispVLANId > 4095) {
                invalidValues.add(new InvalidValue(i18n.translateString("ispDomainVLANIdRange"), JSpinner.class, i18n.translateString("VLANID"), (Object)this.panel.getVlanIDSpn().getValue().toString(), (Object)this.panel.getVlanIDSpn()));
            } else {
                entity.setRbServiceGroupVlanId(ispVLANId);
            }
            String gateway = this.panel.getGatewayTxt().getText().trim();
            if (gateway.equals("")) {
                gateway = "0.0.0.0";
            }
            if (!gateway.equals("0.0.0.0")) {
                if (!IPv4Validator.isValidIp((String)this.panel.getGatewayTxt().getText().trim())) {
                    invalidValues.add(new InvalidValue(i18n.translateString("gatewayNotValid"), JTextField.class, i18n.translateString("gateway"), (Object)this.panel.getGatewayTxt().getText(), (Object)this.panel.getGatewayTxt()));
                } else {
                    entity.setRbServiceGroupGateway(gateway);
                }
            } else {
                try {
                    IpAddress giIP = new IpAddress(this.panel.getGiIPTxt().getText().trim());
                    IpAddress giSubnet = new IpAddress(this.panel.getGiSubnetTxt().getText().trim());
                    IpAddress dhcpIP = new IpAddress(this.panel.getDhcpServerIpTxt().getText().trim());
                    IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)giIP, (IpAddress)giSubnet);
                    if (!subnetRange.contains(dhcpIP)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("dhcpServerIpNotInRange"), JTextField.class, i18n.translateString("dhcpServerIp"), (Object)this.panel.getDhcpServerIpTxt().getText(), (Object)this.panel.getDhcpServerIpTxt()));
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return invalidValues;
    }

    public void fillUI(RbServiceGroupEntry entity) {
        int nomadicity = 1;
        int relayMode = 1;
        int type = 1;
        int vlanId = 4095;
        this.panel.getServiceGroupNameTxt().setText(entity.getRbServiceGroupName());
        if (entity.getRbServiceGroupIspDomainName() != null) {
            this.panel.getIspDomainNameTxt().setText(entity.getRbServiceGroupIspDomainName());
        } else {
            this.panel.getIspDomainNameTxt().setText("");
        }
        if (null != entity.getRbServiceGroupNomadicity()) {
            nomadicity = entity.getRbServiceGroupNomadicity();
        }
        if (null != entity.getRbServiceGroupRelayMode()) {
            relayMode = entity.getRbServiceGroupRelayMode();
            if (relayMode == 1) {
                this.panel.getGiIPTxt().setText(entity.getRbServiceGroupGiIpAddress());
                this.panel.getGiSubnetTxt().setText(entity.getRbServiceGroupGiSubnetMask());
                this.panel.getDhcpServerIpTxt().setText(entity.getRbServiceGroupDhcpServerIp());
                this.panel.getGatewayTxt().setText(entity.getRbServiceGroupGateway());
            } else {
                this.panel.getGiIPTxt().setText("");
                this.panel.getGiSubnetTxt().setText("");
                this.panel.getDhcpServerIpTxt().setText("");
                this.panel.getGatewayTxt().setText("");
            }
        } else {
            this.panel.getGiIPTxt().setText("");
            this.panel.getGiSubnetTxt().setText("");
            this.panel.getDhcpServerIpTxt().setText("");
            this.panel.getGatewayTxt().setText("");
        }
        if (null != entity.getRbServiceGroupType()) {
            type = entity.getRbServiceGroupType();
        }
        this.panel.getNomadicityCmb().setSelectedIndex(nomadicity - 1);
        this.panel.getTypeCmb().setSelectedIndex(type - 1);
        this.panel.getRelayCmb().setSelectedIndex(relayMode - 1);
        if (null != entity.getRbServiceGroupVlanId()) {
            vlanId = entity.getRbServiceGroupVlanId();
            this.panel.getVlanIDSpn().setValue(vlanId);
            this.updateFields(false);
        } else {
            this.panel.getVlanIDSpn().setValue(vlanId);
            this.updateFields(true);
        }
    }

    public RbServiceGroupConfigEntryPanel getUI() {
        return this.panel;
    }

    public String getTitle() {
        return "ServiceGroup";
    }

    public String getApplicationPermission() {
        return null;
    }

    public String getHelpTopic() {
        return "";
    }

    private void updateFields(boolean aFlag) {
        this.panel.getServiceGroupNameTxt().setEditable(aFlag);
        this.panel.getIspDomainNameTxt().setEditable(aFlag);
        this.panel.getRelayCmb().setEnabled(aFlag);
        this.panel.getNomadicityCmb().setEnabled(aFlag);
        this.panel.getTypeCmb().setEnabled(aFlag);
        this.panel.getGiSubnetTxt().setEditable(aFlag);
        this.panel.getGiIPTxt().setEditable(aFlag);
        this.panel.getDhcpServerIpTxt().setEditable(aFlag);
        this.panel.getVlanIDSpn().setEnabled(aFlag);
        this.panel.getGatewayTxt().setEditable(aFlag);
        this.panel.getCkbxNoneVLAN().setEnabled(aFlag);
    }
}

