/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.ReadOnlyBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.ddi.RbServiceDeploymentHelper;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorPanel;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSuServiceConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceConfigEntryEditorView
extends AbstractBindedEditorView<RbServiceConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceConfigEntryEditorView.class);
    private static final Logger log = Logger.getLogger(RbServiceConfigEntryEditorView.class);
    private RbServiceConfigEntryEditorPanel panel;
    private Binder binder;
    private Collection<RbServiceTemplateConfigEntry> serviceProfilesTable;
    private UnifiedMOSupport<RbServiceConfigEntry> servicesTable;
    RbBaseStationEquipment equipment;

    public RbServiceConfigEntryEditorView() {
        this(null);
    }

    public RbServiceConfigEntryEditorView(RbBaseStationEquipment equipment) {
        this.panel = new RbServiceConfigEntryEditorPanel(equipment);
        this.panel.getLblSuMACAddress().setText(i18n.translateString("SuNameMACAddress"));
        this.setEquipment(equipment);
    }

    public List<Binder> getBinders() {
        JComboBoxBinding serviceTypeBinding = new JComboBoxBinding(i18n, "comboServiceType", "rbServiceType", i18n.translateString("ServiceType"));
        serviceTypeBinding.setIgnoreDisabled(true);
        JComboBoxBinding serviceProfileBinding = new JComboBoxBinding(i18n, "comboServiceProfile", "rbServiceServiceTemplateIdx", i18n.translateString("ServiceProfile"));
        serviceProfileBinding.setIgnoreDisabled(true);
        JComboBoxBinding subscriberBinding = new JComboBoxBinding(i18n, "comboSubscriber", "rbSubscriberIdx", i18n.translateString("Subscriber"));
        subscriberBinding.setIgnoreDisabled(true);
        JComboBoxBinding vlanClassificationBinding = new JComboBoxBinding(i18n, "comboVLANClassificationMode", "rbServiceVLANClassificationMode", i18n.translateString("VLANClassificationMode"));
        vlanClassificationBinding.setIgnoreDisabled(true);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        this.binder = new DefaultBinder((Object)this.panel, (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceName", "rbServiceName", i18n.translateString("ServiceName"))).add((Binding)serviceTypeBinding).add((Binding)serviceProfileBinding).add((Binding)vlanClassificationBinding).add((Binding)new JComboBoxBinding(i18n, "comboAdministrativeState", "rbServiceAdminStatus", i18n.translateString("AdministrativeState"))).add((Binding)new JComboBoxBinding(i18n, "comboHybridMode", "rbServiceVLANHybridMode", i18n.translateString("HybridMode"))).add((Binding)subscriberBinding).add((Binding)new JSpinnerBinding("spnrAccessVLAN", "rbServiceAccessVLAN", i18n.translateString("AccessVLAN")));
        binders.add(this.binder);
        Binder roBinder = new ReadOnlyBinder((Object)this.panel, (Object)this.entity).add((ReadOnlyBinding)new JTextFieldBinding("txtVPLID", "rbSuServiceVPLID", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return beanValue == null ? "" : String.valueOf(beanValue);
            }
        }, i18n.translateString("VPLId")));
        binders.add(roBinder);
        return binders;
    }

    public void setEntity(RbServiceConfigEntry entity) {
        this.panel.controller.setEntityInitCompleted(false);
        super.setEntity((Serializable)((Object)entity));
        this.panel.controller.setEntityInitCompleted(true);
        this.panel.controller.checkHybridMode();
    }

    public void setEquipment(RbBaseStationEquipment equipment) {
        this.equipment = equipment;
        this.panel.getComboServiceType().removeAllItems();
        if (equipment != null) {
            if (equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
                this.panel.getPnlCPData().setVisible(true);
                this.panel.getPnlFixedNomadic().setVisible(true);
                this.panel.getPnlWiMax().setVisible(false);
                this.panel.getComboServiceType().addItem(new ComboItem((Object)1, RbServiceConfigEntry.toStringRbServiceType(1)));
                this.panel.getComboServiceType().addItem(new ComboItem((Object)2, RbServiceConfigEntry.toStringRbServiceType(2)));
                this.panel.getComboServiceType().addItem(new ComboItem((Object)3, RbServiceConfigEntry.toStringRbServiceType(3)));
                if (RbFeatures.isSipAwareAvailable(equipment)) {
                    this.panel.getComboServiceType().addItem(new ComboItem((Object)6, RbServiceConfigEntry.toStringRbServiceType(6)));
                }
            } else {
                this.panel.getPnlCPData().setVisible(false);
                this.panel.getPnlFixedNomadic().setVisible(false);
                this.panel.getPnlWiMax().setVisible(true);
                this.panel.getComboServiceType().addItem(new ComboItem((Object)4, RbServiceConfigEntry.toStringRbServiceType(4)));
                this.panel.getComboServiceType().addItem(new ComboItem((Object)5, RbServiceConfigEntry.toStringRbServiceType(5)));
                if (RbFeatures.isSipAwareAvailable(equipment)) {
                    this.panel.getComboServiceType().addItem(new ComboItem((Object)7, RbServiceConfigEntry.toStringRbServiceType(7)));
                }
            }
        }
        i18n.translateCombo(this.panel.getComboServiceType());
    }

    public void fillUI(RbServiceConfigEntry entity) {
        boolean newServ;
        if (!entity.isTemporary()) {
            this.setControlsEditable(true);
        }
        if (entity.getRbServiceSuMacAddress() != null) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getComboSuMACAddress(), (Object)MacAddress.fromOctetString((String)entity.getRbServiceSuMacAddress()));
        }
        boolean bl = newServ = entity.getId() == 0L;
        if (entity.getRbServiceAdminStatus() != null && entity.getRbServiceAdminStatus() == 1) {
            this.panel.getComboSuMACAddress().setEnabled(false);
            this.panel.getBtnSelectSU().setEnabled(false);
        } else {
            if (entity.getRbServiceSuMacAddress() != null) {
                this.panel.getController().setDefaultMACValue(entity.getRbServiceSuMacAddress());
            } else {
                this.panel.getController().setDefaultMACValue("");
            }
            if (!newServ) {
                this.panel.getComboSuMACAddress().setEnabled(null != this.equipment && VersionFactory.getInstance().createVersion(this.equipment.getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0")));
                this.panel.getBtnSelectSU().setEnabled(this.panel.getComboSuMACAddress().isEnabled());
            }
        }
        this.panel.getComboServiceType().setEnabled(newServ);
        this.panel.getComboSubscriber().setEnabled(newServ);
        if (!newServ) {
            this.panel.getTxtOperationalState().setText(i18n.translateString(RbSuServiceConfigEntry.toStringRbSuServiceOperStatus(entity.getRbServiceOperStatus())));
        } else {
            this.panel.getTxtOperationalState().setText("");
        }
        int[] vlanList = new int[16];
        if (entity.getId() > 0L && entity.getRbServiceClientSiteVLANListAsString() != null) {
            vlanList = RbServiceConfigEntryEditorView.getVLANListFromCommaSeparated(entity.getRbServiceClientSiteVLANListAsString());
        }
        SimpleRowTableModel model = this.panel.getTableModel();
        model.clearTable();
        FormUtil.cancelTableEditing((JTable)this.panel.getTable());
        int rowCount = 16;
        if (entity.getRbServiceVLANHybridMode() == null || entity.getRbServiceVLANHybridMode() == 1) {
            rowCount = 15;
        }
        for (int row = 0; row < rowCount; ++row) {
            model.addNewRow(null, true);
            model.setInitialValueAt((Object)(row + 1), row, 0);
            model.setRowState(row, 4);
            if (vlanList[row] == 0 || vlanList[row] == 4095) continue;
            model.setInitialValueAt((Object)String.valueOf(vlanList[row]), row, 1);
            model.setRowState(row, 0);
        }
        if (entity.getRbServiceVLANClassificationMode() == null || entity.getRbServiceAccessVLAN() == null) {
            this.panel.getSpnrAccessVLAN().setValue(4095);
        } else {
            this.panel.getSpnrAccessVLAN().setValue(entity.getRbServiceAccessVLAN());
            this.panel.getController().controlAccessVLANSpnr();
        }
        this.panel.getController().handleAccessVLAN();
        this.panel.getController().checkEnhancedMode();
        if (entity.isTemporary()) {
            this.setControlsEditable(false);
        }
    }

    public List<InvalidValue> configureEntity(RbServiceConfigEntry entity) {
        FormUtil.stopTableEditing((JTable)this.panel.getTable());
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        if (entity.isTemporary()) {
            return iValues;
        }
        MacAddress macAddress = (MacAddress)FormUtil.getSelectedValue((JComboBox)this.panel.getComboSuMACAddress());
        if (macAddress != null) {
            entity.setRbServiceSuMacAddress(macAddress.toOctetString());
        }
        entity.setRbServiceAccessVLAN((Integer)this.panel.getSpnrAccessVLAN().getValue());
        iValues.addAll(super.configureEntity((Serializable)((Object)entity)));
        String vlanList = this.getCommaSeparatedFromVLANList(entity, iValues);
        if (iValues.isEmpty()) {
            entity.setRbServiceClientSiteVLANListAsString(vlanList);
        }
        if (entity.getRbServiceAccessVLAN() != null) {
            if (entity.getRbServiceAccessVLAN() < 4095) {
                if (Integer.valueOf(2).equals(entity.getRbServiceVLANHybridMode()) && Integer.valueOf(0).equals(entity.getRbServiceClientSiteVLANListCount()) && Integer.valueOf(2).equals(entity.getRbServiceVLANClassificationMode())) {
                    iValues.add(new InvalidValue(i18n.translateString("MustDefineVLAN"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
                } else if (Integer.valueOf(2).equals(entity.getRbServiceVLANHybridMode()) && entity.getRbServiceClientSiteVLANListCount() != null && entity.getRbServiceClientSiteVLANListCount() > 0 && Integer.valueOf(2).equals(entity.getRbServiceVLANClassificationMode())) {
                    iValues.add(new InvalidValue(i18n.translateString("VLANListMustBeEmpty"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
                } else if (Integer.valueOf(1).equals(entity.getRbServiceVLANHybridMode()) && entity.getRbServiceClientSiteVLANListCount() != null && entity.getRbServiceClientSiteVLANListCount() > 1 && Integer.valueOf(2).equals(entity.getRbServiceVLANClassificationMode())) {
                    iValues.add(new InvalidValue(i18n.translateString("OnlyOneVLAN"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
                } else if (Integer.valueOf(2).equals(entity.getRbServiceVLANHybridMode()) && entity.getRbServiceClientSiteVLANListCount() != null && entity.getRbServiceClientSiteVLANListCount() > 0 && Integer.valueOf(1).equals(entity.getRbServiceVLANClassificationMode())) {
                    iValues.add(new InvalidValue(i18n.translateString("VLANListMustBeEmpty"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
                }
                if (this.panel.getController().checkVLANList(RbServiceConfigEntryEditorView.getVLANListFromCommaSeparated(vlanList), entity.getRbServiceAccessVLAN())) {
                    iValues.add(new InvalidValue(i18n.translateString("VLANAccessListMismatch"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
                }
            } else if (Integer.valueOf(2).equals(entity.getRbServiceVLANHybridMode()) && Integer.valueOf(0).equals(entity.getRbServiceClientSiteVLANListCount()) && Integer.valueOf(2).equals(entity.getRbServiceVLANClassificationMode())) {
                iValues.add(new InvalidValue(i18n.translateString("MustDefineVLAN"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
            } else if (Integer.valueOf(2).equals(entity.getRbServiceVLANHybridMode()) && entity.getRbServiceClientSiteVLANListCount() != null && entity.getRbServiceClientSiteVLANListCount() > 1 && Integer.valueOf(2).equals(entity.getRbServiceVLANClassificationMode())) {
                iValues.add(new InvalidValue(i18n.translateString("OnlyOneVLAN"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
            } else if (Integer.valueOf(1).equals(entity.getRbServiceVLANHybridMode()) && entity.getRbServiceClientSiteVLANListCount() != null && entity.getRbServiceClientSiteVLANListCount() > 1 && Integer.valueOf(2).equals(entity.getRbServiceVLANClassificationMode())) {
                iValues.add(new InvalidValue(i18n.translateString("OnlyOneVLAN"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
            }
            if (this.panel.getController().checkVPLId(entity.getRbServiceAccessVLAN(), RbServiceConfigEntryEditorView.getVLANListFromCommaSeparated(vlanList), this.panel.getController().isTransparent(), Integer.valueOf(1).equals(entity.getRbServiceVLANHybridMode()))) {
                iValues.add(new InvalidValue(i18n.translateString("VPLMismatch"), RbSuServiceConfigEntry.class, "", (Object)"", (Object)this));
            }
        }
        Iterator iterator = iValues.iterator();
        while (iterator.hasNext()) {
            InvalidValue value = (InvalidValue)iterator.next();
            if (!value.getPropertyName().equals("SU Name (MAC Address)")) continue;
            iterator.remove();
            iValues.add(new InvalidValue(i18n.translateString("serviceMACNotNull"), JComboBox.class, i18n.translateString("SuNameMACAddress"), this.panel.getComboSuMACAddress().getSelectedItem(), (Object)this.panel.getComboSuMACAddress()));
            break;
        }
        if (iValues.isEmpty()) {
            try {
                RbServiceDeploymentHelper.checkServiceDeployment(entity, this.servicesTable, this.serviceProfilesTable, RbFeatures.isSipAwareAvailable(this.equipment));
            }
            catch (ServiceManagementException e) {
                iValues.add(new InvalidValue(RbServiceDeploymentHelper.getServiceDeploymentI18n().translateString(e.getMessage()), RbSuServiceConfigEntry.class, "", (Object)"", (Object)entity));
            }
        }
        return iValues;
    }

    public static int[] getVLANListFromCommaSeparated(String commaSeparated) {
        String[] parts = commaSeparated.split(",");
        if (parts.length != 16 && parts.length != 15) {
            throw new RuntimeException("Invalid comma separated string: " + commaSeparated);
        }
        int[] vlanList = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                vlanList[i] = "".equals(parts[i]) ? 0 : Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return vlanList;
    }

    private String getCommaSeparatedFromVLANList(RbServiceConfigEntry entity, List<InvalidValue> values) {
        SimpleRowTableModel model = this.panel.getTableModel();
        StringBuffer buf = new StringBuffer();
        int counter = 0;
        HashSet<String> valuesSet = new HashSet<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getValueAt(i, 1) == null || model.getValueAt(i, 1).toString().equals("0") || model.getValueAt(i, 1).toString().equals("") || model.getRowState(i) == 1) continue;
            int value = 0;
            if (model.getValueAt(i, 1) instanceof Integer) {
                value = (Integer)model.getValueAt(i, 1);
            } else {
                try {
                    value = Integer.parseInt((String)model.getValueAt(i, 1));
                }
                catch (NumberFormatException nfe) {
                    values.add(new InvalidValue(i18n.translateString("invalidVLAN", new Object[]{String.valueOf(i + 1)}), RbSuServiceConfigEntry.class, "", model.getValueAt(i, 1), (Object)entity));
                }
            }
            if (value < 0 || value > 4094) {
                values.add(new InvalidValue(i18n.translateString("invalidVLAN", new Object[]{String.valueOf(i + 1)}), RbSuServiceConfigEntry.class, "", model.getValueAt(i, 1), (Object)entity));
            }
            if (valuesSet.contains(model.getValueAt(i, 1).toString())) {
                values.add(new InvalidValue(i18n.translateString("duplicateVLAN", new Object[]{String.valueOf(i + 1)}), RbSuServiceConfigEntry.class, "", model.getValueAt(i, 1), (Object)entity));
            } else {
                valuesSet.add(model.getValueAt(i, 1).toString());
                buf.append(model.getValueAt(i, 1).toString());
            }
            buf.append(",");
            ++counter;
        }
        if (Integer.valueOf(1).equals(entity.getRbServiceVLANHybridMode())) {
            buf.append("4095,");
            ++counter;
        }
        entity.setRbServiceClientSiteVLANListCount(counter);
        int rowCount = 16;
        if (counter < rowCount) {
            for (int i = counter; i < rowCount; ++i) {
                buf.append("0,");
            }
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public RbServiceConfigEntryEditorPanel getUI() {
        return this.panel;
    }

    public String getTitle() {
        return "Service";
    }

    public void setServiceProfiles(Collection<RbServiceTemplateConfigEntry> serviceProfilesTable) {
        this.serviceProfilesTable = serviceProfilesTable;
        this.panel.getController().setServiceTemplates(serviceProfilesTable);
        this.panel.getController().controlServiceProfile();
    }

    public void setSubscribers(Collection<RbSubscriberEntry> subscribers) {
        this.panel.getController().setSubscribers(subscribers);
    }

    public void setSubscriberUnits(Collection<RbRegisteredSuEntry> entries) {
        this.panel.getController().setSubscriberUnits(entries);
    }

    public void setServices(UnifiedMOSupport<RbServiceConfigEntry> table) {
        this.servicesTable = table;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureServices";
    }

    public void setPanel(RbServiceConfigEntryEditorPanel panel) {
        this.panel = panel;
    }

    public void setForwardingRules(Collection<RbForwardingRuleConfigEntry> entries) {
        this.panel.getController().setForwardingRules(entries);
    }

    public void setPolicyRules(Collection<RbPolicyRuleConfigEntry> entries) {
        this.panel.getController().setPolicyRules(entries);
    }

    public void setQoSProfiles(Collection<RbQoSProfileConfigEntry> entries) {
        this.panel.getController().setQoSProfiles(entries);
    }

    public void setVPLDomains(Collection<RbVoiceDomainsEntry> entries) {
        this.panel.getController().setVPLDomains(entries);
    }

    public void setServiceGroup(Collection<RbServiceGroupEntry> entries) {
        this.panel.getController().setServiceGroup(entries);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.service";
    }

    private void setControlsEditable(boolean b) {
        this.panel.getTxtServiceName().setEditable(b);
        this.panel.getComboServiceType().setEnabled(b);
        this.panel.getComboServiceProfile().setEnabled(b);
        this.panel.getComboSuMACAddress().setEnabled(b);
        this.panel.getBtnSelectSU().setEnabled(b);
        this.panel.getBtnAddMAC().setEnabled(b);
        this.panel.getComboSubscriber().setEnabled(b);
        this.panel.getComboHybridMode().setEnabled(b);
        this.panel.getComboVLANClassificationMode().setEnabled(b);
        this.panel.getCkbxAccessVLAN().setEnabled(b);
        this.panel.getComboAdministrativeState().setEnabled(b);
        this.panel.getSpnrAccessVLAN().setEnabled(b && !this.panel.getCkbxAccessVLAN().isSelected());
        this.panel.getBtnDelete().setEnabled(b);
        this.panel.getBtnRevert().setEnabled(b);
        this.panel.getTable().setEnabled(b);
        this.panel.getTxtVPLID().setEditable(b);
    }
}

