/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.translators.MACAddressTranslator;
import com.bwanms.rb.gui.configuration.services.NewMacDialog;
import com.bwanms.rb.gui.configuration.services.NewNameMacDialog;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorPanel;
import com.bwanms.rb.gui.configuration.services.preview.ServiceProfilePreviewContainer;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceConfigEntryEditorPanelController
extends SimpleRowTableModelPanelController {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorPanel.class);
    private RbServiceConfigEntryEditorPanel panel;
    private Collection<RbServiceTemplateConfigEntry> serviceTemplates;
    private boolean initCompleted = false;
    private boolean entityInitCompleted = false;
    private String defaultMACVAlue;
    private boolean enhancedMode;
    private Collection<RbForwardingRuleConfigEntry> forwardingRules;
    private Collection<RbPolicyRuleConfigEntry> policyRules;
    private Collection<RbQoSProfileConfigEntry> qosProfiles;
    private Collection<RbVoiceDomainsEntry> vplDomains;
    private Collection<RbServiceGroupEntry> serviceGroup;
    private RbBaseStationEquipment equipment;
    private boolean isTDD = false;

    public RbServiceConfigEntryEditorPanelController(RbServiceConfigEntryEditorPanel panel, RbBaseStationEquipment equipment) {
        this.panel = panel;
        this.equipment = equipment;
        this.isTDD = equipment != null && equipment.getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.0"));
    }

    protected SimpleRowTableModel getTableModel() {
        return this.panel.getTableModel();
    }

    protected JTable getTable() {
        return this.panel.getTable();
    }

    protected JButton getDeleteButton() {
        return this.panel.getBtnDelete();
    }

    protected JButton getRevertButton() {
        return this.panel.getBtnRevert();
    }

    public void checkHybridMode() {
        if (this.initCompleted && this.entityInitCompleted) {
            if (Integer.valueOf(2).equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboHybridMode()))) {
                SimpleRowTableModel model = this.panel.getTableModel();
                int row = model.getRowCount();
                if (row == 15) {
                    model.addNewRow(null, true);
                    model.setInitialValueAt((Object)(row + 1), row, 0);
                    model.setRowState(row, 4);
                }
            } else {
                SimpleRowTableModel model = this.panel.getTableModel();
                int row = model.getRowCount();
                if (row == 16) {
                    if (model.getValueAt(row - 1, 1) == null || FrameUtil.showConfirmation((Component)this.panel, (String)i18n.translateString("DiscardLastVLAN"))) {
                        model.removeRow(row - 1);
                    } else {
                        FormUtil.setSelectedValue((JComboBox)this.panel.getComboHybridMode(), (Object)2);
                    }
                }
            }
        }
    }

    public void controlServiceProfile() {
        if (this.initCompleted && this.serviceTemplates != null) {
            this.panel.getComboServiceProfile().removeAllItems();
            for (RbServiceTemplateConfigEntry serviceProfile : this.serviceTemplates) {
                if (!serviceProfile.getRbServiceTemplateType().equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboServiceType()))) continue;
                this.panel.getComboServiceProfile().addItem(new ComboItem((Object)serviceProfile.getRbServiceTemplateIdx(), serviceProfile.getRbServiceTemplateName()));
            }
        }
    }

    public void setInitCompleted(boolean b) {
        this.initCompleted = b;
    }

    public void setDefaultMACValue(String string) {
        this.defaultMACVAlue = string;
    }

    public void controlAdminState() {
        if (this.initCompleted) {
            // empty if block
        }
    }

    public void controlVLANClassificationMode() {
        if (this.initCompleted) {
            // empty if block
        }
    }

    public void controlAccessVLANckbx() {
        if (this.initCompleted) {
            if (this.panel.getCkbxAccessVLAN().isSelected()) {
                this.panel.getSpnrAccessVLAN().setValue(4095);
                this.panel.getSpnrAccessVLAN().setEnabled(false);
            } else {
                if ((Integer)this.panel.getSpnrAccessVLAN().getValue() == 4095) {
                    this.panel.getSpnrAccessVLAN().setValue(1);
                }
                this.panel.getSpnrAccessVLAN().setEnabled(true);
            }
        }
    }

    public void controlAccessVLANSpnr() {
        if (this.initCompleted) {
            if ((Integer)this.panel.getSpnrAccessVLAN().getValue() == 4095) {
                this.panel.getSpnrAccessVLAN().setEnabled(false);
                this.panel.getCkbxAccessVLAN().setSelected(true);
            } else {
                this.panel.getSpnrAccessVLAN().setEnabled(true);
                this.panel.getCkbxAccessVLAN().setSelected(false);
            }
        }
    }

    public void checkVLANClassificationMode() {
        if (this.initCompleted) {
            // empty if block
        }
    }

    public void handleAccessVLAN() {
        if (this.initCompleted) {
            // empty if block
        }
    }

    public boolean isTransparent() {
        if (this.initCompleted) {
            for (RbServiceTemplateConfigEntry serviceProfile : this.serviceTemplates) {
                if (!serviceProfile.getRbServiceTemplateIdx().equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboServiceProfile())) || serviceProfile.getRbServiceTemplateVLANTransparencyMode() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkVPLId(Integer vlanId, int[] vlanList, boolean transparent, boolean hybrid) {
        if (this.initCompleted) {
            for (RbServiceTemplateConfigEntry serviceProfile : this.serviceTemplates) {
                if (!transparent && serviceProfile.getRbServiceTemplateBaseVLAN().equals(4095) || transparent && serviceProfile.getRbServiceTemplateBaseVLAN().equals(4095) && (!hybrid && vlanId == 4095 || hybrid && vlanId != 4095) || !serviceProfile.getRbServiceTemplateBaseVLAN().equals(vlanId) && (!transparent || !this.checkVLANList(vlanList, serviceProfile.getRbServiceTemplateBaseVLAN()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkVLANList(int[] vlanList, Integer rbServiceTemplateBaseVLAN) {
        for (int i : vlanList) {
            if (i == 0 || i != rbServiceTemplateBaseVLAN) continue;
            return true;
        }
        return false;
    }

    public void addMAC() {
        JDialog dialog;
        String value = null;
        String name = "";
        if (this.isTDD) {
            dialog = new NewNameMacDialog((JFrame)SwingUtilities.getWindowAncestor(this.panel));
            dialog.setModal(true);
            dialog.setTitle(i18n.translateString("MACAddressTitle"));
            dialog.setLocationRelativeTo(dialog.getParent());
            dialog.pack();
            dialog.setVisible(true);
            value = ((NewNameMacDialog)dialog).getValue();
            name = ((NewNameMacDialog)dialog).getName();
        } else {
            dialog = new NewMacDialog((JFrame)SwingUtilities.getWindowAncestor(this.panel));
            dialog.setModal(true);
            dialog.setTitle(i18n.translateString("MACAddressTitle"));
            dialog.setLocationRelativeTo(dialog.getParent());
            dialog.pack();
            dialog.setVisible(true);
            value = ((NewMacDialog)dialog).getValue();
        }
        if (value != null) {
            try {
                new MACAddressTranslator().convertToBeanValue((Object)value);
                if (value.equals("00-00-00-00-00-00".trim())) {
                    FrameUtil.showError((Component)this.panel, (String)i18n.translateString("InvalidMACAddress"), null);
                    return;
                }
                int firstBit = Integer.parseInt(value.substring(0, 1), 16);
                if (firstBit > 7) {
                    FrameUtil.showError((Component)this.panel, (String)i18n.translateString("InvalidMACAddress"), null);
                    return;
                }
            }
            catch (Exception e) {
                FrameUtil.showError((Component)this.panel, (String)i18n.translateString("InvalidMACAddress"), null);
                return;
            }
            MacAddress mac = MacAddress.fromDashedString((String)value);
            if (FormUtil.setSelectedValue((JComboBox)this.panel.getComboSuMACAddress(), (Object)mac) < 0) {
                StringBuffer text = new StringBuffer();
                if (this.isTDD) {
                    text.append(name).append(" (");
                }
                text.append(value.toUpperCase());
                if (this.isTDD) {
                    text.append(")");
                }
                this.panel.getComboSuMACAddress().addItem(new ComboItem((Object)mac, text.toString()));
                this.panel.getComboSuMACAddress().setSelectedIndex(this.panel.getComboSuMACAddress().getItemCount() - 1);
            }
        }
    }

    public void setMACEnhancedMode(boolean enable) {
        if (enable) {
            this.panel.getComboSuMACAddress().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RbServiceConfigEntryEditorPanelController.this.checkEnhancedMode();
                }
            });
        }
        this.enhancedMode = enable;
    }

    public void checkEnhancedMode() {
        if (this.enhancedMode) {
            this.panel.getBtnAddMAC().setVisible(this.panel.getComboSuMACAddress().isEnabled());
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    public void setSubscribers(Collection<RbSubscriberEntry> subscribers) {
        this.panel.getComboSubscriber().removeAllItems();
        for (RbSubscriberEntry subscriber : subscribers) {
            this.panel.getComboSubscriber().addItem(new ComboItem((Object)subscriber.getRbSubscriberIdx(), subscriber.getRbSubscriberID()));
        }
    }

    public void setSubscriberUnits(Collection<RbRegisteredSuEntry> entries) {
        MacAddress selectedMac = (MacAddress)FormUtil.getSelectedValue((JComboBox)this.panel.getComboSuMACAddress());
        this.panel.getComboSuMACAddress().removeAllItems();
        for (RbRegisteredSuEntry sUnit : entries) {
            MacAddress mac = MacAddress.fromOctetString((String)sUnit.getRbSuMacAddr());
            StringBuffer text = new StringBuffer();
            if (this.isTDD) {
                text.append(sUnit.getRbSuSysName()).append(" (");
            }
            text.append(mac);
            if (this.isTDD) {
                text.append(")");
            }
            if (sUnit.getRbSuPersistence() == 1) {
                text.append(" (T)");
            }
            this.panel.getComboSuMACAddress().addItem(new ComboItem((Object)mac, text.toString()));
        }
        if (selectedMac != null) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getComboSuMACAddress(), (Object)selectedMac);
        }
    }

    public void setServiceTemplates(Collection<RbServiceTemplateConfigEntry> serviceTemplates) {
        this.serviceTemplates = serviceTemplates;
    }

    public void setForwardingRules(Collection<RbForwardingRuleConfigEntry> entries) {
        this.forwardingRules = entries;
    }

    public void setPolicyRules(Collection<RbPolicyRuleConfigEntry> entries) {
        this.policyRules = entries;
    }

    public void setQoSProfiles(Collection<RbQoSProfileConfigEntry> entries) {
        this.qosProfiles = entries;
    }

    public void setVPLDomains(Collection<RbVoiceDomainsEntry> entries) {
        this.vplDomains = entries;
    }

    public void setServiceGroup(Collection<RbServiceGroupEntry> entries) {
        this.serviceGroup = entries;
    }

    public void previewSP() {
        RbServiceTemplateConfigEntry selectedSP = this.getSelectedSP();
        if (selectedSP != null) {
            new ServiceProfilePreviewContainer(selectedSP, this.equipment, this.forwardingRules, this.policyRules, this.qosProfiles, this.vplDomains, this.serviceGroup);
        }
    }

    private RbServiceTemplateConfigEntry getSelectedSP() {
        for (RbServiceTemplateConfigEntry serviceProfile : this.serviceTemplates) {
            if (!serviceProfile.getRbServiceTemplateIdx().equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboServiceProfile()))) continue;
            return serviceProfile;
        }
        return null;
    }

    public void setEntityInitCompleted(boolean entityInitCompleted) {
        this.entityInitCompleted = entityInitCompleted;
    }
}

