/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbQoSProfileConfigEntryEditorView;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbQoSProfilesConfigForm
extends RbComplexObjectTableConfigForm<RbQoSProfileConfigEntry> {
    private UnifiedMOSupport<RbQoSProfileConfigEntry> table;
    private List<Object> mos;
    private static final Internationalizer qosi18n = Internationalizer.getInternationalizer(RbQoSProfile.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfilesConfigForm.class);
    private RbQoSProfileConfigEntryEditorView view;
    private SimpleRowTable simpleRowTable;

    @Override
    protected EditorView<RbQoSProfileConfigEntry> getEditorView() {
        this.view = new RbQoSProfileConfigEntryEditorView((RbBaseStationEquipment)this.ctx.getEquipment());
        return this.view;
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Type"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
    }

    protected void fillUI(List<Object> managedObjects) {
        String rowKey;
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(0);
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        for (RbQoSProfileConfigEntry entry : this.table.getInstances()) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbQoSProfileName(), row, 0);
            this.tableModel.setInitialValueAt((Object)qosi18n.translateString(RbQoSProfileConfigEntry.toStringRbQoSProfileType(entry.getRbQoSProfileType())), row, 1);
            if (Integer.valueOf(2).equals(entry.getRbQoSProfileClass())) {
                this.tableModel.setRowState(row, -1);
            }
            ++row;
        }
        this.simpleRowTable.setBackgroundCallback(new SimpleRowTable.RowBackgroundCallback(){

            public Color getUnselectedRowBackgroundColor(int rowIndex) {
                RbQoSProfileConfigEntry entity = RbQoSProfilesConfigForm.this.getEntityForRow(rowIndex);
                if (entity != null && Integer.valueOf(2).equals(entity.getRbQoSProfileClass())) {
                    return new Color(255, 200, 200);
                }
                return null;
            }
        });
        this.tableModel.sort();
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbQoSProfileConfigEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("QoSProfileId"));
        }
        if (rowKey != null) {
            int i;
            for (i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                break;
            }
            if (i == row) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected RbQoSProfileConfigEntry getEntityForRow(int row) {
        return (RbQoSProfileConfigEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbQoSProfileConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbPolicyRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbForwardingRuleConfigEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbQoSProfileConfigEntry getNewEntity() {
        RbQoSProfileConfigEntry newEntry = new RbQoSProfileConfigEntry();
        newEntry.setRbQoSProfileIdx(-1L);
        newEntry.setRbQoSProfileType(0);
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbQoSProfileConfigEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbQoSProfileConfigEntry e) {
        for (RbQoSProfileConfigEntry entry : this.table.getInstances()) {
            if (!e.getRbQoSProfileName().equals(entry.getRbQoSProfileName()) || e.getId() == entry.getId()) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("nameUnique", new Object[]{e.getRbQoSProfileName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbQoSProfileConfigEntry e) {
        RbBaseStationEquipment eq = (RbBaseStationEquipment)this.ctx.getEquipment();
        boolean ret = eq.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS ? this.checkModeVoIP(invalidValues, e) : this.checkTransparent(invalidValues, e);
        if (ret) {
            ret = ret && this.checkFR(invalidValues, e);
            return this.checkPR(invalidValues, e) && ret;
        }
        return false;
    }

    private boolean checkTransparent(List<InvalidValue> invalidValues, RbQoSProfileConfigEntry e) {
        if (e.getRbQoSProfileName().equals("@@Transparent@@")) {
            invalidValues.add(new InvalidValue(i18n.translateString("cannotDeleteTransparentQoS"), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    private boolean checkModeVoIP(List<InvalidValue> invalidValues, RbQoSProfileConfigEntry e) {
        if (e.getRbQoSProfileName().equals("@@IP Mode VoIP@@")) {
            invalidValues.add(new InvalidValue(i18n.translateString("cannotDeleteIpModeVoIP"), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    private boolean checkPR(List<InvalidValue> invalidValues, RbQoSProfileConfigEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(1);
        for (RbPolicyRuleConfigEntry entry : table.getInstances()) {
            if (!e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleDownQoSProfileIdx1()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleDownQoSProfileIdx2()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleDownQoSProfileIdx3()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleDownQoSProfileIdx4()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleUpQoSProfileIdx1()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleUpQoSProfileIdx2()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleUpQoSProfileIdx3()) && !e.getRbQoSProfileIdx().equals(entry.getRbPolicyRuleUpQoSProfileIdx4())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("QOSusedPR", new Object[]{e.getRbQoSProfileName(), entry.getRbPolicyRuleName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    private boolean checkFR(List<InvalidValue> invalidValues, RbQoSProfileConfigEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(2);
        for (RbForwardingRuleConfigEntry entry : table.getInstances()) {
            if (!e.getRbQoSProfileIdx().equals(entry.getRbForwardingRuleMulticastQoSIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("QOSusedFR", new Object[]{e.getRbQoSProfileName(), entry.getRbForwardingRuleName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_qos_profiles";
        }
        return "ngnms.rb.help.bs_tdd_qos_profiles";
    }
}

