/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbPriorityClassifierEditorView;
import com.bwanms.rb.gui.configuration.services.preview.PolicyRulePreviewContainer;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbPriorityClassifiersConfigForm
extends RbComplexObjectTableConfigForm<RbPolicyRuleConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbPriorityClassifiersConfigForm.class);
    private UnifiedMOSupport<RbPolicyRuleConfigEntry> serviceTable;
    private List<Object> mos;
    private SimpleRowTable simpleRowTable;
    private RbPriorityClassifierEditorView rbPriorityClassifierEditorView;

    @Override
    protected EditorView<RbPolicyRuleConfigEntry> getEditorView() {
        this.rbPriorityClassifierEditorView = new RbPriorityClassifierEditorView(((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS);
        return this.rbPriorityClassifierEditorView;
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("PriorityType"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
    }

    protected void fillUI(List<Object> managedObjects) {
        this.rbPriorityClassifierEditorView.setIsTddEquipment(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) >= 0);
        this.mos = managedObjects;
        this.serviceTable = (UnifiedMOSupport)managedObjects.get(0);
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        for (RbPolicyRuleConfigEntry entry : this.serviceTable.getInstances()) {
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbPolicyRuleName(), row, 0);
            this.tableModel.setInitialValueAt((Object)i18n.translateString(RbPolicyRuleConfigEntry.toStringRbPolicyRulePriorityType(entry.getRbPolicyRulePriorityType())), row, 1);
            if (Integer.valueOf(2).equals(entry.getRbPolicyRuleClass())) {
                this.tableModel.setRowState(row, -1);
            }
            ++row;
        }
        this.simpleRowTable.setBackgroundCallback(new SimpleRowTable.RowBackgroundCallback(){

            public Color getUnselectedRowBackgroundColor(int rowIndex) {
                RbPolicyRuleConfigEntry entity = RbPriorityClassifiersConfigForm.this.getEntityForRow(rowIndex);
                if (entity != null && Integer.valueOf(2).equals(entity.getRbPolicyRuleClass())) {
                    return new Color(255, 200, 200);
                }
                return null;
            }
        });
        this.tableModel.sort();
        ((RbPriorityClassifierEditorView)this.editorView).setQoSProfiles(((UnifiedMOSupport)managedObjects.get(1)).getInstances());
        String rowKey = null;
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbPolicyRuleConfigEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("policyRuleId"));
        }
        if (rowKey != null) {
            int i;
            for (i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                break;
            }
            if (i == row) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected RbPolicyRuleConfigEntry getEntityForRow(int row) {
        return (RbPolicyRuleConfigEntry)this.serviceTable.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbPolicyRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbQoSProfileConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceTemplateConfigEntry.class, "*"));
        return requestList;
    }

    @Override
    protected UnifiedMOSupport<RbPolicyRuleConfigEntry> getTable() {
        return this.serviceTable;
    }

    @Override
    protected boolean canPreview() {
        return true;
    }

    @Override
    protected void showPreview(RbPolicyRuleConfigEntry currentEntity2) {
        new PolicyRulePreviewContainer(currentEntity2, this.mos.get(1));
    }

    @Override
    protected RbPolicyRuleConfigEntry getNewEntity() {
        RbPolicyRuleConfigEntry newEntry = new RbPolicyRuleConfigEntry();
        newEntry.setRbPolicyRuleIdx(-1L);
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbPolicyRuleConfigEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(0);
        for (RbPolicyRuleConfigEntry entry : table.getInstances()) {
            if (!e.getRbPolicyRuleName().equals(entry.getRbPolicyRuleName()) || e.getId() == entry.getId()) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("nameUnique", new Object[]{e.getRbPolicyRuleName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbPolicyRuleConfigEntry entry) {
        return this.checkService(invalidValues, entry);
    }

    private boolean checkService(List<InvalidValue> invalidValues, RbPolicyRuleConfigEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(2);
        for (RbServiceTemplateConfigEntry entry : table.getInstances()) {
            if (!e.getRbPolicyRuleIdx().equals(entry.getRbServiceTemplatePolicyRuleIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("PRusedSP", new Object[]{e.getRbPolicyRuleName(), entry.getRbServiceTemplateName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_priority_classifiers";
        }
        return "ngnms.rb.help.bs_tdd_priority_classifiers";
    }
}

