/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.rb.gui.configuration.services.RbPriorityClassifierPart;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.ui.components.ComboItem;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbPriorityClassifierPartController {
    private static final Logger log = Logger.getLogger(RbPriorityClassifierPartController.class);
    private RbPriorityClassifierPart panel;

    public RbPriorityClassifierPartController(RbPriorityClassifierPart part) {
        this.panel = part;
    }

    public void checkQoSUpperLimits() {
        this.checkUpperLimit1();
        this.checkUpperLimit2();
        this.checkUpperLimit3();
        this.checkUpperLimit4();
    }

    public void checkUpperLimit1() {
        this.checkLimit(this.panel.getTxtUpperLimit1(), this.panel.getComboQoS1(), true);
    }

    public void checkUpperLimit2() {
        this.checkLimit(this.panel.getTxtUpperLimit2(), this.panel.getComboQoS2(), false);
    }

    public void checkUpperLimit3() {
        this.checkLimit(this.panel.getTxtUpperLimit3(), this.panel.getComboQoS3(), false);
    }

    public void checkUpperLimit4() {
        this.checkLimit(this.panel.getTxtUpperLimit4(), this.panel.getComboQoS4(), false);
    }

    private void checkLimit(JTextField txtField, JComboBox combo, boolean isFirst) {
        String crtVal = txtField.getText();
        try {
            Long temp = null;
            if (!"".equals(crtVal)) {
                temp = Long.parseLong(crtVal);
                txtField.setText(temp.toString());
            } else {
                temp = 0L;
                txtField.setText("0");
            }
            if (temp != null && (temp > 0L || temp == 0L && isFirst)) {
                combo.setEnabled(true);
                if (combo.getItemCount() > 0 && ((ComboItem)combo.getItemAt(0)).isInvalidItem()) {
                    combo.removeItemAt(0);
                }
            } else {
                combo.setSelectedIndex(-1);
                combo.setEnabled(false);
            }
        }
        catch (Exception ex) {
            log.error((Object)("You can relax ... this exception is taken care of and is displayed for debugging purpose only - " + ex));
            combo.setEnabled(false);
        }
    }

    public void checkLimit(String crtVal, JComboBox combo, boolean isFirst) {
        try {
            Long temp = null;
            if (!"".equals(crtVal)) {
                temp = Long.parseLong(crtVal);
            }
            if (temp != null && (temp > 0L || temp == 0L && isFirst)) {
                combo.setEnabled(true);
            } else {
                combo.setEnabled(false);
            }
        }
        catch (Exception ex) {
            log.error((Object)("You can relax ... this exception is taken care of and is displayed for debugging purpose only - " + ex));
            combo.setEnabled(false);
        }
    }

    public void setQoSComboValues(Collection<RbQoSProfileConfigEntry> qoSs) {
        this.setComboItems(this.panel.getComboQoS1(), qoSs);
        this.setComboItems(this.panel.getComboQoS2(), qoSs);
        this.setComboItems(this.panel.getComboQoS3(), qoSs);
        this.setComboItems(this.panel.getComboQoS4(), qoSs);
    }

    private void setComboItems(JComboBox combo, Collection<RbQoSProfileConfigEntry> qoSs) {
        combo.removeAllItems();
        for (RbQoSProfileConfigEntry entry : qoSs) {
            combo.addItem(new ComboItem((Object)entry.getRbQoSProfileIdx(), entry.getRbQoSProfileName()));
        }
    }
}

