/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableConfigForm;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.rb.gui.configuration.services.RbForwardingRuleConfigEntryEditorView;
import com.bwanms.rb.gui.configuration.services.preview.ForwardingRulePreviewContainer;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FireActionLabelMouseListener;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbForwardingRulesConfigForm
extends RbComplexObjectTableConfigForm<RbForwardingRuleConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRulesConfigForm.class);
    private UnifiedMOSupport<RbForwardingRuleConfigEntry> table;
    private List<Object> mos;
    private RbForwardingRuleConfigEntryEditorView view;
    private SimpleRowTable simpleRowTable;
    private RbBaseStationEquipment equipment;

    @Override
    protected EditorView<RbForwardingRuleConfigEntry> getEditorView() {
        this.equipment = (RbBaseStationEquipment)this.ctx.getEquipment();
        this.view = new RbForwardingRuleConfigEntryEditorView(this.equipment);
        this.view.getUI().getLblMulticastQoS().addMouseListener((MouseListener)new FireActionLabelMouseListener(this.view.getUI().getLblMulticastQoS(), new FireActionLabelMouseListener.FireActionUrlCallback(){

            public String getUrl() {
                return "bwanms://config/" + RbForwardingRulesConfigForm.this.ctx.getEquipment().getEUID() + "/Services/QoSProfiles?QoSProfileId=" + FormUtil.getSelectedValue((JComboBox)RbForwardingRulesConfigForm.this.view.getUI().getComboMulticastQoS());
            }

            public ManagedObjectsConfigForm getConfigForm() {
                return RbForwardingRulesConfigForm.this;
            }
        }));
        return this.view;
    }

    @Override
    protected void initializeListTable(JTable jTable) {
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Type"), String.class)}, jTable.getTableHeader());
        this.tableModel.setColumnReadonly(0, true);
        this.tableModel.setColumnReadonly(1, true);
        this.tableModel.setNewRowReadOnlyOverride(false);
        jTable.setModel((TableModel)this.tableModel);
        this.simpleRowTable = new SimpleRowTable(jTable, this.tableModel);
        boolean wiMaxEquipment = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS;
        this.panel.getBtnAdd().setVisible(!wiMaxEquipment);
        this.panel.getBtnDelete().setVisible(!wiMaxEquipment);
        this.panel.getBtnRevert().setVisible(!wiMaxEquipment);
    }

    protected void fillUI(List<Object> managedObjects) {
        String rowKey;
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) < 0) {
            this.view.setTDD(false);
        } else {
            this.view.setTDD(true);
        }
        this.mos = managedObjects;
        this.table = (UnifiedMOSupport)managedObjects.get(0);
        FormUtil.cancelTableEditing((JTable)((RbComplexObjectTableEditorPanel)this.getUI()).getTable());
        this.tableModel.clearTable();
        int row = 0;
        ArrayList<RbForwardingRuleConfigEntry> entries = new ArrayList<RbForwardingRuleConfigEntry>();
        for (RbForwardingRuleConfigEntry rbForwardingRuleConfigEntry : this.table.getInstances()) {
            entries.add(rbForwardingRuleConfigEntry);
        }
        Collections.sort(entries, new Comparator<RbForwardingRuleConfigEntry>(){

            @Override
            public int compare(RbForwardingRuleConfigEntry o1, RbForwardingRuleConfigEntry o2) {
                return o1.getRbForwardingRuleID().compareTo(o2.getRbForwardingRuleID());
            }
        });
        for (RbForwardingRuleConfigEntry entry : entries) {
            if (!RbFeatures.isSipAwareAvailable((RbBaseStationEquipment)this.ctx.getEquipment()) && (entry.getRbForwardingRuleType() == 7 || entry.getRbForwardingRuleType() == 6)) continue;
            this.tableModel.addNewRow(entry.getRowKey(), true);
            this.tableModel.setInitialValueAt((Object)entry.getRbForwardingRuleName(), row, 0);
            this.tableModel.setInitialValueAt((Object)i18n.translateString(RbForwardingRuleConfigEntry.toStringRbForwardingRuleType(entry.getRbForwardingRuleType())), row, 1);
            if (Integer.valueOf(2).equals(entry.getRbForwardingRuleClass())) {
                this.tableModel.setRowState(row, -1);
            }
            ++row;
        }
        this.simpleRowTable.setBackgroundCallback(new SimpleRowTable.RowBackgroundCallback(){

            public Color getUnselectedRowBackgroundColor(int rowIndex) {
                RbForwardingRuleConfigEntry entity = RbForwardingRulesConfigForm.this.getEntityForRow(rowIndex);
                if (entity != null && Integer.valueOf(2).equals(entity.getRbForwardingRuleClass())) {
                    return new Color(255, 200, 200);
                }
                return null;
            }
        });
        this.tableModel.sort();
        ((RbForwardingRuleConfigEntryEditorView)this.editorView).setQoSProfiles(((UnifiedMOSupport)managedObjects.get(1)).getInstances());
        if (this.getCurrentEntity() != null) {
            rowKey = ((RbForwardingRuleConfigEntry)((Object)this.getCurrentEntity())).getRowKey();
        } else {
            FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
            rowKey = String.valueOf(formsConfigSectionView.getAttribute("forwardinRuleId"));
        }
        if (rowKey != null) {
            int i;
            for (i = 0; i < row; ++i) {
                if (!rowKey.equals(this.tableModel.getRowKey(i))) continue;
                this.setSelectedRow(i);
                break;
            }
            if (i == row) {
                this.setSelectedRow(-1);
            }
        } else {
            this.setSelectedRow(-1);
        }
        this.activateButtons();
    }

    @Override
    protected RbForwardingRuleConfigEntry getEntityForRow(int row) {
        return (RbForwardingRuleConfigEntry)this.table.findInstance(this.tableModel.getRowKey(row));
    }

    @Override
    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> requestList = new ArrayList<ConfigFormManagedObjectRequest>();
        requestList.add(this.ctx.createRequest("BS", RbForwardingRuleConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbQoSProfileConfigEntry.class, "*"));
        requestList.add(this.ctx.createRequest("BS", RbServiceTemplateConfigEntry.class, "*"));
        return requestList;
    }

    @Override
    protected RbForwardingRuleConfigEntry getNewEntity() {
        RbForwardingRuleConfigEntry newEntry = new RbForwardingRuleConfigEntry();
        newEntry.setRbForwardingRuleIdx(-1L);
        newEntry.setRbForwardingRuleType(1);
        newEntry.setRbForwardingRuleMulticastRelaying(1);
        newEntry.setRbForwardingRuleUnicastRelaying(1);
        newEntry.setRbForwardingUnknownAddrPolicy(2);
        newEntry.setRbForwardingRuleMulticastVLAN(4095);
        return newEntry;
    }

    @Override
    protected boolean entryDeleteRequested() {
        this.tableModel.setRowState(this.getSelectedRow(), 1);
        return true;
    }

    @Override
    public UnifiedMOSupport<RbForwardingRuleConfigEntry> getTable() {
        return this.table;
    }

    @Override
    protected boolean canPreview() {
        return true;
    }

    @Override
    protected void showPreview(RbForwardingRuleConfigEntry currentEntity2) {
        new ForwardingRulePreviewContainer(currentEntity2, this.mos.get(1));
    }

    @Override
    protected boolean canAddEntry(List<InvalidValue> invalidValues, RbForwardingRuleConfigEntry e) {
        if (e.getRbForwardingRuleName() == null) {
            return true;
        }
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(0);
        for (RbForwardingRuleConfigEntry entry : table.getInstances()) {
            if (!e.getRbForwardingRuleName().equals(entry.getRbForwardingRuleName()) || e.getId() == entry.getId()) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("nameUnique", new Object[]{e.getRbForwardingRuleName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, RbForwardingRuleConfigEntry entry) {
        if (entry.getRbForwardingRuleName().equals("@@Transparent@@")) {
            invalidValues.add(new InvalidValue(i18n.translateString("cannotDeleteTransparentFR"), null, "", (Object)"", null));
            return false;
        }
        return this.checkServiceTemplate(invalidValues, entry);
    }

    private boolean checkServiceTemplate(List<InvalidValue> invalidValues, RbForwardingRuleConfigEntry e) {
        UnifiedMOSupport table = (UnifiedMOSupport)this.mos.get(2);
        for (RbServiceTemplateConfigEntry entry : table.getInstances()) {
            if (!e.getRbForwardingRuleIdx().equals(entry.getRbServiceTemplateForwardingRuleIdx())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("FRusedSP", new Object[]{e.getRbForwardingRuleName(), entry.getRbServiceTemplateName()}), null, "", (Object)"", null));
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_forwarding_rules";
        }
        return "ngnms.rb.help.bs_tdd_forwarding_rules";
    }
}

