/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.rb.gui.configuration.services.RbForwardingRuleConfigEntryPanel;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.ComboItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbForwardingRuleConfigEntryEditorView
extends AbstractBindedEditorView<RbForwardingRuleConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRuleConfigEntryEditorView.class);
    private static final String PROPERTY_NAME_FWRULE_NAME = i18n.translateString("Name");
    private static final String PROPERTY_NAME_FWRULE_MULTICASTQOS = i18n.translateString("MulticastQoS");
    private static final String PROPERTY_NAME_FWRULE_MULTICASTVLAN = i18n.translateString("MulticastVLAN");
    private RbForwardingRuleConfigEntryPanel panel;
    private boolean isTDD;
    private boolean isTemplateClassGlobal;

    public RbForwardingRuleConfigEntryEditorView(RbBaseStationEquipment equipment) {
        this.panel = new RbForwardingRuleConfigEntryPanel(equipment);
    }

    public List<Binder> getBinders() {
        JComboBoxBinding typeBinding = new JComboBoxBinding(i18n, "comboType", "rbForwardingRuleType", i18n.translateString("Type"));
        typeBinding.setIgnoreDisabled(true);
        JComboBoxBinding forwardingRuleMulticastQoSIdxBinding = new JComboBoxBinding(i18n, "comboMulticastQoS", "rbForwardingRuleMulticastQoSIdx", (Object)false, PROPERTY_NAME_FWRULE_MULTICASTQOS);
        forwardingRuleMulticastQoSIdxBinding.setIgnoreDisabled(true);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder((Object)this.panel, (Object)this.entity).add((Binding)new JTextFieldBinding("txtName", "rbForwardingRuleName", PROPERTY_NAME_FWRULE_NAME)).add((Binding)typeBinding).add((Binding)forwardingRuleMulticastQoSIdxBinding).add((Binding)new JSpinnerBinding("spnrMulticastVLAN", "rbForwardingRuleMulticastVLAN", PROPERTY_NAME_FWRULE_MULTICASTVLAN)));
        return binders;
    }

    public void fillUI(RbForwardingRuleConfigEntry entity) {
        if (this.isTDD()) {
            this.isTemplateClassGlobal = entity != null && RbForwardingRuleConfigEntry.toStringRbForwardingRuleClass(entity.getRbForwardingRuleClass()) != null && entity.getRbForwardingRuleClass() == 2;
            this.setControlsEditable(!this.isTemplateClassGlobal);
        }
        if (!this.isTemplateClassGlobal) {
            this.panel.getCkbxMulticastVLAN().setSelected(false);
            this.panel.getController().checkType();
            this.panel.getController().checkMulticast();
        }
        this.panel.getLblGlobalParameter().setVisible(this.isTemplateClassGlobal);
        this.panel.getComboType().setEnabled(entity.getId() == 0L);
        super.fillUI((Serializable)((Object)entity));
    }

    public List<InvalidValue> configureEntity(RbForwardingRuleConfigEntry entity) {
        if (null != entity.getRbForwardingRuleClass() && 2 == entity.getRbForwardingRuleClass()) {
            return new ArrayList<InvalidValue>();
        }
        if ((Integer)ComboItem.getSelectedItem((JComboBox)this.panel.getComboType()) != 2 && (Integer)ComboItem.getSelectedItem((JComboBox)this.panel.getComboType()) != 3) {
            entity.setRbForwardingRuleMulticastRelaying((Integer)ComboItem.getSelectedItem((JComboBox)this.panel.getComboMulticasRelaying()));
            entity.setRbForwardingRuleUnicastRelaying((Integer)ComboItem.getSelectedItem((JComboBox)this.panel.getComboUnicastRelaying()));
            entity.setRbForwardingUnknownAddrPolicy((Integer)ComboItem.getSelectedItem((JComboBox)this.panel.getComboUnknownAddressForwardingPolicy()));
        }
        ArrayList<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
        if ("@@Transparent@@".equals(entity.getRbForwardingRuleName()) && !entity.getRbForwardingRuleName().equals(this.panel.getTxtName().getText())) {
            invalidValues.add(new InvalidValue(i18n.translateString("ChangingTransparentForwardingRuleNameIsNotAllowed"), JTextField.class, i18n.translateString("ForwardingRuleName"), (Object)this.panel.getTxtName().getText(), (Object)this.panel.getTxtName()));
        }
        List ivList = super.configureEntity((Serializable)((Object)entity));
        if (invalidValues.size() > 0) {
            entity.setRbForwardingRuleName("@@Transparent@@");
        }
        ivList.addAll(AbstractBindedEditorView.getEscapedInvalidValues(invalidValues));
        if (ivList != null && ivList.size() > 0) {
            for (InvalidValue iv : ivList) {
                if (!PROPERTY_NAME_FWRULE_MULTICASTVLAN.equals(iv.getPropertyName())) continue;
                int multicastVLAN = (Integer)this.panel.getSpnrMulticastVLAN().getValue();
                ivList.remove(iv);
                if (multicastVLAN == 4096) break;
                ivList.add(new InvalidValue(iv.getMessage().replaceAll("4095", "4096"), iv.getBeanClass(), iv.getPropertyName(), iv.getValue(), iv.getBean()));
                break;
            }
        }
        return ivList;
    }

    public RbForwardingRuleConfigEntryPanel getUI() {
        this.panel.getComboType().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((RbForwardingRuleConfigEntry)((Object)RbForwardingRuleConfigEntryEditorView.this.entity)).getRbForwardingRuleType() != 2 && ((RbForwardingRuleConfigEntry)((Object)RbForwardingRuleConfigEntryEditorView.this.entity)).getRbForwardingRuleType() != 3) {
                    ComboItem.selectItemByValue((JComboBox)RbForwardingRuleConfigEntryEditorView.this.panel.getComboMulticasRelaying(), (Object)((RbForwardingRuleConfigEntry)((Object)RbForwardingRuleConfigEntryEditorView.this.entity)).getRbForwardingRuleMulticastRelaying());
                    ComboItem.selectItemByValue((JComboBox)RbForwardingRuleConfigEntryEditorView.this.panel.getComboUnicastRelaying(), (Object)((RbForwardingRuleConfigEntry)((Object)RbForwardingRuleConfigEntryEditorView.this.entity)).getRbForwardingRuleUnicastRelaying());
                    ComboItem.selectItemByValue((JComboBox)RbForwardingRuleConfigEntryEditorView.this.panel.getComboUnknownAddressForwardingPolicy(), (Object)((RbForwardingRuleConfigEntry)((Object)RbForwardingRuleConfigEntryEditorView.this.entity)).getRbForwardingUnknownAddrPolicy());
                }
            }
        });
        return this.panel;
    }

    public String getTitle() {
        return "ForwardingRule";
    }

    public void setQoSProfiles(Collection<RbQoSProfileConfigEntry> entries) {
        this.panel.setQoSComboValues(entries);
    }

    public String getApplicationPermission() {
        return null;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.forwarding_rule";
    }

    public boolean isTDD() {
        return this.isTDD;
    }

    public void setTDD(boolean isTDD) {
        this.isTDD = isTDD;
    }

    public void setControlsEditable(boolean flag) {
        this.panel.getComboMulticasRelaying().setEnabled(flag);
        this.panel.getComboUnicastRelaying().setEnabled(flag);
        this.panel.getComboUnknownAddressForwardingPolicy().setEnabled(flag);
        this.panel.getSpnrMulticastVLAN().setEnabled(flag);
        this.panel.getCkbxMulticastVLAN().setEnabled(flag);
        this.panel.getComboMulticastQoS().setEnabled(flag);
        this.panel.getTxtName().setEnabled(flag);
    }
}

