/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.configuration.UnifiedMOsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Identifiable;
import com.bwanms.rb.gui.configuration.services.RbComplexObjectTableEditorPanel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.TableUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbComplexObjectTableConfigForm<E extends TableRowMO>
extends UnifiedMOsConfigForm<RbComplexObjectTableEditorPanel> {
    private static final Logger log = Logger.getLogger(RbComplexObjectTableConfigForm.class);
    protected EditorView<E> editorView;
    protected JComponent editorViewComponent;
    private int selectedRow = -1;
    protected RbComplexObjectTableEditorPanel panel;
    private E currentEntity;
    protected SimpleRowTableModel tableModel;

    protected boolean canAdd() {
        return true;
    }

    protected List getManagedObjectRequests() {
        return null;
    }

    protected RbComplexObjectTableEditorPanel initUIComponent() {
        this.editorView = this.getEditorView();
        this.editorViewComponent = this.editorView.getUI();
        this.panel = new RbComplexObjectTableEditorPanel();
        this.initializeListTable(this.panel.getTable());
        this.panel.getTable().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                RbComplexObjectTableConfigForm.this.actionTable();
            }
        });
        this.panel.getTable().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                RbComplexObjectTableConfigForm.this.actionTable();
            }
        });
        this.panel.getBtnAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbComplexObjectTableConfigForm.this.setSelectedRow(-2);
            }
        });
        this.panel.getBtnDelete().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbComplexObjectTableConfigForm.this.actionDelete();
            }
        });
        this.panel.getBtnPreview().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbComplexObjectTableConfigForm.this.actionPreview();
            }
        });
        return this.panel;
    }

    protected abstract EditorView<E> getEditorView();

    protected abstract void initializeListTable(JTable var1);

    private void actionTable() {
        int selectedRow = this.panel.getTable().getSelectedRow();
        if (selectedRow >= 0) {
            this.setSelectedRow(selectedRow);
        }
    }

    protected abstract E getEntityForRow(int var1);

    protected E getNewEntity() {
        return null;
    }

    private void actionDelete() {
        if (this.currentEntity != null && this.selectedRow >= 0) {
            this.entryDeleteRequested();
        }
    }

    private void actionPreview() {
        this.configureCurrentEntity();
        if (this.currentEntity != null) {
            this.showPreview(this.currentEntity);
        }
    }

    protected void showPreview(E currentEntity2) {
    }

    protected List<InvalidValue> configureCurrentEntity() {
        if (this.currentEntity != null) {
            List iValues = this.editorView.configureEntity(this.currentEntity);
            if (this.getTable().findInstance(this.currentEntity.getRowKey()) == null) {
                this.getTable().addInstance(this.currentEntity);
            } else {
                this.getTable().updateInstance(this.currentEntity);
            }
            return iValues;
        }
        return new ArrayList<InvalidValue>();
    }

    protected void setSelectedRow(int row) {
        E originalEntity = this.currentEntity;
        if (row >= 0 && this.panel.getTable().getSelectedRowCount() == 0) {
            ListSelectionModel selectionModel = this.panel.getTable().getSelectionModel();
            selectionModel.setSelectionInterval(row, row);
        } else if (row == -2) {
            this.panel.getTable().getSelectionModel().clearSelection();
        }
        int newSelection = row;
        if (newSelection == -1) {
            if (this.selectedRow != -1) {
                this.panel.getPanelEditor().removeAll();
                this.panel.getPanelEditor().revalidate();
                this.panel.getPanelEditor().repaint();
            }
            this.currentEntity = null;
            this.selectedRow = -1;
        } else {
            if (this.selectedRow == -1) {
                this.panel.getPanelEditor().add((Component)this.editorViewComponent, "Center");
                this.panel.revalidate();
                this.panel.repaint();
            }
            this.selectedRow = row;
            if (newSelection >= 0) {
                this.currentEntity = this.getEntityForRow(this.selectedRow);
            } else if (null == this.currentEntity || 0L != ((Identifiable)this.currentEntity).getId()) {
                this.currentEntity = this.getNewEntity();
            }
            this.editorView.setEntity(this.currentEntity);
            if (null != this.currentEntity && this.currentEntity != originalEntity) {
                this.currentEntity.getChangeStrategy().acknowledge();
                if (null != originalEntity) {
                    originalEntity.getChangeStrategy().reset();
                }
            }
        }
        this.panel.getBtnAdd().setEnabled(this.canAdd());
        this.panel.getBtnPreview().setVisible(this.canPreview());
        this.panel.getBtnPreview().setEnabled(this.selectedRow != -1);
        this.panel.getController().controlTableButtons();
        if (this.currentEntity != null && !"-1".equals(this.currentEntity.getRowKey())) {
            this.cacheInitialGUIValues();
        }
        TableUtil.scrollToSelectedRow((JTable)this.panel.getTable());
    }

    protected boolean canPreview() {
        return false;
    }

    protected E getCurrentEntity() {
        return this.currentEntity;
    }

    protected int getSelectedRow() {
        return this.selectedRow;
    }

    protected boolean entryDeleteRequested() {
        return false;
    }

    protected boolean isMarkedForDelete(int row) {
        return false;
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        int row;
        if (this.getCurrentEntity() != null && (this.getSelectedRow() == -2 || this.getSelectedRow() >= 0 && this.tableModel.getRowState(this.getSelectedRow()) != 1)) {
            List<InvalidValue> validation = this.configureCurrentEntity();
            if (validation.isEmpty()) {
                UnifiedMOSupport table = (UnifiedMOSupport)managedObjects.get(0);
                Identifiable entry = (Identifiable)this.getCurrentEntity();
                if (entry.getId() == 0L && table.findInstance(this.getCurrentEntity().getRowKey()) == null) {
                    if (this.canAddEntry(invalidValues, this.getCurrentEntity())) {
                        table.addInstance(this.getCurrentEntity());
                    }
                } else {
                    this.canAddEntry(invalidValues, this.getCurrentEntity());
                }
            } else {
                invalidValues.addAll(validation);
                return;
            }
        }
        for (row = 0; row < this.tableModel.getRowCount(); ++row) {
            if (this.tableModel.getRowState(row) != 1) continue;
            TableRowMO e = (TableRowMO)this.getTable().findInstance(this.tableModel.getRowKey(row));
            if (e != null) {
                this.canDeleteEntry(invalidValues, e);
                continue;
            }
            log.info((Object)String.format("Row %d with key %s was not found in the table", row, this.tableModel.getRowKey(row)));
        }
        if (invalidValues.isEmpty()) {
            for (row = 0; row < this.tableModel.getRowCount(); ++row) {
                if (this.tableModel.getRowState(row) != 1) continue;
                this.getTable().removeInstance(this.tableModel.getRowKey(row));
            }
        }
        if (invalidValues.isEmpty()) {
            this.panel.getBtnDelete().setEnabled(false);
            this.panel.getBtnRevert().setEnabled(false);
        }
    }

    protected boolean canAddEntry(List<InvalidValue> invalidValues, E entry) {
        return true;
    }

    protected boolean canDeleteEntry(List<InvalidValue> invalidValues, E entry) {
        return true;
    }

    protected abstract UnifiedMOSupport<E> getTable();

    protected void activateButtons() {
        this.panel.getBtnAdd().setEnabled(this.canAdd());
        this.panel.getBtnDelete().setEnabled(this.panel.getTable().getSelectedRowCount() > 0);
        this.panel.getBtnRevert().setEnabled(false);
    }
}

