/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.gui.configuration.ConfigApplicationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.log4j.Logger;

public class TimerHelper {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private static final Logger logger = Logger.getLogger(TimerHelper.class);
    private Timer scheduler;
    private Integer lastConfirmedDelay;
    private final int id = COUNTER.incrementAndGet();
    private final ActionListener refreshListener;

    public TimerHelper(JSpinner spinner, JButton applyBtn, ActionListener refreshListener) {
        this.refreshListener = refreshListener;
        SpinnerNumberModel model = new SpinnerNumberModel(5, 5, 3600, 1);
        spinner.setModel(model);
        this.lastConfirmedDelay = (Integer)spinner.getValue();
        ActionListener applyBtnListener = this.createApplyBtnListener(spinner);
        applyBtn.addActionListener(applyBtnListener);
        AncestorListener refreshBtnListener = this.createRefreshBtnListener(spinner, refreshListener);
        spinner.addAncestorListener(refreshBtnListener);
    }

    private AncestorListener createRefreshBtnListener(final JSpinner spinner, final ActionListener refreshListener) {
        return new AncestorListener(){
            private ActionListener refreshBtnListener;
            private JButton refreshBtn;

            public void ancestorAdded(AncestorEvent event) {
                TimerHelper.this.debug("Registering main panel refresh btn listener ...");
                ConfigApplicationPanel configAppPanel = (ConfigApplicationPanel)SwingUtilities.getAncestorOfClass(ConfigApplicationPanel.class, spinner);
                this.refreshBtnListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        spinner.setValue(TimerHelper.this.lastConfirmedDelay);
                        TimerHelper.this.scheduleRefresh();
                        refreshListener.actionPerformed(e);
                    }
                };
                this.refreshBtn = configAppPanel.getBtnRefresh();
                this.refreshBtn.addActionListener(this.refreshBtnListener);
                TimerHelper.this.scheduleRefresh();
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
                TimerHelper.this.debug("Unregistering main panel refresh btn listener ...");
                this.refreshBtn.removeActionListener(this.refreshBtnListener);
                TimerHelper.this.stopTimer();
            }
        };
    }

    private ActionListener createApplyBtnListener(final JSpinner spinner) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimerHelper.this.debug("Apply btn pressed.");
                TimerHelper.this.lastConfirmedDelay = (Integer)spinner.getValue();
                TimerHelper.this.scheduleRefresh();
            }
        };
    }

    public void stopTimer() {
        this.debug("Cancelling current refresh task for type ");
        if (this.scheduler.isRunning()) {
            this.scheduler.stop();
        }
    }

    private void scheduleRefresh() {
        int delayInMillis = this.lastConfirmedDelay * 1000;
        if (null == this.scheduler) {
            this.debug("Scheduling refresh task for the first time! Delay: " + delayInMillis + " ms");
            this.scheduler = new Timer(delayInMillis, this.refreshListener);
            this.scheduler.setCoalesce(true);
            this.scheduler.setInitialDelay(delayInMillis);
            this.scheduler.start();
        } else {
            int currentDelay = this.scheduler.getDelay();
            if (currentDelay != delayInMillis) {
                this.debug("Scheduling refresh task! New delay: " + delayInMillis + " ms");
                this.scheduler.stop();
                this.scheduler.setDelay(delayInMillis);
                this.scheduler.setInitialDelay(delayInMillis);
                this.scheduler.start();
            } else {
                this.debug("Delay not changed. Nothing to do.");
            }
        }
    }

    private void debug(String msg) {
        logger.debug((Object)("[" + this.id + "] " + msg));
    }
}

