/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.rb.command.RbSuCommand;
import com.bwanms.rb.mo.pm.RbSUEthernetCountersEntry;
import com.bwanms.rb.mo.pm.RbSUWirelessCountersEntry;
import com.bwanms.rb.mo.pm.RbSUWirelessCountersEntrySw41;
import com.bwanms.rb.mo.pm.RbSuMultirateCountersGroup;
import com.bwanms.rb.mo.pm.RbSuMultirateCountersGroupSW45;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.performance.RbCounterNodeInternationalizer;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuPerformanceMonitoringView
extends PerformanceMonitoringSectionView {
    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        RbSU su = (RbSU)this.getEquipment();
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        if (su.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5)) {
            ret.add(this.createRequest(RbSuMultirateCountersGroupSW45.class));
        } else {
            ret.add(this.createRequest(RbSuMultirateCountersGroup.class));
        }
        if (su.getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1")) > 0) {
            ret.add(this.createRequest(RbSUWirelessCountersEntrySw41.class));
        } else {
            ret.add(this.createRequest(RbSUWirelessCountersEntry.class));
        }
        ret.add(this.createRequest(RbSUEthernetCountersEntry.class));
        return ret;
    }

    public String getTitle() {
        return "Performance";
    }

    protected CounterNodeInternationalizer getCounterNodeInternationalizer() {
        return new RbCounterNodeInternationalizer();
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_performance";
        }
        return "ngnms.rb.help.su_tdd_performance";
    }

    protected void resetCounters() {
        RbSU su = (RbSU)super.getEquipment();
        RbSuCommand command = su.createResetCountersCommand();
        command.setRbSUEthernetResetCounters(1);
        command.setRbSUWirelessResetCounters(1);
        super.fireCommand((NetworkElementCommand)command);
    }

    protected boolean isButtonResetActive() {
        return true;
    }
}

