/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringViewCounterProvider;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.rb.mo.pm.RbPMServConnEntry;
import com.bwanms.rb.mo.pm.RbResetCountersCommand;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.performance.RbCounterNodeInternationalizer;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.BeanUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePerformanceMonitoringView
extends PerformanceMonitoringSectionView {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ServicePerformanceMonitoringView.class);
    private long serviceID = 0L;
    private String serviceName;
    private static String[][] SVC_COUNTERS = new String[][]{{"rbPMConnByteReq", "rbPMConnByteReq", "1"}, {"rbPMConnByteTx", "rbPMConnByteTx", "1"}, {"rbPMConnByteRetTx", "rbPMConnByteRetTx", "1"}, {"rbPMConnByteDropped", "rbPMConnByteDropped", "1"}, {"rbPMConnByteDiscarded", "rbPMConnByteDiscarded", "1"}, {"rbPMConnPktsReq", "rbPMConnPktsReq", "1"}, {"rbPMConnPktsTx", "rbPMConnPktsTx", "1"}, {"rbPMConnPktsDropped", "rbPMConnPktsDropped", "1"}, {"rbPMConnPktsDiscarded", "rbPMConnPktsDiscarded", "1"}, {"rbPMConnAvarageDelay", "rbPMConnAvarageDelay", "2"}, {"rbPMConnStandardDeviationDelay", "rbPMConnStandardDeviationDelay", "2"}, {"rbPMConnMaxDelay", "rbPMConnMaxDelay", "2"}, {"rbPMConnCBP", "rbPMConnCBP", "2"}, {"rbPMConnDLI", "rbPMConnDLI", "2"}, {"rbPMConnExBurst", "rbPMConnExBurst", "2"}, {"rbPMConnAvgThroughput", "rbPMConnAvgThroughput", "2"}};
    private static String[][] SVC_COUNTERS_V_3_5 = new String[][]{{"rbPMConnBytesReceived", "rbPMConnBytesReceived", "1"}, {"rbPMConnBytesSentToETH", "rbPMConnBytesSentToETH", "1"}, {"rbPMConnPktsSentToETH", "rbPMConnPktsSentToETH", "1"}, {"rbPMConnByteDroppedARQ", "rbPMConnByteDroppedARQ", "1"}, {"rbPMConnFragmentsDroppedARQ", "rbPMConnFragmentsDroppedARQ", "1"}};
    private static String[] CATEGORIES = new String[]{"DownLevelTable", "UpLevelTable"};
    private static String[] QOS_PREFIXES = new String[]{"DownLevel", "UpLevel"};

    public void setServiceID(long serviceID) {
        this.serviceID = serviceID;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.createRequest(RbPMServConnEntry.class, this.serviceID + ".1*"));
        ret.add(this.createRequest(RbPMServConnEntry.class, this.serviceID + ".2*"));
        return ret;
    }

    public String getTitle() {
        return i18n.translateString("ServiceMonitoringTitle", new Object[]{this.serviceName});
    }

    protected CounterNodeInternationalizer getCounterNodeInternationalizer() {
        return new RbCounterNodeInternationalizer();
    }

    protected PerformanceMonitoringViewCounterProvider createCounterProvider() {
        return new CounterProvider();
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.pm_online_monitoring_breezemax_au_counters";
    }

    protected void resetCounters() {
        for (int i = 1; i <= 4; ++i) {
            for (int j = 1; j <= 2; ++j) {
                RbResetCountersCommand command = new RbResetCountersCommand();
                command.setEquipmentId(super.getEquipment().getId());
                command.setRbServiceID(this.serviceID);
                command.setRbPMConnDirection(j);
                command.setRbPMConnQoSPipeIdx(i);
                command.setRbPMConnResetCounters(1);
                super.fireCommand((NetworkElementCommand)command);
            }
        }
    }

    protected boolean isButtonResetActive() {
        return true;
    }

    private class CounterProvider
    implements PerformanceMonitoringViewCounterProvider {
        private String entityId;
        private String entityLabel;
        private String[][] SVC_COUNTERS_FOR_EQUIPMENT;
        private LinkedHashMap counterData = new LinkedHashMap();

        public CounterProvider() {
            this.entityId = "" + ServicePerformanceMonitoringView.this.getEquipment().getId();
            this.entityLabel = ServicePerformanceMonitoringView.this.serviceName;
            if (ServicePerformanceMonitoringView.this.getEquipment() instanceof RbBaseStationEquipment) {
                RbBaseStationEquipment bs = (RbBaseStationEquipment)ServicePerformanceMonitoringView.this.getEquipment();
                if (!bs.isTDDDuplexMode() && bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_3_5)) {
                    this.SVC_COUNTERS_FOR_EQUIPMENT = new String[SVC_COUNTERS.length + SVC_COUNTERS_V_3_5.length][3];
                    System.arraycopy(SVC_COUNTERS, 0, this.SVC_COUNTERS_FOR_EQUIPMENT, 0, SVC_COUNTERS.length);
                    System.arraycopy(SVC_COUNTERS_V_3_5, 0, this.SVC_COUNTERS_FOR_EQUIPMENT, SVC_COUNTERS.length, SVC_COUNTERS_V_3_5.length);
                } else {
                    this.SVC_COUNTERS_FOR_EQUIPMENT = SVC_COUNTERS;
                }
            }
            for (int i = 0; i < CATEGORIES.length; ++i) {
                LinkedHashMap cat = new LinkedHashMap();
                for (int connIdx = 1; connIdx <= 4; ++connIdx) {
                    Vector<Object> leafs = new Vector<Object>();
                    for (String[] leafDesc : this.SVC_COUNTERS_FOR_EQUIPMENT) {
                        leafs.add(leafDesc.clone());
                    }
                    LinkedHashMap<String, Vector<Object>> qos = new LinkedHashMap<String, Vector<Object>>();
                    qos.put("{leafs}", leafs);
                    cat.put(QOS_PREFIXES[i] + connIdx, qos);
                }
                this.counterData.put(CATEGORIES[i], cat);
            }
        }

        public Object getCounters(String pEntityOID, String pRootNode, int pDepth) {
            return this.counterData;
        }

        public String getProductLine(String pEntityOID) {
            return null;
        }

        public String getEntityLabel(String pEntityID) {
            return this.entityLabel;
        }

        public Object[] getDataAsArray(Object data, String root) {
            ArrayList<String> counters = new ArrayList<String>();
            ArrayList<Double> values = new ArrayList<Double>();
            Long timeStamp = System.currentTimeMillis();
            RbPMServConnEntry pmSvc = (RbPMServConnEntry)data;
            String counterRoot = this.entityId + "/" + root + "/" + CATEGORIES[pmSvc.getRbPMConnDirection() - 1] + "/" + QOS_PREFIXES[pmSvc.getRbPMConnDirection() - 1] + pmSvc.getRbPMConnQoSPipeIdx() + "/";
            for (String[] leaf : this.SVC_COUNTERS_FOR_EQUIPMENT) {
                Number value = (Number)BeanUtils.getPropertyValue((Object)pmSvc, (String)leaf[0]);
                counters.add(counterRoot + leaf[0]);
                values.add(value.doubleValue());
            }
            String[] countersArray = new String[counters.size()];
            counters.toArray(countersArray);
            Number[] valuesArray = new Number[counters.size()];
            values.toArray(valuesArray);
            return new Object[]{countersArray, valuesArray, timeStamp};
        }
    }
}

