/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.translators.MACAddressTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupport;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.rb.command.RbSuCommand;
import com.bwanms.rb.ddi.RbRegisteredSuEntryAssemblerFactory;
import com.bwanms.rb.gui.configuration.SURadioMonitoringPanel;
import com.bwanms.rb.gui.configuration.pm.TimerHelper;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.pm.RbSuMultirateCountersGroupSW45;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.EquipmentAgentException;
import com.bwanms.services.EquipmentCommunicationException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.MacAddress;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SURadioMonitoringView
extends PerformanceMonitoringSectionView {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SURadioMonitoringPanel.class);
    private static final int COUNTERS_NO_4_5_AND_HIGHER = 11;
    private static final int COUNTERS_NO_BELOW_4_5 = 7;
    private static final int CH4_RSSI_ROW = 10;
    private static final int CH3_RSSI_ROW = 9;
    private static final int CH2_RSSI_ROW = 8;
    private static final int CH1_RSSI_ROW = 7;
    private static final int DOWNLINK_RATE_ROW = 6;
    private static final int DOWNLINK_RSSI_ROW = 5;
    private static final int DOWNLINK_SNR_ROW = 4;
    private static final int UPLINK_RATE_ROW = 3;
    private static final int UPLINK_RSSI_ROW = 2;
    private static final int UPLINK_SNR_ROW = 1;
    private static final int TX_POWER_ROW = 0;
    private static final int NO_COL = 0;
    private static final int MAC_NAME_COL = 1;
    private static final int MAC_ADDRESS_COL = 2;
    private static final Logger logger = Logger.getLogger(SURadioMonitoringView.class);
    private static final String TITLE = i18n.translateString("SuRadioMonitoring");
    private SURadioMonitoringPanel suRadioUI;
    private RbSU selectedSU;
    private List<RbRegisteredSuEntry> registeredSUsEntries;
    private Version version;

    public SURadioMonitoringView() {
        this.managedObjectsAccessSupport = new ManagedObjectsAccessSupport((ManagedObjectsAccessSupportCallback)new MOSURadioAccessCallback());
    }

    protected void distributeManagedObjects(List<Object> managedObjects) {
        List registeredSUsEntries = null;
        RbSuMultirateCountersGroupSW45 multirateCountersGroup = null;
        for (Object obj : managedObjects) {
            if (obj instanceof RbRegisteredSuTable) {
                registeredSUsEntries = ((RbRegisteredSuTable)((Object)obj)).getEntries();
                continue;
            }
            multirateCountersGroup = (RbSuMultirateCountersGroupSW45)obj;
        }
        if (null != registeredSUsEntries) {
            this.registeredSUsEntries = registeredSUsEntries;
            this.fillSUsTable(registeredSUsEntries);
        }
        if (null != multirateCountersGroup) {
            this.fillSUsInformationTable(multirateCountersGroup);
        }
    }

    private void fillSUsInformationTable(RbSuMultirateCountersGroupSW45 multirateCountersGroup) {
        SimpleRowTableModel tModel = (SimpleRowTableModel)this.suRadioUI.getSusInformationTbl().getModel();
        tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuTxPower(), 0, 0);
        tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuUlSNR(), 1, 0);
        tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuUlRSSI(), 2, 0);
        tModel.setInitialValueAt((Object)i18n.translateString(RbSuMultirateCountersGroupSW45.toStringRbSuUlCurrentRate(multirateCountersGroup.getRbSuUlCurrentRate())), 3, 0);
        tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuDlSNR(), 4, 0);
        tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuDlRSSI(), 5, 0);
        tModel.setInitialValueAt((Object)i18n.translateString(RbSuMultirateCountersGroupSW45.toStringRbSuDlCurrentRate(multirateCountersGroup.getRbSuDlCurrentRate())), 6, 0);
        if (this.version.compareTo((Object)RbVersions.V_4_5) >= 0) {
            tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuUlCh1RSSIValue(), 7, 0);
            tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuUlCh2RSSIValue(), 8, 0);
            tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuUlCh3RSSIValue(), 9, 0);
            tModel.setInitialValueAt((Object)multirateCountersGroup.getRbSuUlCh4RSSIValue(), 10, 0);
        }
    }

    private void fillSUsTable(List<RbRegisteredSuEntry> registeredSUsEntries) {
        JTable susTbl = this.suRadioUI.getSusTbl();
        SimpleRowTableModel tModel = (SimpleRowTableModel)susTbl.getModel();
        int selectedRow = susTbl.getSelectedRow();
        tModel.clearTable();
        int row = 0;
        for (RbRegisteredSuEntry entry : registeredSUsEntries) {
            if (!entry.getRbSuRegistrationState().equals(2)) continue;
            tModel.addNewRow(entry.getRowKey(), true);
            tModel.setInitialValueAt((Object)(row + 1), row, 0);
            tModel.setInitialValueAt((Object)entry.getRbSuSysName(), row, 1);
            tModel.setInitialValueAt((Object)MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toDashedString(), row, 2);
            ++row;
        }
        if (-1 != selectedRow) {
            susTbl.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    }

    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> counterMOs = new ArrayList<ConfigFormManagedObjectRequest>();
        counterMOs.add(0, this.createRequest("BS", RbRegisteredSuTable.class));
        return counterMOs;
    }

    public void refresh(boolean forceRefresh) {
        this.longActionCallback.onStarting("Refreshing ...");
        this.managedObjectsAccessSupport.requestManagedObjects(this.collectManagedObjectClasses(), false);
    }

    private void refreshSUCounters(RbSU selectedSU) {
        ArrayList<ConfigFormManagedObjectRequest> counterMOs = new ArrayList<ConfigFormManagedObjectRequest>();
        counterMOs.add(this.createRequest(selectedSU.getId(), "BS", RbSuMultirateCountersGroupSW45.class, selectedSU.getMacAddress()));
        this.managedObjectsAccessSupport.requestManagedObjects(counterMOs, true);
    }

    protected boolean isButtonResetActive() {
        return false;
    }

    protected void resetCounters() {
        RbSuCommand command = this.selectedSU.createResetCountersCommand();
        command.setRbSUEthernetResetCounters(1);
        command.setRbSUWirelessResetCounters(1);
        super.fireCommand((NetworkElementCommand)command);
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.craft_su_radio_monitoring";
        }
        return "ngnms.rb.help.su_radio_monitoring";
    }

    public JComponent getUI() {
        if (null == this.suRadioUI) {
            this.suRadioUI = new SURadioMonitoringPanel();
            JSpinner pollingIntervalSpinner = this.suRadioUI.getPollingIntervalSpinner();
            JButton applyBtn = this.suRadioUI.getApplyBtn();
            this.suRadioUI.getSusTbl().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    RbSU tmpSU = SURadioMonitoringView.this.getSelectedSU();
                    if (null != tmpSU && SURadioMonitoringView.this.selectedSU != tmpSU) {
                        if (null == SURadioMonitoringView.this.selectedSU) {
                            SURadioMonitoringView.this.selectedSU = tmpSU;
                            SURadioMonitoringView.this.initSUsInformationTable();
                        } else if (!SURadioMonitoringView.this.selectedSU.getEUID().equals(tmpSU.getEUID())) {
                            SURadioMonitoringView.this.selectedSU = tmpSU;
                            SURadioMonitoringView.this.initSUsInformationTable();
                        }
                        SURadioMonitoringView.this.refreshSUCounters(SURadioMonitoringView.this.selectedSU);
                    }
                }
            });
            new TimerHelper(pollingIntervalSpinner, applyBtn, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (null != SURadioMonitoringView.this.selectedSU) {
                        logger.debug((Object)("Selected SU: " + SURadioMonitoringView.this.selectedSU.getEUID()));
                        SURadioMonitoringView.this.refreshSUCounters(SURadioMonitoringView.this.selectedSU);
                    }
                    logger.debug((Object)"Refresh");
                    SURadioMonitoringView.this.refresh(true);
                }
            });
        }
        return this.suRadioUI;
    }

    private void initSUsInformationTable() {
        JTable tblRowHeader;
        int row;
        SimpleRowTableModel susInformationTableModel = (SimpleRowTableModel)this.suRadioUI.getSusInformationTbl().getModel();
        susInformationTableModel.clearTable();
        String runningVersion = this.parseVersionString(this.selectedSU.getFirmwareVersion());
        this.version = new DefaultVersion(runningVersion);
        if (this.version.compareTo((Object)RbVersions.V_4_5) >= 0) {
            for (row = 1; row <= 11; ++row) {
                susInformationTableModel.addNewRow(Integer.toString(row), true);
            }
            tblRowHeader = new JTable(new DefaultTableModel(new Object[]{i18n.translateString("Name")}, 11){
                private final String[] rowHeaderLabels;
                {
                    this.rowHeaderLabels = new String[]{i18n.translateString("rbSuTxPower"), i18n.translateString("rbSuUlSNR"), i18n.translateString("rbSuUlRSSI"), i18n.translateString("rbSuUlCurrentRate"), i18n.translateString("rbSuDlSNR"), i18n.translateString("rbSuDlRSSI"), i18n.translateString("rbSuDlCurrentRate"), i18n.translateString("rbSuUlCh1RSSIValue"), i18n.translateString("rbSuUlCh2RSSIValue"), i18n.translateString("rbSuUlCh3RSSIValue"), i18n.translateString("rbSuUlCh4RSSIValue")};
                }

                public Object getValueAt(int row, int column) {
                    return this.rowHeaderLabels[row];
                }

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            });
        } else {
            for (row = 0; row <= 6; ++row) {
                susInformationTableModel.addNewRow(Integer.toString(row), true);
            }
            tblRowHeader = new JTable(new DefaultTableModel(new Object[]{i18n.translateString("Name")}, 7){
                private final String[] rowHeaderLabels;
                {
                    this.rowHeaderLabels = new String[]{i18n.translateString("rbSuTxPower"), i18n.translateString("rbSuUlSNR"), i18n.translateString("rbSuUlRSSI"), i18n.translateString("rbSuUlCurrentRate"), i18n.translateString("rbSuDlSNR"), i18n.translateString("rbSuDlRSSI"), i18n.translateString("rbSuDlCurrentRate")};
                }

                public Object getValueAt(int row, int column) {
                    return this.rowHeaderLabels[row];
                }

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            });
        }
        tblRowHeader.setAutoResizeMode(0);
        tblRowHeader.setBackground(SimpleRowTable.READONLY_COLOR);
        tblRowHeader.setGridColor(new Color(102, 102, 102));
        tblRowHeader.setBackground(this.suRadioUI.getBackground());
        tblRowHeader.setCellSelectionEnabled(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)tblRowHeader, "Center");
        JScrollPane susInformationScrollPane = this.suRadioUI.getSusInformationScrollPane();
        susInformationScrollPane.setRowHeaderView(panel);
        JTableHeader corner = tblRowHeader.getTableHeader();
        corner.getColumnModel().getColumn(0).setPreferredWidth(150);
        susInformationScrollPane.setCorner("UPPER_LEFT_CORNER", corner);
        susInformationScrollPane.setCorner("LOWER_LEFT_CORNER", new JScrollBar(0, 0, 499, 0, 500));
    }

    private String parseVersionString(String firmwareVersion) {
        String ver = null;
        ver = firmwareVersion.replace("Rel_", "");
        ver = ver.replaceAll("_", ".");
        return ver;
    }

    private RbSU getSelectedSU() {
        RbSU selectedSU = null;
        JTable susTbl = this.suRadioUI.getSusTbl();
        if (!susTbl.getSelectionModel().isSelectionEmpty()) {
            int selectedRow = susTbl.getSelectedRow();
            if (selectedRow >= susTbl.getModel().getRowCount()) {
                logger.debug((Object)"Error. There are no registered SUs");
            } else {
                String macAddress = (String)((SimpleRowTableModel)susTbl.getModel()).getValueAt(selectedRow, 2);
                try {
                    new MACAddressTranslator().convertToBeanValue((Object)macAddress);
                    String instance = MacAddress.fromDashedString((String)macAddress).toOctetString();
                    macAddress = MacAddress.fromDashedString((String)macAddress).toSimpleString();
                    RbRegisteredSuEntry entry = null;
                    for (RbRegisteredSuEntry e : this.registeredSUsEntries) {
                        if (!instance.equals(e.getRowKey())) continue;
                        entry = e;
                        break;
                    }
                    try {
                        RbRegisteredSuEntryAssemblerFactory.RbRegisteredSuAssembly assembly = (RbRegisteredSuEntryAssemblerFactory.RbRegisteredSuAssembly)ServiceRegistry.getEntityManagerService().get(RbRegisteredSuEntry.class, entry.getId(), null);
                        selectedSU = assembly.getSu();
                    }
                    catch (ServiceException e1) {
                        logger.debug((Object)("Cannot get equipment for euid [" + macAddress + "]"), (Throwable)e1);
                    }
                }
                catch (TranslateException e) {
                    logger.debug((Object)("Cannot translate MAC Address [" + macAddress + "]"), (Throwable)e);
                }
            }
        }
        return selectedSU;
    }

    public String getTitle() {
        return TITLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MOSURadioAccessCallback
    implements ManagedObjectsAccessSupportCallback {
        private final Logger logger = Logger.getLogger(MOSURadioAccessCallback.class);

        private MOSURadioAccessCallback() {
        }

        public void handleRequestManagedObjectsCompleted(List<Object> managedObjects) {
            try {
                SURadioMonitoringView.this.distributeManagedObjects(managedObjects);
                SURadioMonitoringView.this.longActionCallback.onFinished("Done.");
            }
            catch (Exception e) {
                this.logger.error((Object)"Error.", (Throwable)e);
                SURadioMonitoringView.this.longActionCallback.onFinished("Error." + ExceptionUtil.getMessage((Throwable)e));
            }
        }

        public void handleRequestManagedObjectsError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            this.handleThrowable(x);
            SURadioMonitoringView.this.longActionCallback.onFinished("Done.");
        }

        public void handlePostManagedObjectsCompleted() {
            this.logger.debug((Object)"postManagedObjects() completed successfully.");
            SURadioMonitoringView.this.longActionCallback.onFinished("Done.");
            SURadioMonitoringView.this.refresh(true);
        }

        public void handlePostManagedObjectsError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            this.handleThrowable(x);
            SURadioMonitoringView.this.longActionCallback.onFinished("Done.");
        }

        public void handlePostCommandCompleted() {
            SURadioMonitoringView.this.longActionCallback.onFinished("Done.");
            SURadioMonitoringView.this.refresh(true);
        }

        public void handlePostCommandError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            SURadioMonitoringView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage((Throwable)x));
        }

        private void handleThrowable(Throwable x) {
            if (x instanceof EntityNotFoundException) {
                // empty if block
            }
            if (x instanceof EquipmentCommunicationException) {
                // empty if block
            }
            if (x instanceof EquipmentAgentException) {
                // empty if block
            }
        }
    }
}

