/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.rb.command.RbRadiusAcctServerResetCounters;
import com.bwanms.rb.command.RbRadiusAuthServerResetCounters;
import com.bwanms.rb.gui.configuration.RadiusMonitoringPanel;
import com.bwanms.rb.mo.pm.RbRadiusAccServerEntry;
import com.bwanms.rb.mo.pm.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.pm.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.pm.RbRadiusAuthenticationServerEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.performance.RbCounterNodeInternationalizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiusPerformanceMonitoringView
extends PerformanceMonitoringSectionView {
    private static final Logger logger = Logger.getLogger(RadiusPerformanceMonitoringView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RadiusPerformanceMonitoringView.class);
    private RadiusMonitoringPanel panel = null;
    private Integer poolingInterval = 5000;

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.createRequest(RbRadiusAuthenticationServerEntry.class));
        ret.add(this.createRequest(RbRadiusAccountServerEntry.class));
        ret.add(this.createRequest(RbRadiusAuthServerEntry.class));
        ret.add(this.createRequest(RbRadiusAccServerEntry.class));
        return ret;
    }

    public String getTitle() {
        return i18n.translateString("RadiusPerformance");
    }

    protected CounterNodeInternationalizer getCounterNodeInternationalizer() {
        return new RbCounterNodeInternationalizer();
    }

    public RadiusMonitoringPanel getUI() {
        if (this.panel == null) {
            this.panel = new RadiusMonitoringPanel(this);
            this.panel.getBtnApply().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Integer spnValue = (Integer)RadiusPerformanceMonitoringView.this.panel.getSpnPolInterval().getValue();
                    if (spnValue > 3600) {
                        spnValue = 3600;
                        RadiusPerformanceMonitoringView.this.panel.getSpnPolInterval().setValue(3600);
                    }
                    RadiusPerformanceMonitoringView.this.poolingInterval = spnValue * 1000;
                }
            });
            Thread refreshThread = new Thread(new Runnable(){

                public void run() {
                    while (!RadiusPerformanceMonitoringView.this.shouldStop) {
                        try {
                            Thread.sleep(RadiusPerformanceMonitoringView.this.poolingInterval.intValue());
                            RadiusPerformanceMonitoringView.this.refresh(true);
                        }
                        catch (Throwable t) {
                            logger.error((Object)t, t);
                        }
                    }
                }
            });
            refreshThread.start();
        }
        return this.panel;
    }

    protected void distributeManagedObjects(List<Object> managedObjects) {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.getEquipment();
        Iterator<Object> i = managedObjects.iterator();
        this.clearTable((DefaultTableModel)this.getUI().getTblAccountingMonitoring().getModel());
        this.clearTable((DefaultTableModel)this.getUI().getTblAuthenticationMonitoring().getModel());
        HashMap<String, Integer> authSrvTypes = new HashMap<String, Integer>();
        HashMap<String, Integer> acctSrvTypes = new HashMap<String, Integer>();
        while (i.hasNext()) {
            Object entry = i.next();
            if (entry instanceof RbRadiusAuthServerEntry) {
                this.fillAuthColumn((RbRadiusAuthServerEntry)entry, authSrvTypes, bs);
                continue;
            }
            if (entry instanceof RbRadiusAccServerEntry) {
                this.fillAcctColumn((RbRadiusAccServerEntry)entry, acctSrvTypes, bs);
                continue;
            }
            if (entry instanceof RbRadiusAuthenticationServerEntry) {
                RbRadiusAuthenticationServerEntry authEntry = (RbRadiusAuthenticationServerEntry)entry;
                authSrvTypes.put(authEntry.getRbRadiusAuthServerAddress(), authEntry.getRbRadiusAuthServerType());
                continue;
            }
            if (entry instanceof RbRadiusAccountServerEntry) {
                RbRadiusAccountServerEntry acctEntry = (RbRadiusAccountServerEntry)entry;
                acctSrvTypes.put(acctEntry.getRbRadiusAcctServerAddress(), acctEntry.getRbRadiusAcctServerType());
                continue;
            }
            logger.error((Object)("Received wrong class: " + entry.getClass().getName()));
        }
    }

    public void refresh(boolean forceRefresh) {
        this.longActionCallback.onStarting("Refreshing ...");
        this.managedObjectsAccessSupport.requestManagedObjects(this.collectManagedObjectClasses(), forceRefresh);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_radius_performance";
    }

    private void fillAuthColumn(RbRadiusAuthServerEntry authEntry, HashMap<String, Integer> authSrvTypes, RbBaseStationEquipment bs) {
        int row = 0;
        int col = authEntry.getRadiusAuthServerIndex();
        DefaultTableModel model = (DefaultTableModel)this.getUI().getTblAuthenticationMonitoring().getModel();
        model.setValueAt(authEntry.getRadiusAuthClientRoundTripTime(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientAccessRequests(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientAccessRetransmissions(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientAccessAccepts(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientAccessRejects(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientAccessChallenges(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientMalformedAccessResponses(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientBadAuthenticators(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientPendingRequests(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientTimeouts(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientUnknownTypes(), row++, col);
        model.setValueAt(authEntry.getRadiusAuthClientPacketsDropped(), row++, col);
        Object[] tblHeader = bs.isIPCSSwitchingMode() ? new Object[]{model.getColumnName(0), model.getColumnName(1)} : new Object[]{model.getColumnName(0), model.getColumnName(1), model.getColumnName(2)};
        StringBuilder srv = new StringBuilder(authEntry.getRadiusAuthServerAddress());
        Integer srvType = authSrvTypes.get(srv.toString());
        if (srvType != null && !bs.isIPCSSwitchingMode()) {
            srv.append(" (");
            srv.append(i18n.translateString(RbRadiusAuthenticationServerEntry.toStringRbRadiusAuthServerType(srvType)));
            srv.append(") ");
        }
        tblHeader[col] = srv.toString();
        model.setColumnIdentifiers(tblHeader);
    }

    private void fillAcctColumn(RbRadiusAccServerEntry accEntry, HashMap<String, Integer> acctSrvTypes, RbBaseStationEquipment bs) {
        int row = 0;
        int col = accEntry.getRadiusAccServerIndex();
        DefaultTableModel model = (DefaultTableModel)this.getUI().getTblAccountingMonitoring().getModel();
        model.setValueAt(accEntry.getRadiusAccClientRoundTripTime(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientRequests(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientRetransmissions(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientResponses(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientMalformedResponses(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientBadAuthenticators(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientPendingRequests(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientTimeouts(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientUnknownTypes(), row++, col);
        model.setValueAt(accEntry.getRadiusAccClientPacketsDropped(), row++, col);
        Object[] tblHeader = bs.isIPCSSwitchingMode() ? new Object[]{model.getColumnName(0), model.getColumnName(1)} : new Object[]{model.getColumnName(0), model.getColumnName(1), model.getColumnName(2)};
        StringBuilder srv = new StringBuilder(accEntry.getRadiusAccServerAddress());
        Integer srvType = acctSrvTypes.get(srv.toString());
        if (srvType != null && !bs.isIPCSSwitchingMode()) {
            srv.append(" (");
            srv.append(i18n.translateString(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerType(srvType)));
            srv.append(") ");
        }
        tblHeader[col] = srv.toString();
        model.setColumnIdentifiers(tblHeader);
    }

    private void clearTable(DefaultTableModel model) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 1; j < model.getColumnCount(); ++j) {
                model.setValueAt("", i, j);
            }
        }
        model.setColumnIdentifiers(new Object[]{model.getColumnName(0), "", ""});
    }

    protected void resetCounters() {
    }

    protected boolean isButtonResetActive() {
        return false;
    }

    public void resetAuthCounters() {
        for (int i = 1; i < this.getUI().getTblAuthenticationMonitoring().getColumnCount(); ++i) {
            String colHeader = this.getUI().getTblAuthenticationMonitoring().getColumnName(i);
            if (colHeader.length() <= 0) continue;
            RbRadiusAuthServerResetCounters command = new RbRadiusAuthServerResetCounters();
            int endIdx = colHeader.indexOf(" (");
            String authSrvIpAddr = endIdx > 0 ? colHeader.substring(0, endIdx) : colHeader;
            command.setRbRadiusAuthServerAddress(authSrvIpAddr);
            command.setRbRadiusAuthServerResetCounters(1);
            command.setEquipmentId(this.getEquipment().getId());
            this.fireCommand(command);
        }
    }

    public void resetAcctCounters() {
        for (int i = 1; i < this.getUI().getTblAccountingMonitoring().getColumnCount(); ++i) {
            String colHeader = this.getUI().getTblAccountingMonitoring().getColumnName(i);
            if (colHeader.length() <= 0) continue;
            RbRadiusAcctServerResetCounters command = new RbRadiusAcctServerResetCounters();
            int endIdx = colHeader.indexOf(" (");
            String acctSrvIpAddr = endIdx > 0 ? colHeader.substring(0, endIdx) : colHeader;
            command.setRbRadiusAcctServerAddress(acctSrvIpAddr);
            command.setRbRadiusAcctServerResetCounters(1);
            command.setEquipmentId(this.getEquipment().getId());
            this.fireCommand(command);
        }
    }
}

