/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.PMPFServerResetCounters;
import com.bwanms.rb.command.RbPMPFResetInvalidServerPackets;
import com.bwanms.rb.gui.configuration.PFPerformanceMonitoringPanel;
import com.bwanms.rb.mo.pm.RbPMPFServerCounter;
import com.bwanms.rb.mo.pm.RbPMPFServerEntry;
import com.bwanms.rb.mo.pm.RbPMPFServerTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFPerformanceMonitoringView
extends ManagedObjectsConfigForm<PFPerformanceMonitoringPanel> {
    private static final Logger logger = Logger.getLogger(PFPerformanceMonitoringView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(PFPerformanceMonitoringView.class);
    private Integer poolingInterval = 5000;
    private boolean receiving = false;
    private HashMap<String, Integer> columnSizeHashMap = new HashMap();

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbPMPFServerCounter.class));
        ret.add(this.ctx.createRequest("BS", RbPMPFServerTable.class));
        return ret;
    }

    protected PFPerformanceMonitoringPanel initUIComponent() {
        final PFPerformanceMonitoringPanel panel = new PFPerformanceMonitoringPanel(this);
        panel.getBtnResetCounter().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFPerformanceMonitoringView.this.resetInvalidServerPackets();
            }
        });
        panel.getBtnApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer spnValue = (Integer)panel.getSpnPolInterval().getValue();
                if (spnValue > 3600) {
                    spnValue = 3600;
                    panel.getSpnPolInterval().setValue(3600);
                }
                PFPerformanceMonitoringView.this.poolingInterval = spnValue * 1000;
            }
        });
        Thread refreshThread = new Thread(new Runnable(){

            public void run() {
                boolean shouldStop = false;
                while (!shouldStop) {
                    try {
                        Thread.sleep(PFPerformanceMonitoringView.this.poolingInterval.intValue());
                    }
                    catch (InterruptedException ie) {
                        logger.error((Object)ie, (Throwable)ie);
                    }
                    boolean bl = shouldStop = null == panel.getParent() || ((FormsConfigSectionView)PFPerformanceMonitoringView.this.getConfigSectionView()).isShouldStop();
                    if (PFPerformanceMonitoringView.this.receiving || shouldStop) continue;
                    PFPerformanceMonitoringView.this.receiving = true;
                    try {
                        PFPerformanceMonitoringView.this.getConfigSectionView().refresh(true);
                    }
                    catch (Throwable t) {
                        logger.error((Object)t, t);
                    }
                }
            }
        });
        refreshThread.start();
        return panel;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbPMPFServerEntry rbPMPFServerEntry;
        int i;
        Object[][] tableData;
        ((PFPerformanceMonitoringPanel)this.getUI()).getTxtPacketsReceivedFromUnknownServer().setText(String.valueOf(((RbPMPFServerCounter)managedObjects.get(0)).getRbPMPFInvalidServerPackets()));
        JTable table = ((PFPerformanceMonitoringPanel)this.getUI()).getTblPFMonitoring();
        int[] selectedColumns = table.getSelectedColumns();
        if (table.getColumnCount() > 0) {
            for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                this.columnSizeHashMap.put(table.getColumnName(i2), table.getColumnModel().getColumn(i2).getWidth());
            }
        }
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        List entries = ((RbPMPFServerTable)((Object)managedObjects.get(1))).getEntries();
        Object[] headerData = new String[entries.size()];
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (bs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_5) >= 0) {
            tableData = new Object[14][entries.size()];
            for (i = 0; i < entries.size(); ++i) {
                rbPMPFServerEntry = (RbPMPFServerEntry)entries.get(i);
                headerData[i] = rbPMPFServerEntry.getRbPMPFServerIpAddress();
                tableData[0][i] = rbPMPFServerEntry.getRbPMPFServerPortNumber();
                tableData[1][i] = rbPMPFServerEntry.getRbPMPFRoundTripTime();
                tableData[2][i] = rbPMPFServerEntry.getRbPMPFBSRequests();
                tableData[3][i] = rbPMPFServerEntry.getRbPMPFServerRequests();
                tableData[4][i] = rbPMPFServerEntry.getRbPMPFRetransmissions();
                tableData[5][i] = rbPMPFServerEntry.getRbPMPFLuRuAckResponses();
                tableData[6][i] = rbPMPFServerEntry.getRbPMPFLuRuRejectResponses();
                tableData[7][i] = rbPMPFServerEntry.getRbPMBSAccepts();
                tableData[8][i] = rbPMPFServerEntry.getRbPMBSRejects();
                tableData[9][i] = rbPMPFServerEntry.getRbPMPFMalformedRequests();
                tableData[10][i] = rbPMPFServerEntry.getRbPMPFPendingRequests();
                tableData[11][i] = rbPMPFServerEntry.getRbPMPFTimeouts();
                tableData[12][i] = rbPMPFServerEntry.getRbPMPFUnknownTypes();
                tableData[13][i] = rbPMPFServerEntry.getRbPMPFPacketsDropped();
            }
        } else {
            tableData = new Object[12][entries.size()];
            for (i = 0; i < entries.size(); ++i) {
                rbPMPFServerEntry = (RbPMPFServerEntry)entries.get(i);
                headerData[i] = rbPMPFServerEntry.getRbPMPFServerIpAddress();
                tableData[0][i] = rbPMPFServerEntry.getRbPMPFServerPortNumber();
                tableData[1][i] = rbPMPFServerEntry.getRbPMPFRoundTripTime();
                tableData[2][i] = rbPMPFServerEntry.getRbPMPFBSRequests();
                tableData[3][i] = rbPMPFServerEntry.getRbPMPFServerRequests();
                tableData[4][i] = rbPMPFServerEntry.getRbPMPFRetransmissions();
                tableData[5][i] = rbPMPFServerEntry.getRbPMBSAccepts();
                tableData[6][i] = rbPMPFServerEntry.getRbPMBSRejects();
                tableData[7][i] = rbPMPFServerEntry.getRbPMPFMalformedRequests();
                tableData[8][i] = rbPMPFServerEntry.getRbPMPFPendingRequests();
                tableData[9][i] = rbPMPFServerEntry.getRbPMPFTimeouts();
                tableData[10][i] = rbPMPFServerEntry.getRbPMPFUnknownTypes();
                tableData[11][i] = rbPMPFServerEntry.getRbPMPFPacketsDropped();
            }
        }
        model.setDataVector(tableData, headerData);
        int columnCount = table.getColumnModel().getColumnCount();
        for (int i3 = 0; i3 < columnCount; ++i3) {
            Integer cachedWidth = this.columnSizeHashMap.get(table.getColumnName(i3));
            if (cachedWidth != null) {
                table.getColumnModel().getColumn(i3).setPreferredWidth(cachedWidth);
                table.getColumnModel().getColumn(i3).setWidth(cachedWidth);
                continue;
            }
            table.getColumnModel().getColumn(i3).setPreferredWidth(110);
            table.getColumnModel().getColumn(i3).setWidth(110);
        }
        int tableSize = ((PFPerformanceMonitoringPanel)this.getUI()).getPnlMonitoring().getWidth() - 158;
        if (tableSize > table.getColumnModel().getTotalColumnWidth()) {
            int prefferedWidth = tableSize / (entries.size() > 0 ? entries.size() : 1);
            for (int i4 = 0; i4 < entries.size(); ++i4) {
                table.getColumnModel().getColumn(i4).setPreferredWidth(prefferedWidth);
            }
        }
        this.receiving = false;
    }

    public String getTitle() {
        return i18n.translateString("PFPerformance");
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_pf_performance";
    }

    public void resetPMCounters() {
        int[] selection = ((PFPerformanceMonitoringPanel)this.getUI()).getTblPFMonitoring().getSelectedColumns();
        if (selection.length > 0) {
            if (MessageBox.Confirm.showResult((Component)this.getUI(), i18n.translateString("AreYouSureYouWantToResetCounters"), "Reset Counters")) {
                for (int i = 0; i < selection.length; ++i) {
                    PMPFServerResetCounters command = new PMPFServerResetCounters();
                    command.setRbPMPFServerIpAddress(((PFPerformanceMonitoringPanel)this.getUI()).getTblPFMonitoring().getColumnName(selection[i]));
                    command.setRbPMPFResetCounters(1);
                    command.setEquipmentId(this.ctx.getEquipment().getId());
                    this.fireCommand(command);
                    ((PFPerformanceMonitoringPanel)this.getUI()).getTblPFMonitoring().clearSelection();
                }
            }
        } else {
            MessageBox.Alert.showOption((Component)this.getUI(), i18n.translateString("YouMustSelectOneOrMoreColumnsFromTheTable"));
        }
    }

    private void resetInvalidServerPackets() {
        RbPMPFResetInvalidServerPackets command = new RbPMPFResetInvalidServerPackets();
        if (!MessageBox.Confirm.showResult((Component)this.getUI(), i18n.translateString("AreYouSureYouWantToResetCounters"), "Reset Counters")) {
            return;
        }
        command.setRbPMPFResetInvalidServerPackets(1);
        command.setEquipmentId(this.ctx.getEquipment().getId());
        this.fireCommand(command);
    }
}

