/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.rb.command.RbNpuCommand;
import com.bwanms.rb.command.RbPMPFResetInvalidServerPackets;
import com.bwanms.rb.command.RbServiceGroupCountersReset;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.pm.RbMngmntPortCountersEntry;
import com.bwanms.rb.mo.pm.RbNPUDataPortRxCountersEntry;
import com.bwanms.rb.mo.pm.RbNPUDataPortTxCountersEntry;
import com.bwanms.rb.mo.pm.RbPMPFServerCounter;
import com.bwanms.rb.mo.pm.RbServiceGroupFDDCountersEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.performance.RbCounterNodeInternationalizer;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NpuPerformanceMonitoringView
extends PerformanceMonitoringSectionView {
    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.createRequest(RbNPUDataPortRxCountersEntry.class));
        ret.add(this.createRequest(RbNPUDataPortTxCountersEntry.class));
        ret.add(this.createRequest(RbMngmntPortCountersEntry.class));
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.equipment;
        if (RbVersions.V_4_5.isOlderOrEqualWith(bs.getSoftwareVersion()) && ((RbBS)this.equipment).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
            ret.add(this.createRequest(RbPMPFServerCounter.class));
        }
        if (RbVersions.V_3_6.isSupersetOf(bs.getSoftwareVersion())) {
            ret.add(this.createRequest(RbServiceGroupFDDCountersEntry.class));
        }
        return ret;
    }

    public String getTitle() {
        return "Performance";
    }

    protected CounterNodeInternationalizer getCounterNodeInternationalizer() {
        return new RbCounterNodeInternationalizer();
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.npu_performance";
        }
        return "ngnms.rb.help.bs_tdd_npu_performance";
    }

    protected void resetCounters() {
        RbBS bs = (RbBS)super.getEquipment();
        this.resetNPUCounters(bs);
        if (RbVersions.V_4_5.isOlderOrEqualWith(bs.getSoftwareVersion())) {
            this.resetPMPFServerPacketsReset(bs);
        }
        if (RbVersions.V_3_6.isSupersetOf(bs.getSoftwareVersion())) {
            this.resetFDDServiceGroupCounters(bs);
        }
    }

    private void resetPMPFServerPacketsReset(RbBS bs) {
        RbPMPFResetInvalidServerPackets command = new RbPMPFResetInvalidServerPackets();
        command.setEquipmentId(bs.getId());
        command.setRbPMPFResetInvalidServerPackets(1);
        super.fireCommand((NetworkElementCommand)command);
    }

    private void resetNPUCounters(RbBS bs) {
        RbNpuConfigEntry npuEntry = (RbNpuConfigEntry)((Object)this.getAttribute("NPU"));
        RbNpuCommand command = RbNpuCommand.createResetCountersCommand(bs, npuEntry);
        command.setRbNpuDataPortResetCounters(1);
        command.setRbMngmntPortResetCounters(1);
        super.fireCommand((NetworkElementCommand)command);
    }

    private void resetFDDServiceGroupCounters(RbBS bs) {
        RbServiceGroupCountersReset command = new RbServiceGroupCountersReset();
        command.setEquipmentId(bs.getId());
        command.setServiceGroupResetCounters(1);
        super.fireCommand((NetworkElementCommand)command);
    }

    protected boolean isButtonResetActive() {
        return true;
    }
}

