/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.rb.command.RbAuCommand;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.pm.RbAUBackplaneCountersEntry;
import com.bwanms.rb.mo.pm.RbAUWirelessCountersEntry;
import com.bwanms.rb.mo.pm.RbAUWirelessCountersEntrySw41;
import com.bwanms.rb.mo.pm.RbAuConfigCountersEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.performance.RbCounterNodeInternationalizer;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuPerformanceMonitoringView
extends PerformanceMonitoringSectionView {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AuPerformanceMonitoringView.class);

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.getEquipment();
        RbAuConfigEntry auEntry = (RbAuConfigEntry)((Object)this.getAttribute("AU"));
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        if (bs.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1")) > 0) {
            ret.add(this.createRequest("AU." + auEntry.getRbSlotNumber(), RbAUWirelessCountersEntrySw41.class));
        } else {
            ret.add(this.createRequest("AU." + auEntry.getRbSlotNumber(), RbAUWirelessCountersEntry.class));
        }
        ret.add(this.createRequest("AU." + auEntry.getRbSlotNumber(), RbAUBackplaneCountersEntry.class));
        if (bs.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            ret.add(this.createRequest("AU." + auEntry.getRbSlotNumber(), RbAuConfigCountersEntry.class));
        } else if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.5")) >= 0) {
            ret.add(this.createRequest("AU." + auEntry.getRbSlotNumber(), RbAuConfigCountersEntry.class));
        }
        return ret;
    }

    public String getTitle() {
        return "Performance";
    }

    protected CounterNodeInternationalizer getCounterNodeInternationalizer() {
        return new RbCounterNodeInternationalizer();
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.au_performance";
        }
        return "ngnms.rb.help.au_tdd_performance";
    }

    protected void resetCounters() {
        RbBS bs = (RbBS)super.getEquipment();
        RbAuConfigEntry auEntry = (RbAuConfigEntry)((Object)this.getAttribute("AU"));
        RbAuCommand command = RbAuCommand.createResetCountersCommand(bs, auEntry);
        command.setRbAUBackplaneResetCounters(1);
        command.setRbAUWirelessResetCounters(1);
        super.fireCommand((NetworkElementCommand)command);
    }

    protected boolean isButtonResetActive() {
        return true;
    }
}

