/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration.pm;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupport;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.mo.TableRowMO;
import com.bwanms.rb.command.RbSpecAnalyzerCommand;
import com.bwanms.rb.gui.configuration.AUSpectrumAnalysisChartPanel;
import com.bwanms.rb.gui.configuration.AUSpectrumAnalysisPanel;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbSpecAnalyzerConfigEntry;
import com.bwanms.rb.mo.RbSpecAnalyzerResultsEntry;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.EquipmentAgentException;
import com.bwanms.services.EquipmentCommunicationException;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import jclass.chart.Chartable;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChart;
import jclass.chart.VectorDataSource;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUSpectrumAnalysisMonitoringView
extends PerformanceMonitoringSectionView {
    private static final double _MAX_HOLD_MHZ_CT = 1000000.0;
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(AUSpectrumAnalysisPanel.class);
    private static final Logger logger = Logger.getLogger(AUSpectrumAnalysisMonitoringView.class);
    private static final String SPECTRUM_ANALYSIS_RESULTS_CHART = i18n.translateString("specAnalysisResultsChart");
    private static final String INVALID_NUMBER_FORMAT = i18n.translateString("InvalidNumberFormat");
    private static final String GENERIC_VALUE_BETWEEN_WITH_STEP = "GenericValueBetweenWithStep";
    private static final String SCAN_TIME_LBL = i18n.translateString("ScanTime");
    private static final String START_FREQ_HIGHER_THAN_STOP_FREQ = i18n.translateString("StartFreqHigherThanStopFreq");
    private static final String CHANNEL_MUST_HAVE_ASSOC_ODU = i18n.translateString("ChannelMustHaveAssocODU");
    private static final String CHANNEL_MUST_HAVE_FRQ_BAND_DEFINED = i18n.translateString("SelectedChannelMustHaveActualBandDefined");
    private static final String STOP_FREQUENCY_LBL = i18n.translateString("StopFrequency");
    private static final String START_FREQUENCY_LBL = i18n.translateString("StartFrequency");
    private static final String TITLE = i18n.translateString("SpectrumAnalysis");
    private static final String DISCONNECTED = i18n.translateString("disconnected(5)");
    private static final String CONFIRMATION_MESSAGE_START = "ConfirmStart";
    private static final String CONFIRMATION_MESSAGE_ABORT = i18n.translateString("ConfirmAbort");
    private static final String FREQUENCY_MHZ = i18n.translateString("ResultsFrequency");
    private static final String RSSI_DB = i18n.translateString("RSSI");
    private static final String ACTION_ABORT_TXT = i18n.translateString(RbSpecAnalyzerConfigEntry.toStringRbSpecAnalyzerTestAction(2));
    private static final String ACTION_START_TXT = i18n.translateString(RbSpecAnalyzerConfigEntry.toStringRbSpecAnalyzerTestAction(1));
    private static final String[] CSV_HEADER_LABELS = new String[]{AUSpectrumAnalysisPanel.RESULTS_NUMBER, AUSpectrumAnalysisPanel.RESULTS_FREQUENCY, AUSpectrumAnalysisPanel.RESULTS_AVERAGE_RSSI, AUSpectrumAnalysisPanel.RESULTS_MAX_HOLD_FREQ, AUSpectrumAnalysisPanel.RESULTS_MAX_HOLD_RSSI};
    private static final int MAX_SCAN_TIME = 65535;
    private static final int MIN_SCAN_TIME = 1;
    private static final int NUMBER_COL = 0;
    private static final int FREQUENCY_COL = 1;
    private static final int AVERAGE_RSSI_COL = 2;
    private static final int MAX_HOLD_FREQUENCY_COL = 3;
    private static final int MAX_HOLD_RSSI_COL = 4;
    private static final int STATUS_INACTIVE = 1;
    private static final int STATUS_ACTIVE = 2;
    private static final int STATUS_FINISHED = 3;
    private static final int STATUS_ABORTED = 4;
    private static final int INITIAL_REFRESH_INTERVAL = 10000;
    private static final int TIME_BUFFER = 2;
    private static final int TO_MILLIS = 1000;
    private static final int VER_STRING_BEGINING_INDEX = 4;
    private static final String EMPTY_STRING = "";
    private static final int RSSI_LIMITS_OFFSET = 10;
    private static final String VERSION_STRING_DELIMITER = "_";
    private int currentStatus = 1;
    private AUSpectrumAnalysisPanel specAnalysisUI;
    private Timer onSpectrumTimer;
    private RbAuConfigEntry auEntry;
    private List<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
    private boolean mosSet = false;
    private RbAuChannelConfigTable rbAuChannelConfigTable = new RbAuChannelConfigTable(new ArrayList<RbAuChannelConfigEntry>());
    private RbFrequencyBandsTable rbFrequencyBandsTable = new RbFrequencyBandsTable(new ArrayList<RbFrequencyBandsEntry>());
    private RbAuPhyParameters rbAuPhyParametersGroup = null;
    private JDialog dlg = null;
    private AUSpectrumAnalysisChartPanel auSpectrumAnalysisChartPanel;
    private String stopFrequency;
    private String startFrequency;

    public AUSpectrumAnalysisMonitoringView() {
        this.managedObjectsAccessSupport = new ManagedObjectsAccessSupport((ManagedObjectsAccessSupportCallback)new MOAUSpectrumAccessCallback());
    }

    public void apply(List<InvalidValue> invalidValues) {
        super.apply(this.invalidValues);
    }

    private void changeUIComponentsStatus(boolean status) {
        this.specAnalysisUI.getChannelCmb().setEnabled(status);
        this.specAnalysisUI.getStartFrequencyTxt().setEnabled(status);
        this.specAnalysisUI.getStopFrequencyTxt().setEnabled(status);
        this.specAnalysisUI.getScanStepCmb().setEnabled(status);
        this.specAnalysisUI.getScanTimeSpinner().setEnabled(status);
    }

    private RbSpecAnalyzerCommand createAbortCommand() {
        RbSpecAnalyzerCommand rbSpecAnalyzerCommand = new RbSpecAnalyzerCommand();
        rbSpecAnalyzerCommand.setEquipmentId(this.equipment.getId());
        rbSpecAnalyzerCommand.setRbSpecAnalyzerSlotId(this.auEntry.getRbSlotNumber());
        rbSpecAnalyzerCommand.setRbSpecAnalyzerTestAction(2);
        return rbSpecAnalyzerCommand;
    }

    private RbSpecAnalyzerCommand createStartCommand() {
        RbSpecAnalyzerCommand rbSpecAnalyzerCommand = new RbSpecAnalyzerCommand();
        JComboBox channelCmb = this.specAnalysisUI.getChannelCmb();
        JTextField startFrequencyTxt = this.specAnalysisUI.getStartFrequencyTxt();
        JTextField stopFrequencyTxt = this.specAnalysisUI.getStopFrequencyTxt();
        JComboBox scanStepCmb = this.specAnalysisUI.getScanStepCmb();
        JSpinner scanTimeSpinner = this.specAnalysisUI.getScanTimeSpinner();
        Integer channel = (Integer)FormUtil.getSelectedValue((JComboBox)channelCmb);
        String startFrequency = startFrequencyTxt.getText();
        String stopFrequency = stopFrequencyTxt.getText();
        String scanStep = (String)FormUtil.getSelectedValue((JComboBox)scanStepCmb);
        Long scanTime = (Long)scanTimeSpinner.getValue();
        Integer refreshInterval = Integer.parseInt(scanTime.toString()) * 1000;
        this.onSpectrumTimer.setDelay(refreshInterval + 2000);
        rbSpecAnalyzerCommand.setEquipmentId(this.equipment.getId());
        rbSpecAnalyzerCommand.setRbSpecAnalyzerSlotId(this.auEntry.getRbSlotNumber());
        rbSpecAnalyzerCommand.setRbSpecAnalyzerChannelId(channel);
        rbSpecAnalyzerCommand.setRbSpecAnalyzerStartFreq(startFrequency);
        rbSpecAnalyzerCommand.setRbSpecAnalyzerStopFreq(stopFrequency);
        rbSpecAnalyzerCommand.setRbSpecAnalyzerScanStep(scanStep);
        rbSpecAnalyzerCommand.setRbSpecAnalyzerScanTime(scanTime);
        rbSpecAnalyzerCommand.setRbSpecAnalyzerTestAction(1);
        return rbSpecAnalyzerCommand;
    }

    private void displayChart() {
        this.updateChartData();
        this.dlg.setSize(new Dimension(800, 600));
        this.dlg.setVisible(true);
    }

    protected void distributeManagedObjects(List<Object> managedObjects) {
        RbSpecAnalyzerConfigEntry configEntry = null;
        ArrayList<RbSpecAnalyzerResultsEntry> rbSpecAnalyzerResultsEntries = new ArrayList<RbSpecAnalyzerResultsEntry>();
        for (Object obj : managedObjects) {
            if (obj instanceof RbSpecAnalyzerConfigEntry) {
                configEntry = (RbSpecAnalyzerConfigEntry)obj;
            }
            if (obj instanceof RbAuChannelConfigEntry) {
                this.rbAuChannelConfigTable.addEntry((TableRowMO)((RbAuChannelConfigEntry)((Object)obj)));
            }
            if (obj instanceof RbFrequencyBandsTable) {
                this.rbFrequencyBandsTable = (RbFrequencyBandsTable)((Object)obj);
            }
            if (obj instanceof RbAuPhyParameters) {
                this.rbAuPhyParametersGroup = (RbAuPhyParameters)((Object)obj);
            }
            if (!(obj instanceof RbSpecAnalyzerResultsEntry)) continue;
            rbSpecAnalyzerResultsEntries.add((RbSpecAnalyzerResultsEntry)obj);
        }
        if (null != configEntry) {
            this.fillConfigParameters(configEntry);
        }
        this.fillSpectrumAnalysisTable(rbSpecAnalyzerResultsEntries);
        this.specAnalysisUI.getSpectrumAnalysisBtn().setEnabled(!this.isDisconnected());
    }

    private void doExport() {
        JTable spectrumAnalysisTbl = this.specAnalysisUI.getSpectrumAnalysisTbl();
        File exportFile = this.getExportFile("csv", this.specAnalysisUI);
        if (null != exportFile) {
            String confirmMsg;
            boolean overwriteExistingFile = false;
            String title = i18n.translateString("ExportResultsTitle");
            if (exportFile.exists() && !(overwriteExistingFile = MessageBox.WarnConfirm.showResult((Component)this.specAnalysisUI, confirmMsg = i18n.translateString("ExportFileReplacingConfirmation", new Object[]{exportFile.getAbsolutePath()}), title))) {
                logger.debug((Object)("Export stopped. User chose not to overwrite file " + exportFile.getAbsolutePath()));
                return;
            }
            try {
                this.exportResults(spectrumAnalysisTbl, exportFile);
                logger.debug((Object)("Export successfull. [" + spectrumAnalysisTbl.getModel().getRowCount() + "] scanned frequencies exported to file " + exportFile.getAbsolutePath()));
            }
            catch (IOException e) {
                logger.debug((Object)"Export results error", (Throwable)e);
                String msg = i18n.translateString("ExportResultsError", new Object[]{e.getMessage()});
                MessageBox.Error.showResult((Component)this.specAnalysisUI, msg, title);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResults(JTable spectrumAnalysisTbl, File selectedFile) throws IOException {
        CSVWriter csvOut = null;
        try {
            SimpleRowTableModel tModel = (SimpleRowTableModel)spectrumAnalysisTbl.getModel();
            FileWriter fileWriter = new FileWriter(selectedFile);
            csvOut = new CSVWriter((Writer)fileWriter);
            csvOut.writeNext(CSV_HEADER_LABELS);
            for (int row = 0; row <= tModel.getRowCount() - 1; ++row) {
                String[] equipmentValues = new String[]{String.valueOf(tModel.getValueAt(row, 0)), String.valueOf(tModel.getValueAt(row, 1)), String.valueOf(tModel.getValueAt(row, 2)), String.valueOf(tModel.getValueAt(row, 3)), String.valueOf(tModel.getValueAt(row, 4))};
                csvOut.writeNext(equipmentValues);
            }
        }
        finally {
            if (null != csvOut) {
                csvOut.close();
            }
        }
    }

    private void fillConfigParameters(RbSpecAnalyzerConfigEntry specAnalysisConfigEntry) {
        String stopFrequency;
        String startFrequency;
        JComboBox channelCmb = this.specAnalysisUI.getChannelCmb();
        JTextField startFrequencyTxt = this.specAnalysisUI.getStartFrequencyTxt();
        JTextField stopFrequencyTxt = this.specAnalysisUI.getStopFrequencyTxt();
        stopFrequencyTxt.setBorder(startFrequencyTxt.getBorder());
        JTextField currentStatusTxt = this.specAnalysisUI.getCurrentStatusTxt();
        JComboBox scanStepCmb = this.specAnalysisUI.getScanStepCmb();
        JSpinner scanTimeSpinner = this.specAnalysisUI.getScanTimeSpinner();
        Integer channel = specAnalysisConfigEntry.getRbSpecAnalyzerChannelId();
        this.startFrequency = startFrequency = specAnalysisConfigEntry.getRbSpecAnalyzerStartFreq();
        this.stopFrequency = stopFrequency = specAnalysisConfigEntry.getRbSpecAnalyzerStopFreq();
        Integer currentStatus = specAnalysisConfigEntry.getRbSpecAnalyzerTestStatus();
        String scanStep = specAnalysisConfigEntry.getRbSpecAnalyzerScanStep();
        Long scanTime = specAnalysisConfigEntry.getRbSpecAnalyzerScanTime();
        FormUtil.setSelectedValue((JComboBox)channelCmb, (Object)channel);
        startFrequencyTxt.setText(startFrequency);
        stopFrequencyTxt.setText(stopFrequency);
        currentStatusTxt.setText(i18n.translateString(RbSpecAnalyzerConfigEntry.toStringRbSpecAnalyzerTestStatus(currentStatus)));
        FormUtil.setSelectedValue((JComboBox)scanStepCmb, (Object)scanStep);
        scanTimeSpinner.setValue(scanTime);
        switch (currentStatus) {
            case 1: {
                this.currentStatus = 1;
                this.specAnalysisUI.getSpectrumAnalysisBtn().setText(ACTION_START_TXT);
                this.changeUIComponentsStatus(true);
                this.onSpectrumTimer.stop();
                break;
            }
            case 2: {
                this.currentStatus = 2;
                this.specAnalysisUI.getSpectrumAnalysisBtn().setText(ACTION_ABORT_TXT);
                this.changeUIComponentsStatus(false);
                this.onSpectrumTimer.start();
                break;
            }
            case 3: {
                this.currentStatus = 3;
                this.specAnalysisUI.getSpectrumAnalysisBtn().setText(ACTION_START_TXT);
                this.changeUIComponentsStatus(true);
                this.onSpectrumTimer.stop();
                break;
            }
            case 4: {
                this.currentStatus = 4;
                this.specAnalysisUI.getSpectrumAnalysisBtn().setText(ACTION_START_TXT);
                this.changeUIComponentsStatus(true);
                this.onSpectrumTimer.stop();
            }
        }
    }

    private void fillSpectrumAnalysisTable(ArrayList<RbSpecAnalyzerResultsEntry> rbSpecAnalyzerResultsEntries) {
        JTable spectrumAnalysisTbl = this.specAnalysisUI.getSpectrumAnalysisTbl();
        SimpleRowTableModel tModel = (SimpleRowTableModel)spectrumAnalysisTbl.getModel();
        tModel.clearTable();
        int row = 0;
        for (RbSpecAnalyzerResultsEntry resultsEntry : rbSpecAnalyzerResultsEntries) {
            tModel.addNewRow(resultsEntry.getRowKey(), true);
            Integer number = resultsEntry.getRbResultsNumber();
            String frequency = resultsEntry.getRbResultsFrequency();
            Integer averageRSSI = resultsEntry.getRbResultsAverageRSSI();
            String maxHoldFreq = resultsEntry.getRbResultsMaxHoldFreq();
            Integer maxHoldRSSI = resultsEntry.getRbResultsMaxHoldRSSI();
            tModel.setInitialValueAt((Object)number, row, 0);
            tModel.setInitialValueAt((Object)frequency, row, 1);
            tModel.setInitialValueAt((Object)averageRSSI, row, 2);
            tModel.setInitialValueAt((Object)maxHoldFreq, row, 3);
            tModel.setInitialValueAt((Object)maxHoldRSSI, row, 4);
            ++row;
        }
        if (this.isNotEmptyTable()) {
            this.updateChartData();
        }
        this.specAnalysisUI.getExportBtn().setEnabled(this.isNotEmptyTable());
        this.specAnalysisUI.getDisplayChartBtn().setEnabled(this.isNotEmptyTable());
    }

    private double[][] getDataFromTModel(SimpleRowTableModel tModel) {
        DecimalFormat pattern = new DecimalFormat("###.000");
        double[][] data = new double[4][tModel.getRowCount()];
        for (int row = 0; row <= tModel.getRowCount() - 1; ++row) {
            double maxHoldFreq = Double.valueOf(((String)tModel.getValueAt(row, 3)).replace(",", EMPTY_STRING)) / 1000000.0;
            String precision = pattern.format(maxHoldFreq);
            data[0][row] = Double.valueOf((String)tModel.getValueAt(row, 1));
            data[1][row] = ((Integer)tModel.getValueAt(row, 2)).intValue();
            data[2][row] = Double.valueOf(precision);
            data[3][row] = ((Integer)tModel.getValueAt(row, 4)).intValue();
        }
        if (tModel.getRowCount() > 0) {
            this.startFrequency = data[0][0] < data[2][0] ? Double.valueOf(data[0][0]).toString() : Double.valueOf(data[2][0]).toString();
            int counter = tModel.getRowCount() - 1;
            this.stopFrequency = data[0][counter] > data[2][counter] ? Double.valueOf(data[0][counter]).toString() : Double.valueOf(data[2][counter]).toString();
        }
        return data;
    }

    private Double getEstimatedTime() {
        Double freq1 = Double.parseDouble(this.specAnalysisUI.getStartFrequencyTxt().getText());
        Double freq2 = Double.parseDouble(this.specAnalysisUI.getStopFrequencyTxt().getText());
        Double step = Double.parseDouble((String)FormUtil.getSelectedValue((JComboBox)this.specAnalysisUI.getScanStepCmb()));
        Long time = (Long)this.specAnalysisUI.getScanTimeSpinner().getValue();
        return (Math.floor((freq2 - freq1) / step) + 1.0) * (double)(time + 2L);
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.craft_au_spectrum_analyzer";
        }
        return "ngnms.rb.help.au_spectrum_analyzer";
    }

    protected List<? extends UnifiedMORequest> getManagedObjectRequests() {
        return null;
    }

    private Double[] getResultsRSSILimits(SimpleRowTableModel tModel) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int row = 0; row <= tModel.getRowCount() - 1; ++row) {
            values.add(Double.valueOf(((Integer)tModel.getValueAt(row, 2)).intValue()));
            values.add(Double.valueOf(((Integer)tModel.getValueAt(row, 4)).intValue()));
        }
        Double[] limits = new Double[]{(Double)Collections.min(values), (Double)Collections.max(values)};
        return limits;
    }

    public String getTitle() {
        return this.isDisconnected() ? TITLE + " ( " + DISCONNECTED + " )" : TITLE;
    }

    public JComponent getUI() {
        this.auEntry = (RbAuConfigEntry)((Object)this.getAttribute("AU"));
        if (null == this.specAnalysisUI) {
            this.specAnalysisUI = new AUSpectrumAnalysisPanel();
            JButton spectrumAnalysisBtn = this.specAnalysisUI.getSpectrumAnalysisBtn();
            JButton exportBtn = this.specAnalysisUI.getExportBtn();
            JButton displayChartBtn = this.specAnalysisUI.getDisplayChartBtn();
            spectrumAnalysisBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AUSpectrumAnalysisMonitoringView.this.spectrumAnalysisAction();
                }
            });
            exportBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AUSpectrumAnalysisMonitoringView.this.doExport();
                }
            });
            displayChartBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AUSpectrumAnalysisMonitoringView.this.displayChart();
                }
            });
            this.onSpectrumTimer = new Timer(10000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AUSpectrumAnalysisMonitoringView.this.refresh(true);
                }
            });
            this.onSpectrumTimer.setRepeats(true);
            this.onSpectrumTimer.setCoalesce(true);
        }
        return this.specAnalysisUI;
    }

    protected boolean isButtonResetActive() {
        return false;
    }

    private boolean isDisconnected() {
        return !this.auEntry.isConnected();
    }

    private boolean isNotEmptyTable() {
        SimpleRowTableModel tModel = (SimpleRowTableModel)this.specAnalysisUI.getSpectrumAnalysisTbl().getModel();
        return 0 != tModel.getRowCount();
    }

    private boolean isValidCommand() {
        this.invalidValues.clear();
        JComboBox channelCmb = this.specAnalysisUI.getChannelCmb();
        JTextField startFrequencyTxt = this.specAnalysisUI.getStartFrequencyTxt();
        JTextField stopFrequencyTxt = this.specAnalysisUI.getStopFrequencyTxt();
        JSpinner scanTimeSpinner = this.specAnalysisUI.getScanTimeSpinner();
        Integer channel = (Integer)FormUtil.getSelectedValue((JComboBox)channelCmb);
        Double startFrequency = null;
        try {
            startFrequency = Double.parseDouble(startFrequencyTxt.getText());
        }
        catch (NumberFormatException e) {
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, START_FREQUENCY_LBL + ": [" + startFrequencyTxt.getText() + "] " + INVALID_NUMBER_FORMAT);
            return false;
        }
        Double stopFrequency = null;
        try {
            stopFrequency = Double.parseDouble(stopFrequencyTxt.getText());
        }
        catch (NumberFormatException e) {
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, STOP_FREQUENCY_LBL + ": [" + stopFrequencyTxt.getText() + "] " + INVALID_NUMBER_FORMAT);
            return false;
        }
        Long scanTime = (Long)scanTimeSpinner.getValue();
        RbAuChannelConfigEntry rbAuChannelEntry = (RbAuChannelConfigEntry)this.rbAuChannelConfigTable.findEntry(EMPTY_STRING + this.auEntry.getRbSlotNumber() + "." + channel);
        Integer band = rbAuChannelEntry.getRbAuChannelOduActualFrequencyBand();
        RbFrequencyBandsEntry rbFrequencyBandsEntry = (RbFrequencyBandsEntry)this.rbFrequencyBandsTable.findEntry(band.toString());
        if (rbAuChannelEntry != null && 1 != rbAuChannelEntry.getRbAuChannelOperStatus()) {
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, CHANNEL_MUST_HAVE_ASSOC_ODU);
            return false;
        }
        if (null == rbFrequencyBandsEntry) {
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, CHANNEL_MUST_HAVE_FRQ_BAND_DEFINED);
            return false;
        }
        Double adjust = RbAuPhyParameters.getFrequencyBoundsAdjust(this.rbAuPhyParametersGroup.getRbAuPhyConfiguredBandwidth());
        double lowerBound = rbFrequencyBandsEntry.getRbFrequencyBandStartFrequency().doubleValue() / 1000.0 + adjust;
        double upperBound = rbFrequencyBandsEntry.getRbFrequencyBandStopFrequency().doubleValue() / 1000.0 - adjust;
        if (startFrequency < lowerBound || startFrequency > upperBound || (startFrequency - lowerBound) * 1000.0 % (double)rbFrequencyBandsEntry.getRbFrequencyBandStep().longValue() != 0.0) {
            Object[] range = new Object[]{String.valueOf(lowerBound), String.valueOf(upperBound), String.valueOf(rbFrequencyBandsEntry.getRbFrequencyBandStep().doubleValue() / 1000.0)};
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, START_FREQUENCY_LBL + ": " + i18n.translateString(GENERIC_VALUE_BETWEEN_WITH_STEP, range));
            return false;
        }
        if (stopFrequency < lowerBound || stopFrequency > upperBound || (stopFrequency - lowerBound) * 1000.0 % (double)rbFrequencyBandsEntry.getRbFrequencyBandStep().longValue() != 0.0) {
            Object[] range = new Object[]{String.valueOf(lowerBound), String.valueOf(upperBound), String.valueOf(rbFrequencyBandsEntry.getRbFrequencyBandStep().doubleValue() / 1000.0)};
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, STOP_FREQUENCY_LBL + ": " + i18n.translateString(GENERIC_VALUE_BETWEEN_WITH_STEP, range));
            return false;
        }
        if (startFrequency > stopFrequency) {
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, START_FREQ_HIGHER_THAN_STOP_FREQ);
            return false;
        }
        if (1L > scanTime || 65535L < scanTime) {
            MessageBox.Error.quickShow((Component)this.specAnalysisUI, SCAN_TIME_LBL + "value must be between " + 1 + " and " + 65535);
            return false;
        }
        return true;
    }

    public void refresh(boolean forceRefresh) {
        this.longActionCallback.onStarting("Refreshing ...");
        ArrayList<ConfigFormManagedObjectRequest> counterMOs = new ArrayList<ConfigFormManagedObjectRequest>();
        if (!this.isDisconnected()) {
            String runningVersion = this.auEntry.getRbAuRunningSoftware().equals(1) ? this.auEntry.getRbAuOperSwVersion() : this.auEntry.getRbAuShadowSwVersion();
            DefaultVersion version = new DefaultVersion(runningVersion = runningVersion.substring(4), VERSION_STRING_DELIMITER);
            if (version.compareTo((Object)RbVersions.V_4_5) >= 0) {
                counterMOs.add(this.createRequest(RbSpecAnalyzerConfigEntry.class, this.auEntry.getRbSlotNumber().toString()));
                if (!this.mosSet) {
                    counterMOs.add(this.createRequest("BS", RbAuChannelConfigEntry.class, EMPTY_STRING + this.auEntry.getRbSlotNumber().toString() + ".*"));
                    counterMOs.add(this.createRequest("BS", RbFrequencyBandsTable.class));
                    counterMOs.add(this.createRequest((String)this.getAttribute("NR"), RbAuPhyParametersGroup.class));
                }
                counterMOs.add(this.createRequest(RbSpecAnalyzerResultsEntry.class, this.auEntry.getRbSlotNumber().toString() + ".*"));
            }
        }
        this.managedObjectsAccessSupport.requestManagedObjects(counterMOs, this.mosSet);
        this.mosSet = true;
    }

    protected void resetCounters() {
    }

    private void spectrumAnalysisAction() {
        if (2 != this.currentStatus && this.isValidCommand() && MessageBox.WarnConfirm.showResult((Component)this.specAnalysisUI, this.currentStatus != 2 ? i18n.translateString(CONFIRMATION_MESSAGE_START, new Object[]{this.getEstimatedTime()}) : CONFIRMATION_MESSAGE_ABORT)) {
            RbSpecAnalyzerCommand rbSpecAnalyzerStartCommand = this.createStartCommand();
            this.fireCommand(rbSpecAnalyzerStartCommand);
            ((SimpleRowTableModel)this.specAnalysisUI.getSpectrumAnalysisTbl().getModel()).clearTable();
        } else if (2 == this.currentStatus && MessageBox.WarnConfirm.showResult((Component)this.specAnalysisUI, this.currentStatus != 2 ? i18n.translateString(CONFIRMATION_MESSAGE_START, new Object[]{this.getEstimatedTime()}) : CONFIRMATION_MESSAGE_ABORT)) {
            RbSpecAnalyzerCommand rbSpecAnalyzerAbortCommand = this.createAbortCommand();
            this.fireCommand(rbSpecAnalyzerAbortCommand);
            this.onSpectrumTimer.stop();
        }
    }

    private void updateChartData() {
        this.initDlg();
        SimpleRowTableModel tModel = (SimpleRowTableModel)this.specAnalysisUI.getSpectrumAnalysisTbl().getModel();
        JCChart spectrumAnalysisChart = this.auSpectrumAnalysisChartPanel.getCurrentChart();
        VectorDataSource vds = new VectorDataSource(this.getDataFromTModel(tModel), 1);
        vds.setSeriesLabels(new String[]{AUSpectrumAnalysisPanel.RESULTS_AVERAGE_RSSI, AUSpectrumAnalysisPanel.RESULTS_MAX_HOLD_RSSI});
        vds.setName(EMPTY_STRING);
        JCAxis xAxis = spectrumAnalysisChart.getDataView(0).getXAxis();
        JCAxis yAxis = spectrumAnalysisChart.getDataView(0).getYAxis();
        spectrumAnalysisChart.getDataView(0).setDataSource((Chartable)vds);
        Double startFreq = Double.valueOf(this.startFrequency);
        Double stopFreq = Double.valueOf(this.stopFrequency);
        xAxis.setMin(startFreq.doubleValue());
        xAxis.setMax(stopFreq.doubleValue());
        xAxis.setNumSpacing((stopFreq - startFreq) / 10.0);
        JCAxisTitle xTitle = new JCAxisTitle(FREQUENCY_MHZ);
        xAxis.setTitle(xTitle);
        xAxis.setPrecision(3);
        xAxis.setMaxIsDefault(true);
        Double[] limits = this.getResultsRSSILimits(tModel);
        yAxis.setMin(limits[0] - 10.0);
        yAxis.setMax(limits[1] + 10.0);
        yAxis.setTitle(new JCAxisTitle(RSSI_DB));
        yAxis.setPrecision(2);
    }

    private void initDlg() {
        if (null == this.dlg) {
            Container topLevelParent = this.specAnalysisUI.getTopLevelAncestor();
            this.dlg = topLevelParent instanceof Frame ? new JDialog((Frame)topLevelParent) : (topLevelParent instanceof Dialog ? new JDialog((Dialog)topLevelParent) : new JDialog());
            KeyAdapter theListener = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        AUSpectrumAnalysisMonitoringView.this.dlg.dispose();
                    }
                }
            };
            this.dlg.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    AUSpectrumAnalysisMonitoringView.this.dlg.dispose();
                    super.windowClosing(e);
                }
            });
            this.dlg.setTitle(SPECTRUM_ANALYSIS_RESULTS_CHART);
            this.dlg.setModal(true);
            this.auSpectrumAnalysisChartPanel = new AUSpectrumAnalysisChartPanel(SPECTRUM_ANALYSIS_RESULTS_CHART);
            this.auSpectrumAnalysisChartPanel.init();
            this.dlg.add((Component)this.auSpectrumAnalysisChartPanel, "Center");
            this.auSpectrumAnalysisChartPanel.setParent(this.dlg);
            FrameUtil.addKeyListenerRecursively((Component)this.dlg, (KeyAdapter)theListener);
            int maxWidth = (int)this.dlg.getGraphicsConfiguration().getBounds().getWidth();
            int maxHeight = (int)this.dlg.getGraphicsConfiguration().getBounds().getHeight();
            this.dlg.setLocation((maxWidth - 800) / 2, (maxHeight - 600) / 2);
            this.dlg.pack();
        }
    }

    private File getExportFile(String fileExt, JComponent uiParent) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(i18n.translateString("ExportResultsTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString("FileChooserApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(i18n.translateString("ExportSpectrumFilterDescr", new Object[]{"*." + fileExt}));
        fileChooser.setFileFilter((FileFilter)fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            String ext;
            File exportFile = fileChooser.getSelectedFile();
            int lastDotIndex = exportFile.getName().lastIndexOf(46);
            String string = ext = lastDotIndex == -1 ? null : exportFile.getName().substring(lastDotIndex + 1);
            if (!fileExt.equalsIgnoreCase(ext)) {
                exportFile = new File(exportFile.getAbsolutePath() + "." + fileExt);
            }
            return exportFile;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MOAUSpectrumAccessCallback
    implements ManagedObjectsAccessSupportCallback {
        private final Logger logger = Logger.getLogger(MOAUSpectrumAccessCallback.class);

        private MOAUSpectrumAccessCallback() {
        }

        public void handleRequestManagedObjectsCompleted(List<Object> managedObjects) {
            try {
                AUSpectrumAnalysisMonitoringView.this.distributeManagedObjects(managedObjects);
                AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Done.");
            }
            catch (Exception e) {
                this.logger.error((Object)"Error.", (Throwable)e);
                AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Error." + ExceptionUtil.getMessage((Throwable)e));
            }
        }

        public void handleRequestManagedObjectsError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            this.handleThrowable(x);
            AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Done.");
        }

        public void handlePostManagedObjectsCompleted() {
            this.logger.debug((Object)"postManagedObjects() completed successfully.");
            AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Done.");
            AUSpectrumAnalysisMonitoringView.this.refresh(true);
        }

        public void handlePostManagedObjectsError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            this.handleThrowable(x);
            AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Done.");
        }

        public void handlePostCommandCompleted() {
            AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Done.");
            AUSpectrumAnalysisMonitoringView.this.refresh(true);
        }

        public void handlePostCommandError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            AUSpectrumAnalysisMonitoringView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage((Throwable)x));
        }

        private void handleThrowable(Throwable x) {
            if (x instanceof EntityNotFoundException) {
                // empty if block
            }
            if (x instanceof EquipmentCommunicationException) {
                // empty if block
            }
            if (x instanceof EquipmentAgentException) {
                // empty if block
            }
        }
    }
}

