/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.command.RbTrapRestoreDefaults;
import com.bwanms.rb.gui.configuration.TrapsControlPanelControllerSw411;
import com.bwanms.rb.gui.configuration.TrapsControlPanelSw411;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.RbTrapConfigTable;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapsControlConfigFormSw411
extends ManagedObjectsConfigForm<TrapsControlPanelSw411> {
    private static final Logger log = Logger.getLogger(TrapsControlConfigFormSw411.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TrapsControlConfigFormSw411.class);

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder binder = new TableBinder(i18n, (SimpleRowTableModel)((TrapsControlPanelSw411)this.getUI()).getTblTraps().getModel(), (SNMPTableMO)managedObjects.get(0));
        binders.add((Binder)binder);
    }

    public TrapsControlPanelSw411 initUIComponent() {
        TrapsControlPanelSw411 panel = new TrapsControlPanelSw411(this);
        return panel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbTrapConfigTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        ((TrapsControlPanelSw411)this.getUI()).getCmbRestoreDefaults().setSelectedIndex(0);
        TreeMap<Integer, String> traps = new TreeMap<Integer, String>();
        HashMap<Integer, String> severityDefaults = new HashMap<Integer, String>();
        traps.putAll(TrapsControlPanelControllerSw411.trapsTDD);
        severityDefaults.putAll(TrapsControlPanelControllerSw411.severityDefaultsTDD);
        if (bs.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.2")) < 0) {
            traps.putAll(TrapsControlPanelControllerSw411.trapsTDDAddOn);
            severityDefaults.putAll(TrapsControlPanelControllerSw411.severityDefaultsTDDAddOn);
        }
        if (bs.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.5")) >= 0) {
            if (bs instanceof RbBS) {
                traps.putAll(TrapsControlPanelControllerSw411.trapsTDD45BS);
                severityDefaults.putAll(TrapsControlPanelControllerSw411.severityDefaultsTDD45BS);
            } else {
                traps.putAll(TrapsControlPanelControllerSw411.trapsTDD45MBS);
                severityDefaults.putAll(TrapsControlPanelControllerSw411.severityDefaultsTDD45MBS);
            }
        }
        ArrayList trapIds = new ArrayList(traps.size());
        trapIds.addAll(traps.keySet());
        Collections.sort(trapIds);
        HashMap<String, Integer> trapRowByKey = new HashMap<String, Integer>();
        SimpleRowTableModel model = (SimpleRowTableModel)((TrapsControlPanelSw411)this.getUI()).getTblTraps().getModel();
        model.clearTable();
        int trapsSize = trapIds.size();
        for (int i = 0; i < trapsSize; ++i) {
            int trapId = (Integer)trapIds.get(i);
            if (trapId < 128 || trapId > 132) {
                model.addNewRow("2." + trapId, true);
                model.setInitialValueAt((Object)trapId, i, 0);
                model.setInitialValueAt(traps.get(trapId), i, 1);
                model.setInitialValueAt(severityDefaults.get(trapId), i, 3);
                trapRowByKey.put("2." + trapId, i);
                continue;
            }
            int snmpTrapId = trapId - 128;
            model.addNewRow("1." + snmpTrapId, true);
            model.setInitialValueAt((Object)trapId, i, 0);
            model.setInitialValueAt(traps.get(trapId), i, 1);
            model.setInitialValueAt(severityDefaults.get(trapId), i, 3);
            trapRowByKey.put("1." + snmpTrapId, i);
        }
        RbTrapConfigTable trapCfgTbl = (RbTrapConfigTable)((Object)managedObjects.get(0));
        List trapCfg = trapCfgTbl.getEntries();
        FormUtil.cancelTableEditing((JTable)((TrapsControlPanelSw411)this.getUI()).getTblTraps());
        for (RbTrapConfigEntry trap : trapCfg) {
            Integer rowIdx = (Integer)trapRowByKey.get(trap.getTrapEnterprizeId() + "." + trap.getTrapId());
            if (null == rowIdx) {
                log.error((Object)("rowIdx not found: " + trap.getTrapEnterprizeId() + "." + trap.getTrapId()));
                continue;
            }
            int row = rowIdx;
            model.setRowState(row, 0);
            model.setInitialValueAt((Object)trap.getTrapEnable(), row, 2);
            model.setInitialValueAt((Object)trap.getTrapSeverity(), row, 4);
            model.setInitialValueAt((Object)trap.getTrapSuppressionInterval(), row, 5);
        }
        TableUtil.autoResizeColumn((JTable)((TrapsControlPanelSw411)this.getUI()).getTblTraps(), (int)0, (boolean)true);
        model.sort();
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        SimpleRowTableModel model = (SimpleRowTableModel)((TrapsControlPanelSw411)this.getUI()).getTblTraps().getModel();
        FormUtil.stopTableEditing((JTable)((TrapsControlPanelSw411)this.getUI()).getTblTraps());
        RbTrapConfigTable trapCfgTbl = (RbTrapConfigTable)((Object)managedObjects.get(0));
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            switch (model.getRowState(i)) {
                case 3: {
                    RbTrapConfigEntry entry = (RbTrapConfigEntry)trapCfgTbl.findEntry(model.getRowKey(i));
                    if (entry != null) {
                        entry.setTrapEnable((Integer)model.getValueAt(i, 2));
                        entry.setTrapSeverity((Integer)model.getValueAt(i, 4));
                        try {
                            Integer suppressionInterval = Integer.parseInt(model.getValueAt(i, 5).toString());
                            entry.setTrapSuppressionInterval(suppressionInterval);
                            if (suppressionInterval >= 0 && suppressionInterval <= 86400) continue block5;
                            invalidValues.add(new InvalidValue(i18n.translateString("valueNotInRange", new Object[]{"0", "86400"}), RbTrapConfigEntry.class, i18n.translateString("trapSuppressionInterval"), (Object)model.getValueAt(i, 5).toString(), (Object)entry));
                        }
                        catch (NumberFormatException nfe) {
                            invalidValues.add(new InvalidValue(i18n.translateString("valueNotInRange", new Object[]{"0", "86400"}), RbTrapConfigEntry.class, i18n.translateString("trapSuppressionInterval"), (Object)model.getValueAt(i, 5).toString(), (Object)entry));
                        }
                        continue block5;
                    }
                    model.revertRow(i);
                }
            }
        }
    }

    public String getTitle() {
        return "TrapsControl";
    }

    public void restoreDefaults(Integer defaults) {
        RbTrapRestoreDefaults command = new RbTrapRestoreDefaults();
        command.setEquipmentId(this.ctx.getEquipment().getId());
        command.setRbTrapRestoreDefaults(defaults);
        this.fireCommand(command);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.traps";
    }
}

