/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.command.RbTrapRestoreDefaults;
import com.bwanms.rb.gui.configuration.TrapsControlPanelControllerSw211;
import com.bwanms.rb.gui.configuration.TrapsControlPanelSw211;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.RbTrapConfigTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapsControlConfigFormSw211
extends ManagedObjectsConfigForm<TrapsControlPanelSw211> {
    private static final Logger log = Logger.getLogger(TrapsControlConfigFormSw211.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TrapsControlConfigFormSw211.class);

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder binder = new TableBinder(i18n, (SimpleRowTableModel)((TrapsControlPanelSw211)this.getUI()).getTblTraps().getModel(), (SNMPTableMO)managedObjects.get(0));
        binders.add((Binder)binder);
    }

    public TrapsControlPanelSw211 initUIComponent() {
        TrapsControlPanelSw211 panel = new TrapsControlPanelSw211(this);
        return panel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbTrapConfigTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        boolean isTDD;
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        ((TrapsControlPanelSw211)this.getUI()).getCmbRestoreDefaults().setSelectedIndex(0);
        TreeMap<Integer, String> traps = new TreeMap<Integer, String>();
        HashMap<Integer, String> severityDefaults = new HashMap<Integer, String>();
        boolean bl = isTDD = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0;
        if (!isTDD) {
            boolean isFDD2114;
            boolean isFDD35or36;
            traps.putAll(TrapsControlPanelControllerSw211.traps);
            if (bs instanceof RbMBS && bs.getSoftwareVersion().compareTo((Object)new DefaultVersion("3.0.1")) >= 0) {
                severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsMicroFDD);
            } else {
                severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsFDD);
            }
            boolean bl2 = isFDD35or36 = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("3.5")) >= 0 && bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("3.6")) <= 0;
            if (isFDD35or36) {
                traps.putAll(TrapsControlPanelControllerSw211.trapsFDDAddOn35);
                severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsFDDAddOn35);
            }
            boolean bl3 = isFDD2114 = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.4")) >= 0;
            if (isFDD2114) {
                boolean isFDD3x;
                boolean isFDD2116;
                traps.putAll(TrapsControlPanelControllerSw211.trapsSw2114AddOn);
                severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsSw2114AddOn);
                boolean bl4 = isFDD2116 = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.6")) >= 0;
                if (isFDD2116) {
                    traps.putAll(TrapsControlPanelControllerSw211.trapsSw2116AddOn);
                    severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsSw2116AddOn);
                }
                boolean bl5 = isFDD3x = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("3.0")) >= 0;
                if (isFDD3x) {
                    traps.putAll(TrapsControlPanelControllerSw211.trapsFDDAddOn);
                    severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsFDDAddOn);
                    traps.remove(61);
                    traps.remove(62);
                    traps.remove(120);
                    traps.remove(121);
                    traps.remove(122);
                    traps.remove(123);
                    traps.remove(124);
                    traps.remove(125);
                }
            }
        } else {
            boolean isTDD402;
            traps.putAll(TrapsControlPanelControllerSw211.trapsTDD);
            severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsTDD);
            boolean bl6 = isTDD402 = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0.2")) >= 0;
            if (isTDD402) {
                traps.putAll(TrapsControlPanelControllerSw211.trapsTDDSw402AddOn);
                severityDefaults.putAll(TrapsControlPanelControllerSw211.severityDefaultsTDD402AddOn);
            }
        }
        ArrayList trapIds = new ArrayList(traps.size());
        trapIds.addAll(traps.keySet());
        Collections.sort(trapIds);
        HashMap<String, Integer> trapRowByKey = new HashMap<String, Integer>();
        SimpleRowTableModel model = (SimpleRowTableModel)((TrapsControlPanelSw211)this.getUI()).getTblTraps().getModel();
        model.clearTable();
        int trapsSize = trapIds.size();
        for (int i = 0; i < trapsSize; ++i) {
            int trapId = (Integer)trapIds.get(i);
            if (trapId < 128 || trapId > 132) {
                model.addNewRow("2." + trapId, true);
                model.setInitialValueAt((Object)trapId, i, 0);
                model.setInitialValueAt(traps.get(trapId), i, 1);
                model.setInitialValueAt(severityDefaults.get(trapId), i, 3);
                trapRowByKey.put("2." + trapId, i);
                continue;
            }
            int snmpTrapId = trapId - 128;
            model.addNewRow("1." + snmpTrapId, true);
            model.setInitialValueAt((Object)trapId, i, 0);
            model.setInitialValueAt(traps.get(trapId), i, 1);
            model.setInitialValueAt(severityDefaults.get(trapId), i, 3);
            trapRowByKey.put("1." + snmpTrapId, i);
        }
        RbTrapConfigTable trapCfgTbl = (RbTrapConfigTable)((Object)managedObjects.get(0));
        List trapCfg = trapCfgTbl.getEntries();
        FormUtil.cancelTableEditing((JTable)((TrapsControlPanelSw211)this.getUI()).getTblTraps());
        for (RbTrapConfigEntry trap : trapCfg) {
            Integer rowIdx = (Integer)trapRowByKey.get(trap.getTrapEnterprizeId() + "." + trap.getTrapId());
            if (null == rowIdx) {
                log.error((Object)("rowIdx not found: " + trap.getTrapEnterprizeId() + "." + trap.getTrapId()));
                continue;
            }
            int row = rowIdx;
            model.setRowState(row, 0);
            model.setInitialValueAt((Object)trap.getTrapEnable(), row, 2);
            model.setInitialValueAt((Object)trap.getTrapSeverity(), row, 4);
            model.setInitialValueAt((Object)trap.getTrapSuppressionInterval(), row, 5);
        }
        TableUtil.autoResizeColumn((JTable)((TrapsControlPanelSw211)this.getUI()).getTblTraps(), (int)0, (boolean)true);
        model.sort();
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        SimpleRowTableModel model = (SimpleRowTableModel)((TrapsControlPanelSw211)this.getUI()).getTblTraps().getModel();
        FormUtil.stopTableEditing((JTable)((TrapsControlPanelSw211)this.getUI()).getTblTraps());
        RbTrapConfigTable trapCfgTbl = (RbTrapConfigTable)((Object)managedObjects.get(0));
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            switch (model.getRowState(i)) {
                case 3: {
                    RbTrapConfigEntry entry = (RbTrapConfigEntry)trapCfgTbl.findEntry(model.getRowKey(i));
                    if (entry != null) {
                        entry.setTrapEnable((Integer)model.getValueAt(i, 2));
                        entry.setTrapSeverity((Integer)model.getValueAt(i, 4));
                        try {
                            Integer suppressionInterval = Integer.parseInt(model.getValueAt(i, 5).toString());
                            entry.setTrapSuppressionInterval(suppressionInterval);
                            if (suppressionInterval >= 0 && suppressionInterval <= 86400) continue block5;
                            invalidValues.add(new InvalidValue(i18n.translateString("valueNotInRange", new Object[]{"0", "86400"}), RbTrapConfigEntry.class, i18n.translateString("trapSuppressionInterval"), (Object)model.getValueAt(i, 5).toString(), (Object)entry));
                        }
                        catch (NumberFormatException nfe) {
                            invalidValues.add(new InvalidValue(i18n.translateString("valueNotInRange", new Object[]{"0", "86400"}), RbTrapConfigEntry.class, i18n.translateString("trapSuppressionInterval"), (Object)model.getValueAt(i, 5).toString(), (Object)entry));
                        }
                        continue block5;
                    }
                    model.revertRow(i);
                }
            }
        }
    }

    public String getTitle() {
        return "TrapsControl";
    }

    public void restoreDefaults(Integer defaults) {
        RbTrapRestoreDefaults command = new RbTrapRestoreDefaults();
        command.setEquipmentId(this.ctx.getEquipment().getId());
        command.setRbTrapRestoreDefaults(defaults);
        this.fireCommand(command);
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.traps";
        }
        return "ngnms.rb.help.tdd_traps";
    }
}

