/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.TrapsControlPanel;
import com.bwanms.rb.gui.configuration.TrapsControlPanelController;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.RbTrapConfigTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapsControlConfigForm
extends ManagedObjectsConfigForm<TrapsControlPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TrapsControlConfigForm.class);
    private boolean isTDD;

    public TrapsControlPanel initUIComponent() {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) < 0) {
            this.setTDD(false);
        } else {
            this.setTDD(true);
        }
        TrapsControlPanel panel = new TrapsControlPanel();
        SimpleRowTableModel model = (SimpleRowTableModel)panel.getTblTraps().getModel();
        if (!this.isTDD()) {
            for (Integer i : TrapsControlPanelController.traps.keySet()) {
                model.addNewRow(i.toString(), true);
                model.setInitialValueAt((Object)i, TrapsControlPanelController.trapsNo.get(i).intValue(), 0);
                model.setInitialValueAt((Object)TrapsControlPanelController.traps.get(i), TrapsControlPanelController.trapsNo.get(i).intValue(), 1);
            }
        } else {
            for (Integer i : TrapsControlPanelController.trapsTDD.keySet()) {
                model.addNewRow(i.toString(), true);
                model.setInitialValueAt((Object)i, TrapsControlPanelController.trapsNoTDD.get(i).intValue(), 0);
                model.setInitialValueAt((Object)TrapsControlPanelController.trapsTDD.get(i), TrapsControlPanelController.trapsNoTDD.get(i).intValue(), 1);
            }
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder binder = new TableBinder(i18n, (SimpleRowTableModel)((TrapsControlPanel)this.getUI()).getTblTraps().getModel(), (SNMPTableMO)managedObjects.get(0));
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbTrapConfigTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbTrapConfigTable trapCfgTbl = (RbTrapConfigTable)((Object)managedObjects.get(0));
        List trapCfg = trapCfgTbl.getEntries();
        SimpleRowTableModel model = (SimpleRowTableModel)((TrapsControlPanel)this.getUI()).getTblTraps().getModel();
        FormUtil.cancelTableEditing((JTable)((TrapsControlPanel)this.getUI()).getTblTraps());
        for (RbTrapConfigEntry trap : trapCfg) {
            Integer rowIdx = TrapsControlPanelController.trapsNo.get(trap.getTrapId());
            if (rowIdx == null) continue;
            model.setRowState(rowIdx.intValue(), 0);
            model.setInitialValueAt((Object)trap.getTrapEnable(), rowIdx.intValue(), 2);
            model.setInitialValueAt((Object)trap.getTrapSeverity(), rowIdx.intValue(), 3);
            model.setInitialValueAt((Object)trap.getTrapSuppressionInterval(), rowIdx.intValue(), 4);
        }
        TableUtil.autoResizeColumn((JTable)((TrapsControlPanel)this.getUI()).getTblTraps(), (int)0, (boolean)true);
        model.sort();
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        SimpleRowTableModel model = (SimpleRowTableModel)((TrapsControlPanel)this.getUI()).getTblTraps().getModel();
        FormUtil.stopTableEditing((JTable)((TrapsControlPanel)this.getUI()).getTblTraps());
        RbTrapConfigTable trapCfgTbl = (RbTrapConfigTable)((Object)managedObjects.get(0));
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            switch (model.getRowState(i)) {
                case 3: {
                    RbTrapConfigEntry entry = (RbTrapConfigEntry)trapCfgTbl.findEntry("1." + model.getValueAt(i, 0));
                    if (entry != null) {
                        entry.setTrapEnable((Integer)model.getValueAt(i, 2));
                        entry.setTrapSeverity((Integer)model.getValueAt(i, 3));
                        try {
                            entry.setTrapSuppressionInterval(Integer.parseInt(model.getValueAt(i, 4).toString()));
                        }
                        catch (NumberFormatException nfe) {
                            invalidValues.add(new InvalidValue(i18n.translateString("valueNotInRange", new Object[]{"0", "86400"}), RbTrapConfigEntry.class, i18n.translateString("trapSuppressionInterval"), (Object)model.getValueAt(i, 4).toString(), (Object)entry));
                        }
                        continue block5;
                    }
                    model.revertRow(i);
                }
            }
        }
    }

    public String getTitle() {
        return "TrapsControl";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.traps";
        }
        return "ngnms.rb.help.tdd_traps";
    }

    public boolean isTDD() {
        return this.isTDD;
    }

    public void setTDD(boolean isTDD) {
        this.isTDD = isTDD;
    }
}

