/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.rb.gui.configuration.SwMBSUpgradeSettingsPanel;
import com.bwanms.rb.gui.configuration.SwUpgradeSettingsPanel;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SwUpgradeSettingsController
implements TableModelListener {
    private Hashtable<SimpleRowTableModel, JButton> revertButtons = new Hashtable();
    private Hashtable<SimpleRowTableModel, JButton> clearButtons = new Hashtable();
    private Hashtable<SimpleRowTableModel, JTable> tables = new Hashtable();

    public SwUpgradeSettingsController(SwUpgradeSettingsPanel form) {
        this.revertButtons.put(form.getTblCPEModel(), form.getBtnCPERevert());
        this.revertButtons.put(form.getTblSectorModel(), form.getBtnSectorRevert());
        this.clearButtons.put(form.getTblCPEModel(), form.getBtnCPEClear());
        this.clearButtons.put(form.getTblSectorModel(), form.getBtnClearAll());
        this.tables.put(form.getTblCPEModel(), form.getTblCPE());
        this.tables.put(form.getTblSectorModel(), form.getTblSector());
    }

    public SwUpgradeSettingsController(SwMBSUpgradeSettingsPanel form) {
        this.revertButtons.put(form.getTblCPEModel(), form.getBtnCPERevert());
        this.clearButtons.put(form.getTblCPEModel(), form.getBtnCPEClear());
        this.tables.put(form.getTblCPEModel(), form.getTblCPE());
    }

    public void btnRevertMouseClicked(JTable table) {
        int[] selectedRows;
        SimpleRowTableModel model = (SimpleRowTableModel)table.getModel();
        for (int row : selectedRows = table.getSelectedRows()) {
            model.revertRow(row);
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.controlTableButtons((SimpleRowTableModel)e.getSource());
    }

    public void controlTableButtons(SimpleRowTableModel model) {
        JButton revertButton = this.revertButtons.get(model);
        JButton clearButton = this.clearButtons.get(model);
        int row = this.tables.get(model).getSelectedRow();
        if (row == -1) {
            clearButton.setEnabled(false);
        } else {
            clearButton.setEnabled(true);
        }
        if (row < 0 || row >= model.getRowCount()) {
            revertButton.setEnabled(false);
            return;
        }
        if (model.getRowState(row) == 0) {
            revertButton.setEnabled(false);
        } else if (model.getRowState(row) == 1 || model.getRowState(row) == 3) {
            revertButton.setEnabled(true);
        } else {
            revertButton.setEnabled(true);
        }
    }
}

