/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.RbClearBstAuSwUpgradeParams;
import com.bwanms.rb.command.RbClearBstSuSwUpgradeParams;
import com.bwanms.rb.command.RbClearSectorSuSwUpgradeParams;
import com.bwanms.rb.gui.configuration.SwUpgradeSettingsPanel;
import com.bwanms.rb.mo.RbSwAuConfigEntry;
import com.bwanms.rb.mo.RbSwAuConfigTable;
import com.bwanms.rb.mo.RbSwRegisteredSuEntry;
import com.bwanms.rb.mo.RbSwRegisteredSuTable;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwUpgradeSettingsConfigForm
extends ManagedObjectsConfigForm<SwUpgradeSettingsPanel> {
    private static final Logger logger = Logger.getLogger(SwUpgradeSettingsConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SwUpgradeSettingsConfigForm.class);
    private boolean bsInIpCsMode;

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbSwUpgrade.class));
        ret.add(this.ctx.createRequest("BS", RbSwRegisteredSuTable.class));
        ret.add(this.ctx.createRequest("BS", RbSwAuConfigTable.class));
        return ret;
    }

    public void clearAllBstAuSwUpgradeParams() {
        RbClearBstAuSwUpgradeParams command = new RbClearBstAuSwUpgradeParams();
        command.setRbBstClearAllAuSwUpgradeParams(2);
        command.setEquipmentId(this.ctx.getEquipment().getId());
        this.fireCommand(command);
    }

    public void clearAllBstSuSwUpgradeParams() {
        RbClearBstSuSwUpgradeParams command = new RbClearBstSuSwUpgradeParams();
        command.setRbBstClearAllSuSwUpgradeParams(2);
        command.setEquipmentId(this.ctx.getEquipment().getId());
        this.fireCommand(command);
    }

    public void clearAllSectorSuSwUpgradeParams(Integer[] sectors) {
        for (Integer sector : sectors) {
            RbClearSectorSuSwUpgradeParams command = new RbClearSectorSuSwUpgradeParams();
            command.setRbAuClearAllSuSwUpgradeParams(2);
            command.setEquipmentId(this.ctx.getEquipment().getId());
            command.setRbSlotNumber(sector);
            this.fireCommand(command);
        }
    }

    protected SwUpgradeSettingsPanel initUIComponent() {
        SwUpgradeSettingsPanel panel = new SwUpgradeSettingsPanel(this);
        boolean bl = this.bsInIpCsMode = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS;
        if (this.bsInIpCsMode) {
            panel.getPnlAuStandard().setVisible(false);
            panel.getPnlSuStandard().setVisible(false);
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        if (!this.bsInIpCsMode) {
            binder.add((Binding)new JComboBoxBinding(i18n, "cmbAU16aActivation", "RbSwAuDefaultAction"));
            binder.add((Binding)new JComboBoxBinding(i18n, "cmbCPE16aActivation", "RbSwSuDefaultAction"));
        }
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbAU16siActivation", "RbSwAuSiDefaultAction"));
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCPE16siActivation", "RbSwSuSiDefaultAction"));
        binders.add((Binder)binder);
    }

    public void fillUI(List<Object> managedObjects) {
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        if (swUpgrade != null) {
            String[] auFiles = this.getFiles(swUpgrade.getRbSwAuFiles());
            String[] suFiles = this.getFiles(swUpgrade.getRbSwSuFiles());
            JComboBox<String> auFilesCombo = new JComboBox<String>(auFiles);
            auFilesCombo.addItem(i18n.translateString("none"));
            JComboBox<String> suFilesCombo = new JComboBox<String>(suFiles);
            suFilesCombo.addItem(i18n.translateString("none"));
            if (!this.bsInIpCsMode) {
                this.fillComboBox(swUpgrade.getRbSwAuDefaultFile(), auFiles, ((SwUpgradeSettingsPanel)this.getUI()).getCmbAU16aFileName());
                this.fillComboBox(swUpgrade.getRbSwSuDefaultFile(), suFiles, ((SwUpgradeSettingsPanel)this.getUI()).getCmbCPE16aFileName());
            }
            this.fillComboBox(swUpgrade.getRbSwAuSiDefaultFile(), auFiles, ((SwUpgradeSettingsPanel)this.getUI()).getCmbAU16siFileName());
            this.fillComboBox(swUpgrade.getRbSwSuSiDefaultFile(), suFiles, ((SwUpgradeSettingsPanel)this.getUI()).getCmbCPE16siFileName());
            FormUtil.cancelTableEditing((JTable)((SwUpgradeSettingsPanel)this.getUI()).getTblCPE());
            FormUtil.cancelTableEditing((JTable)((SwUpgradeSettingsPanel)this.getUI()).getTblSector());
            DefaultCellEditor auFilesCellEditor = new DefaultCellEditor(auFilesCombo);
            auFilesCellEditor.setClickCountToStart(2);
            DefaultCellEditor suFilesCellEditor = new DefaultCellEditor(suFilesCombo);
            suFilesCellEditor.setClickCountToStart(2);
            ((SwUpgradeSettingsPanel)this.getUI()).getTblSector().getColumnModel().getColumn(2).setCellEditor(auFilesCellEditor);
            ((SwUpgradeSettingsPanel)this.getUI()).getTblSector().getColumnModel().getColumn(4).setCellEditor(suFilesCellEditor);
            ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().clearTable();
            RbSwAuConfigTable swAuConfigTable = (RbSwAuConfigTable)((Object)managedObjects.get(2));
            if (swAuConfigTable != null) {
                int row = 0;
                for (RbSwAuConfigEntry entry : swAuConfigTable.getEntries()) {
                    int col = 0;
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().addNewRow(entry.getRowKey(), true);
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)entry.getRbSlotNumber(), row, col++);
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)i18n.translateString(RbSwAuConfigEntry.toStringRbAuAirInterfaceType(entry.getRbAuAirInterfaceType())), row, col++);
                    if (entry.getRbAuUpgradeSwFileName().trim().length() == 0 || swUpgrade.getRbSwAuFiles().indexOf(entry.getRbAuUpgradeSwFileName()) == -1) {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)i18n.translateString("none"), row, col++);
                    } else {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)entry.getRbAuUpgradeSwFileName(), row, col++);
                    }
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)entry.getRbAuUnitControl(), row, col++);
                    if (entry.getRbAuSuUpgradeSwFileName().trim().length() == 0 || swUpgrade.getRbSwSuFiles().indexOf(entry.getRbAuSuUpgradeSwFileName()) == -1) {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)i18n.translateString("none"), row, col++);
                    } else {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)entry.getRbAuSuUpgradeSwFileName(), row, col++);
                    }
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setInitialValueAt((Object)entry.getRbAuSuUpgradeSwAction(), row, col++);
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().setRowState(row++, 0);
                }
            }
            ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel().sort();
            ((SwUpgradeSettingsPanel)this.getUI()).getTblCPE().getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(suFilesCombo));
            ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().clearTable();
            RbSwRegisteredSuTable swRegisteredSuTable = (RbSwRegisteredSuTable)((Object)managedObjects.get(1));
            if (swRegisteredSuTable != null) {
                int row = 0;
                for (RbSwRegisteredSuEntry entry : swRegisteredSuTable.getEntries()) {
                    int col = 0;
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().addNewRow(entry.getRowKey(), true);
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)entry.getRbSuSysName(), row, col++);
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString(), row, col++);
                    if (entry.getRbAuId() != 255) {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)("AU " + entry.getRbAuId()), row, col);
                    }
                    if (entry.getRbSuUpgradeSwFileName().trim().length() == 0 || swUpgrade.getRbSwSuFiles().indexOf(entry.getRbSuUpgradeSwFileName()) == -1) {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)i18n.translateString("none"), row, ++col);
                    } else {
                        ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)entry.getRbSuUpgradeSwFileName(), row, ++col);
                    }
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)entry.getRbSuUnitControl(), row, ++col);
                    ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setRowState(row++, 0);
                }
            }
            ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel().sort();
        }
    }

    private String[] getFiles(String files) {
        StringTokenizer filesTokenizer = new StringTokenizer(files, ";");
        String[] ret = new String[filesTokenizer.countTokens()];
        int i = 0;
        while (filesTokenizer.hasMoreTokens()) {
            String fileName = filesTokenizer.nextToken();
            if (fileName == null) continue;
            ret[i++] = fileName;
        }
        return ret;
    }

    private void fillComboBox(String defaultFile, String[] files, JComboBox combo) {
        boolean addDefault = true;
        combo.removeAllItems();
        combo.addItem(i18n.translateString("none"));
        for (String file : files) {
            if (file.equals(defaultFile)) {
                addDefault = false;
            }
            combo.addItem(file);
        }
        if (addDefault && defaultFile != null && defaultFile.trim().length() != 0) {
            combo.addItem(defaultFile);
        }
        combo.setSelectedItem(defaultFile);
    }

    protected void configureMOs(List<Object> managedObjects) {
        String fileName;
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        if (!this.bsInIpCsMode) {
            fileName = ((SwUpgradeSettingsPanel)this.getUI()).getCmbAU16aFileName().getSelectedItem().toString();
            swUpgrade.setRbSwAuDefaultFile(fileName.equals(i18n.translateString("none")) ? "" : fileName);
            fileName = ((SwUpgradeSettingsPanel)this.getUI()).getCmbCPE16aFileName().getSelectedItem().toString();
            swUpgrade.setRbSwSuDefaultFile(fileName.equals(i18n.translateString("none")) ? "" : fileName);
        }
        swUpgrade.setRbSwAuSiDefaultFile((fileName = ((SwUpgradeSettingsPanel)this.getUI()).getCmbAU16siFileName().getSelectedItem().toString()).equals(i18n.translateString("none")) ? "" : fileName);
        fileName = ((SwUpgradeSettingsPanel)this.getUI()).getCmbCPE16siFileName().getSelectedItem().toString();
        swUpgrade.setRbSwSuSiDefaultFile(fileName.equals(i18n.translateString("none")) ? "" : fileName);
        SimpleRowTableModel model = ((SwUpgradeSettingsPanel)this.getUI()).getTblSectorModel();
        FormUtil.stopTableEditing((JTable)((SwUpgradeSettingsPanel)this.getUI()).getTblSector());
        RbSwAuConfigTable auTable = (RbSwAuConfigTable)((Object)managedObjects.get(2));
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getRowState(i) != 3) continue;
            RbSwAuConfigEntry entry = (RbSwAuConfigEntry)auTable.findEntry(model.getValueAt(i, 0).toString());
            if (entry != null) {
                fileName = (String)model.getValueAt(i, 2);
                entry.setRbAuUpgradeSwFileName(i18n.translateString("none").equals(fileName) ? "" : fileName);
                entry.setRbAuUnitControl((Integer)model.getValueAt(i, 3));
                fileName = (String)model.getValueAt(i, 4);
                entry.setRbAuSuUpgradeSwFileName(i18n.translateString("none").equals(fileName) ? "" : fileName);
                entry.setRbAuSuUpgradeSwAction((Integer)model.getValueAt(i, 5));
                continue;
            }
            logger.error((Object)("SwUpgradeSettingsConfigForm - configureMOs(List) - System inconsistency. The modified RbSwAuConfigEntry at line " + (i + 1) + " was already removed from system."));
        }
        model = ((SwUpgradeSettingsPanel)this.getUI()).getTblCPEModel();
        FormUtil.stopTableEditing((JTable)((SwUpgradeSettingsPanel)this.getUI()).getTblCPE());
        RbSwRegisteredSuTable suTable = (RbSwRegisteredSuTable)((Object)managedObjects.get(1));
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getRowState(i) != 3) continue;
            RbSwRegisteredSuEntry entry = (RbSwRegisteredSuEntry)suTable.findEntry(MacAddress.fromDashedString((String)model.getValueAt(i, 1).toString()).toOctetString());
            if (entry != null) {
                fileName = (String)model.getValueAt(i, 3);
                entry.setRbSuUpgradeSwFileName(i18n.translateString("none").equals(fileName) ? "" : fileName);
                entry.setRbSuUnitControl((Integer)model.getValueAt(i, 4));
                continue;
            }
            logger.error((Object)("SwUpgradeSettingsConfigForm - configureMOs(List) - System inconsistency. The modified RbSwRegisteredSuEntry at line " + (i + 1) + " was already removed from system."));
        }
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_software_upgrade_settings";
    }
}

